/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.equipment.AssetService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentFacadeService;
import ch.cern.eam.wshub.core.services.equipment.PositionService;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.equipment.impl.AssetServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentTools;
import ch.cern.eam.wshub.core.services.equipment.impl.PositionServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.SystemServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class EquipmentFacadeServiceImpl
implements EquipmentFacadeService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private AssetService assetService;
    private PositionService positionService;
    private SystemService systemService;
    private EquipmentTools equipmentTools;

    public EquipmentFacadeServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.assetService = new AssetServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
        this.positionService = new PositionServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
        this.systemService = new SystemServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
        this.equipmentTools = new EquipmentTools(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createEquipmentBatch(EAMContext eamContext, List<Equipment> equipmentList) {
        return this.tools.batchOperation(eamContext, this::createEquipment, equipmentList);
    }

    @Override
    public BatchResponse<Equipment> readEquipmentBatch(EAMContext eamContext, List<String> equipmentCodes) {
        return this.tools.batchOperation(eamContext, this::readEquipment, equipmentCodes);
    }

    @Override
    public BatchResponse<String> updateEquipmentBatch(EAMContext eamContext, List<Equipment> equipmentList) {
        return this.tools.batchOperation(eamContext, this::updateEquipment, equipmentList);
    }

    @Override
    public BatchResponse<String> deleteEquipmentBatch(EAMContext eamContext, List<String> equipmentCodes) {
        return this.tools.batchOperation(eamContext, this::deleteEquipment, equipmentCodes);
    }

    @Override
    public String updateEquipment(EAMContext eamContext, Equipment equipment) throws EAMException {
        if (equipment.getSystemTypeCode() == null) {
            equipment.setSystemTypeCode(this.equipmentTools.getEquipmentSystemTypeForEquipment(eamContext, equipment.getCode(), equipment.getOrganization()));
        }
        switch (equipment.getSystemTypeCode()) {
            case "A": {
                return this.assetService.updateAsset(eamContext, equipment);
            }
            case "P": {
                return this.positionService.updatePosition(eamContext, equipment);
            }
            case "S": {
                return this.systemService.updateSystem(eamContext, equipment);
            }
            case "L": {
                throw Tools.generateFault("Locations are not available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Wrong equipment type.");
    }

    @Override
    public String createEquipment(EAMContext eamContext, Equipment equipment) throws EAMException {
        if (equipment.getTypeCode() == null) {
            throw Tools.generateFault("Equipment type can not be empty.");
        }
        if (equipment.getSystemTypeCode() == null) {
            equipment.setSystemTypeCode(this.equipmentTools.getEquipmentSystemTypeForUserType(eamContext, equipment.getTypeCode()));
        }
        switch (equipment.getSystemTypeCode()) {
            case "A": {
                return this.assetService.createAsset(eamContext, equipment);
            }
            case "P": {
                return this.positionService.createPosition(eamContext, equipment);
            }
            case "S": {
                return this.systemService.createSystem(eamContext, equipment);
            }
            case "L": {
                throw Tools.generateFault("Locations are not available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    @Override
    public Equipment readEquipment(EAMContext eamContext, String equipmentCode) throws EAMException {
        String equipmentTypeCode;
        String code = Tools.extractEntityCode(equipmentCode);
        String organization = Tools.extractOrganizationCode(equipmentCode);
        switch (equipmentTypeCode = this.equipmentTools.getEquipmentSystemTypeForEquipment(eamContext, code, organization)) {
            case "A": {
                return this.assetService.readAsset(eamContext, code, organization);
            }
            case "P": {
                return this.positionService.readPosition(eamContext, code, organization);
            }
            case "S": {
                return this.systemService.readSystem(eamContext, code, organization);
            }
            case "L": {
                throw Tools.generateFault("Locations are no longer available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    @Override
    public String deleteEquipment(EAMContext eamContext, String equipmentCode) throws EAMException {
        String equipmentTypeCode;
        String code = Tools.extractEntityCode(equipmentCode);
        String organization = Tools.extractOrganizationCode(equipmentCode);
        switch (equipmentTypeCode = this.equipmentTools.getEquipmentSystemTypeForEquipment(eamContext, code, organization)) {
            case "A": {
                return this.assetService.deleteAsset(eamContext, code, organization);
            }
            case "P": {
                return this.positionService.deletePosition(eamContext, code, organization);
            }
            case "S": {
                return this.systemService.deleteSystem(eamContext, code, organization);
            }
            case "L": {
                throw Tools.generateFault("Locations are no longer available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    @Override
    public String readEquipmentType(EAMContext eamContext, String equipmentCode) throws EAMException {
        return this.equipmentTools.getEquipmentSystemTypeForEquipment(eamContext, Tools.extractEntityCode(equipmentCode), Tools.extractOrganizationCode(equipmentCode));
    }
}

