/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.equipment.LocationService;
import ch.cern.eam.wshub.core.services.equipment.entities.Location;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import net.datastream.schemas.mp_entities.location_001.LocationParentHierarchy;
import net.datastream.schemas.mp_entities.location_001.ParentLocation;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0317_001.MP0317_AddLocation_001;
import net.datastream.schemas.mp_functions.mp0318_001.MP0318_GetLocation_001;
import net.datastream.schemas.mp_functions.mp0319_001.MP0319_SyncLocation_001;
import net.datastream.schemas.mp_functions.mp0320_001.MP0320_DeleteLocation_001;
import net.datastream.schemas.mp_functions.mp0361_001.MP0361_GetLocationParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0318_001.MP0318_GetLocation_001_Result;
import net.datastream.schemas.mp_results.mp0361_001.MP0361_GetLocationParentHierarchy_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class LocationServiceImpl
implements LocationService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public LocationServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public BatchResponse<String> createLocationBatch(EAMContext context, List<Location> locations) {
        return this.tools.batchOperation(context, this::createLocation, locations);
    }

    @Override
    public BatchResponse<Location> readLocationBatch(EAMContext context, List<String> locationCodes) {
        return this.tools.batchOperation(context, this::readLocation, locationCodes);
    }

    @Override
    public BatchResponse<String> updateLocationBatch(EAMContext context, List<Location> locations) {
        return this.tools.batchOperation(context, this::updateLocation, locations);
    }

    @Override
    public BatchResponse<String> deleteLocationBatch(EAMContext context, List<String> locationCodes) {
        return this.tools.batchOperation(context, this::deleteLocation, locationCodes);
    }

    @Override
    public Location readLocation(EAMContext context, String locationCode) throws EAMException {
        MP0318_GetLocation_001 getLocation = new MP0318_GetLocation_001();
        getLocation.setLOCATIONID(new LOCATIONID_Type());
        getLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getLocation.getLOCATIONID().setLOCATIONCODE(locationCode);
        MP0318_GetLocation_001_Result getLocationResult = new MP0318_GetLocation_001_Result();
        getLocationResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLocation);
        net.datastream.schemas.mp_entities.location_001.Location locationEAM = getLocationResult.getResultData().getLocation();
        Location location = this.tools.getEAMFieldTools().transformEAMObject(new Location(), locationEAM, context);
        if (locationEAM.getParentLocationID() != null) {
            location.setHierarchyLocationCode(locationEAM.getParentLocationID().getLOCATIONCODE());
        }
        return location;
    }

    @Override
    public String createLocation(EAMContext context, Location locationParam) throws EAMException {
        net.datastream.schemas.mp_entities.location_001.Location locationEAM = new net.datastream.schemas.mp_entities.location_001.Location();
        locationEAM.setLOCATIONID(new LOCATIONID_Type());
        locationEAM.getLOCATIONID().setLOCATIONCODE(locationParam.getCode());
        locationEAM.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        locationEAM.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(locationEAM.getCLASSID()), locationEAM.getUSERDEFINEDAREA(), locationParam.getClassCode(), "LOC"));
        this.tools.getEAMFieldTools().transformWSHubObject(locationEAM, locationParam, context);
        if (locationParam.getHierarchyLocationCode() != null) {
            locationEAM.setLocationParentHierarchy(this.getLocationParentHierarchy(context, locationParam));
        }
        MP0317_AddLocation_001 addLocation = new MP0317_AddLocation_001();
        addLocation.setLocation(locationEAM);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addLocation);
        return locationEAM.getLOCATIONID().getLOCATIONCODE();
    }

    @Override
    public String updateLocation(EAMContext context, Location locationParam) throws EAMException {
        MP0318_GetLocation_001 getLocation = new MP0318_GetLocation_001();
        getLocation.setLOCATIONID(new LOCATIONID_Type());
        getLocation.getLOCATIONID().setLOCATIONCODE(locationParam.getCode());
        getLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP0318_GetLocation_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLocation);
        net.datastream.schemas.mp_entities.location_001.Location locationEAM = result.getResultData().getLocation();
        locationEAM.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(locationEAM.getCLASSID()), locationEAM.getUSERDEFINEDAREA(), locationParam.getClassCode(), "LOC"));
        if (locationParam.getHierarchyLocationCode() == null) {
            locationParam.setHierarchyLocationCode(DataTypeTools.toCodeString(locationEAM.getParentLocationID()));
        }
        if (locationParam.getHierarchyLocationCode() != null && !locationParam.getHierarchyLocationCode().equals("")) {
            locationEAM.setLocationParentHierarchy(this.getLocationParentHierarchy(context, locationParam));
        }
        locationEAM.setParentLocationID(null);
        this.tools.getEAMFieldTools().transformWSHubObject(locationEAM, locationParam, context);
        MP0319_SyncLocation_001 syncLocation = new MP0319_SyncLocation_001();
        syncLocation.setLocation(locationEAM);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncLocation);
        return locationEAM.getLOCATIONID().getLOCATIONCODE();
    }

    @Override
    public String deleteLocation(EAMContext context, String locationCode) throws EAMException {
        MP0320_DeleteLocation_001 deleteLocation = new MP0320_DeleteLocation_001();
        deleteLocation.setLOCATIONID(new LOCATIONID_Type());
        deleteLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteLocation.getLOCATIONID().setLOCATIONCODE(locationCode);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteLocation);
        return locationCode;
    }

    private LocationParentHierarchy getLocationParentHierarchy(EAMContext context, String locationCode) throws EAMException {
        MP0361_GetLocationParentHierarchy_001 getLocationParentHierarchy = new MP0361_GetLocationParentHierarchy_001();
        getLocationParentHierarchy.setLOCATIONID(new LOCATIONID_Type());
        getLocationParentHierarchy.getLOCATIONID().setLOCATIONCODE(locationCode);
        getLocationParentHierarchy.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP0361_GetLocationParentHierarchy_001_Result getLocationParentHierarchyResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getLocationParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLocationParentHierarchy);
        return getLocationParentHierarchyResult.getResultData().getLocationParentHierarchy();
    }

    private LocationParentHierarchy getLocationParentHierarchy(EAMContext context, Location location) {
        if (location.getHierarchyLocationCode() == null) {
            return null;
        }
        LocationParentHierarchy locationParentHierarchy = new LocationParentHierarchy();
        TYPE_Type lType = new TYPE_Type();
        lType.setTYPECODE("L");
        lType.setDESCRIPTION("Localisation");
        locationParentHierarchy.setLOCATIONID(new LOCATIONID_Type());
        locationParentHierarchy.getLOCATIONID().setLOCATIONCODE(location.getCode());
        locationParentHierarchy.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        locationParentHierarchy.setTYPE(lType);
        ParentLocation parentLocation = new ParentLocation();
        parentLocation.setTYPE(lType);
        parentLocation.setLOCATIONID(new LOCATIONID_Type());
        parentLocation.getLOCATIONID().setLOCATIONCODE(location.getHierarchyLocationCode());
        parentLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        parentLocation.setDEPARTMENTID(new DEPARTMENTID_Type());
        parentLocation.getDEPARTMENTID().setDEPARTMENTCODE("*");
        parentLocation.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        locationParentHierarchy.setParentLocation(parentLocation);
        return locationParentHierarchy;
    }
}

