/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.equipment.PositionService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentHierarchyTools;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.datastream.schemas.mp_entities.positionequipment_001.PositionEquipment;
import net.datastream.schemas.mp_entities.positionhierarchy_002.PositionParentHierarchy;
import net.datastream.schemas.mp_fields.ASSETPARENT_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.POSITIONPARENT_Type;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0306_001.MP0306_AddPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0307_001.MP0307_GetPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0308_001.MP0308_SyncPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0309_001.MP0309_DeletePositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0310_001.MP0310_GetPositionEquipmentDefault_001;
import net.datastream.schemas.mp_functions.mp0328_002.MP0328_GetPositionParentHierarchy_002;
import net.datastream.schemas.mp_results.mp0306_001.MP0306_AddPositionEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0307_001.MP0307_GetPositionEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0310_001.MP0310_GetPositionEquipmentDefault_001_Result;
import net.datastream.schemas.mp_results.mp0328_002.MP0328_GetPositionParentHierarchy_002_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class PositionServiceImpl
implements PositionService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private UserDefinedListService userDefinedListService;

    public PositionServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.userDefinedListService = new UserDefinedListServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public String createPosition(EAMContext context, Equipment positionParam) throws EAMException {
        PositionEquipment positionEquipment = new PositionEquipment();
        positionEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(positionEquipment.getCLASSID()), positionEquipment.getUSERDEFINEDAREA(), positionParam.getClassCode(), "OBJ"));
        this.initializePositionObject(context, positionEquipment, positionParam);
        this.tools.getEAMFieldTools().transformWSHubObject(positionEquipment, positionParam, context);
        MP0306_AddPositionEquipment_001 addPosition = new MP0306_AddPositionEquipment_001();
        addPosition.setPositionEquipment(positionEquipment);
        MP0306_AddPositionEquipment_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addPositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPosition);
        String equipmentCode = result.getResultData().getPOSITIONID().getEQUIPMENTCODE();
        this.userDefinedListService.writeUDLToEntityCopyFrom(context, positionParam, new EntityId("OBJ", equipmentCode));
        return equipmentCode;
    }

    @Override
    public String deletePosition(EAMContext context, String positionCode, String organization) throws EAMException {
        MP0309_DeletePositionEquipment_001 deletePosition = new MP0309_DeletePositionEquipment_001();
        deletePosition.setPOSITIONID(new EQUIPMENTID_Type());
        deletePosition.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        deletePosition.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deletePositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deletePosition);
        this.userDefinedListService.deleteUDLFromEntity(context, new EntityId("OBJ", positionCode));
        return positionCode;
    }

    private PositionParentHierarchy readEAMPositionParentHierarchy(EAMContext context, String positionCode, String organization) throws EAMException {
        MP0328_GetPositionParentHierarchy_002 getpositionph = new MP0328_GetPositionParentHierarchy_002();
        getpositionph.setPOSITIONID(new EQUIPMENTID_Type());
        getpositionph.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        getpositionph.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        MP0328_GetPositionParentHierarchy_002_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getPositionParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getpositionph);
        return result.getResultData().getPositionParentHierarchy();
    }

    @Override
    public Equipment readPositionDefault(EAMContext context, String organization) throws EAMException {
        MP0310_GetPositionEquipmentDefault_001 getPositionEquipmentDefault_001 = new MP0310_GetPositionEquipmentDefault_001();
        getPositionEquipmentDefault_001.setORGANIZATIONID(this.tools.getOrganization(context, organization));
        MP0310_GetPositionEquipmentDefault_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getPositionEquipmentDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPositionEquipmentDefault_001);
        Equipment equipment = this.tools.getEAMFieldTools().transformEAMObject(new Equipment(), result.getResultData().getPositionEquipment(), context);
        equipment.setUserDefinedList(new HashMap<String, ArrayList<UDLValue>>());
        return equipment;
    }

    @Override
    public Equipment readPosition(EAMContext context, String positionCode, String organization) throws EAMException {
        PositionEquipment positionEquipment = this.readEAMPosition(context, positionCode, organization);
        Equipment position = this.tools.getEAMFieldTools().transformEAMObject(new Equipment(), positionEquipment, context);
        position.setSystemTypeCode("P");
        if (positionEquipment.getPositionParentHierarchy().getLOCATIONID() != null) {
            position.setHierarchyLocationCode(positionEquipment.getPositionParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            position.setHierarchyLocationDesc(positionEquipment.getPositionParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        position.setHierarchyAssetDependent(positionEquipment.getPositionParentHierarchy().getAssetDependency() != null);
        position.setHierarchyPositionDependent(positionEquipment.getPositionParentHierarchy().getPositionDependency() != null);
        position.setHierarchyPrimarySystemDependent(positionEquipment.getPositionParentHierarchy().getPrimarySystemDependency() != null);
        this.tools.processRunnables(() -> this.userDefinedListService.readUDLToEntity(context, position, new EntityId("OBJ", positionCode)), () -> position.setSystemStatusCode(this.tools.getFieldDescriptionsTools().readSystemCodeForUserCode(context, "OBST", position.getStatusCode())));
        return position;
    }

    private PositionEquipment readEAMPosition(EAMContext context, String positionCode, String organization) throws EAMException {
        MP0307_GetPositionEquipment_001 getPosition = new MP0307_GetPositionEquipment_001();
        getPosition.setPOSITIONID(new EQUIPMENTID_Type());
        getPosition.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        getPosition.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        MP0307_GetPositionEquipment_001_Result getAssetResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getPositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPosition);
        getAssetResult.getResultData().getPositionEquipment().setPositionParentHierarchy(this.readEAMPositionParentHierarchy(context, positionCode, organization));
        return getAssetResult.getResultData().getPositionEquipment();
    }

    @Override
    public String updatePosition(EAMContext context, Equipment positionParam) throws EAMException {
        PositionEquipment positionEquipment = this.readEAMPosition(context, positionParam.getCode(), positionParam.getOrganization());
        positionEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(positionEquipment.getCLASSID()), positionEquipment.getUSERDEFINEDAREA(), positionParam.getClassCode(), "OBJ"));
        this.initializePositionObject(context, positionEquipment, positionParam);
        this.tools.getEAMFieldTools().transformWSHubObject(positionEquipment, positionParam, context);
        MP0308_SyncPositionEquipment_001 syncPosition = new MP0308_SyncPositionEquipment_001();
        syncPosition.setPositionEquipment(positionEquipment);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncPositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPosition);
        this.userDefinedListService.writeUDLToEntity(context, positionParam, new EntityId("OBJ", positionParam.getCode()));
        return positionParam.getCode();
    }

    private void initializePositionObject(EAMContext context, PositionEquipment positionEAM, Equipment positionParam) throws EAMException {
        if (positionEAM.getPOSITIONID() == null) {
            positionEAM.setPOSITIONID(new EQUIPMENTID_Type());
            positionEAM.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context, positionParam.getOrganization()));
            positionEAM.getPOSITIONID().setEQUIPMENTCODE(positionParam.getCode().toUpperCase().trim());
        }
        if (positionParam.getDescription() != null) {
            positionEAM.getPOSITIONID().setDESCRIPTION(positionParam.getDescription());
        }
        if (positionParam.getHierarchyAssetCode() != null || positionParam.getHierarchyPositionCode() != null || positionParam.getHierarchyPrimarySystemCode() != null || positionParam.getHierarchyLocationCode() != null) {
            this.initializePositionHierarchy(positionEAM, positionParam, context);
        }
    }

    private void initializePositionHierarchy(PositionEquipment positionEAM, Equipment positionParam, EAMContext context) {
        PositionParentHierarchy hierarchy = new PositionParentHierarchy();
        hierarchy.setPOSITIONID(new EQUIPMENTID_Type());
        hierarchy.getPOSITIONID().setEQUIPMENTCODE(positionParam.getCode());
        hierarchy.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context, positionParam.getOrganization()));
        hierarchy.setTYPE(new TYPE_Type());
        hierarchy.getTYPE().setTYPECODE("A");
        ASSETPARENT_Type assetParent = EquipmentHierarchyTools.readAssetParent(positionEAM.getPositionParentHierarchy());
        POSITIONPARENT_Type positionParent = EquipmentHierarchyTools.readPositionParent(positionEAM.getPositionParentHierarchy());
        SYSTEMPARENT_Type primarySystemParent = EquipmentHierarchyTools.readPrimarySystemParent(positionEAM.getPositionParentHierarchy());
        LOCATIONPARENT_Type locationParent = EquipmentHierarchyTools.readLocationParent(positionEAM.getPositionParentHierarchy());
        List<SYSTEMPARENT_Type> systemParents = EquipmentHierarchyTools.readSystemsParent(positionEAM.getPositionParentHierarchy());
        EquipmentHierarchyTools.HIERARCHY_TYPE currentHierarchyType = EquipmentHierarchyTools.readHierarchyType(positionEAM.getPositionParentHierarchy());
        assetParent = EquipmentHierarchyTools.createAssetParent(this.tools.getOrganizationCode(context, positionParam.getHierarchyAssetOrg()), positionParam.getHierarchyAssetCode(), positionParam.getHierarchyAssetCostRollUp(), assetParent);
        positionParent = EquipmentHierarchyTools.createPositionParent(this.tools.getOrganizationCode(context, positionParam.getHierarchyPositionOrg()), positionParam.getHierarchyPositionCode(), positionParam.getHierarchyPositionCostRollUp(), positionParent);
        primarySystemParent = EquipmentHierarchyTools.createPrimarySystemParent(this.tools.getOrganizationCode(context, positionParam.getHierarchyPrimarySystemOrg()), positionParam.getHierarchyPrimarySystemCode(), positionParam.getHierarchyPrimarySystemCostRollUp(), primarySystemParent);
        locationParent = EquipmentHierarchyTools.createLocationParent(this.tools.getOrganizationCode(context), positionParam.getHierarchyLocationCode(), locationParent);
        switch (EquipmentHierarchyTools.getNewHierarchyType(positionParam, currentHierarchyType)) {
            case ASSET_DEP: {
                hierarchy.setAssetDependency(EquipmentHierarchyTools.createAssetDependencyForPosition(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case POSITION_DEP: {
                hierarchy.setPositionDependency(EquipmentHierarchyTools.createPositionDependencyForPosition(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case PRIM_SYSTEM_DEP: {
                hierarchy.setPrimarySystemDependency(EquipmentHierarchyTools.createPrimarySystemDependencyForPosition(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case LOCATION_DEP: {
                hierarchy.setLocationDependency(EquipmentHierarchyTools.createLocationDependencyForPosition(assetParent, positionParent, primarySystemParent, systemParents, locationParent));
                break;
            }
            default: {
                hierarchy.setNonDependentParents(EquipmentHierarchyTools.createNonDependentParentsForPosition(assetParent, positionParent, primarySystemParent, systemParents));
            }
        }
        positionEAM.setPositionParentHierarchy(hierarchy);
    }
}

