/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentHierarchyTools;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemEquipment;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemParentHierarchy;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_functions.mp0311_001.MP0311_AddSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0312_001.MP0312_GetSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0313_001.MP0313_SyncSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0314_001.MP0314_DeleteSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0315_001.MP0315_GetSystemEquipmentDefault_001;
import net.datastream.schemas.mp_functions.mp0329_001.MP0329_GetSystemParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0311_001.MP0311_AddSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0312_001.MP0312_GetSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0315_001.MP0315_GetSystemEquipmentDefault_001_Result;
import net.datastream.schemas.mp_results.mp0329_001.MP0329_GetSystemParentHierarchy_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class SystemServiceImpl
implements SystemService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private UserDefinedListService userDefinedListService;

    public SystemServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.userDefinedListService = new UserDefinedListServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public Equipment readSystemDefault(EAMContext context, String organization) throws EAMException {
        MP0315_GetSystemEquipmentDefault_001 getSystemEquipmentDefault_001 = new MP0315_GetSystemEquipmentDefault_001();
        getSystemEquipmentDefault_001.setORGANIZATIONID(this.tools.getOrganization(context, organization));
        MP0315_GetSystemEquipmentDefault_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getSystemEquipmentDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getSystemEquipmentDefault_001);
        Equipment equipment = this.tools.getEAMFieldTools().transformEAMObject(new Equipment(), result.getResultData().getSystemEquipment(), context);
        equipment.setUserDefinedList(new HashMap<String, ArrayList<UDLValue>>());
        return equipment;
    }

    private SystemParentHierarchy readHierarchyEAM(EAMContext context, String systemCode, String organization) throws EAMException {
        MP0329_GetSystemParentHierarchy_001 getsystemh = new MP0329_GetSystemParentHierarchy_001();
        getsystemh.setSYSTEMID(new EQUIPMENTID_Type());
        getsystemh.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        getsystemh.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        MP0329_GetSystemParentHierarchy_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getSystemParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getsystemh);
        return result.getResultData().getSystemParentHierarchy();
    }

    @Override
    public Equipment readSystem(EAMContext context, String systemCode, String organization) throws EAMException {
        SystemEquipment systemEquipment = this.readSystemEAM(context, systemCode, organization);
        Equipment system = this.tools.getEAMFieldTools().transformEAMObject(new Equipment(), systemEquipment, context);
        system.setSystemTypeCode("S");
        if (systemEquipment.getSystemParentHierarchy().getLOCATIONID() != null) {
            system.setHierarchyLocationCode(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            system.setHierarchyLocationDesc(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        system.setHierarchyPrimarySystemDependent(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM() != null);
        this.tools.processRunnables(() -> this.userDefinedListService.readUDLToEntity(context, system, new EntityId("OBJ", systemCode)), () -> system.setSystemStatusCode(this.tools.getFieldDescriptionsTools().readSystemCodeForUserCode(context, "OBST", system.getStatusCode())));
        return system;
    }

    public SystemEquipment readSystemEAM(EAMContext context, String systemCode, String organization) throws EAMException {
        MP0312_GetSystemEquipment_001 getSystem = new MP0312_GetSystemEquipment_001();
        getSystem.setSYSTEMID(new EQUIPMENTID_Type());
        getSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        getSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        MP0312_GetSystemEquipment_001_Result getAssetResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getSystem);
        getAssetResult.getResultData().getSystemEquipment().setSystemParentHierarchy(this.readHierarchyEAM(context, systemCode, organization));
        return getAssetResult.getResultData().getSystemEquipment();
    }

    @Override
    public String updateSystem(EAMContext context, Equipment systemParam) throws EAMException {
        SystemEquipment systemEquipment = this.readSystemEAM(context, systemParam.getCode(), systemParam.getOrganization());
        systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(systemEquipment.getCLASSID()), systemEquipment.getUSERDEFINEDAREA(), systemParam.getClassCode(), "OBJ"));
        this.initializeSystemObject(systemEquipment, systemParam, context);
        this.tools.getEAMFieldTools().transformWSHubObject(systemEquipment, systemParam, context);
        MP0313_SyncSystemEquipment_001 syncPosition = new MP0313_SyncSystemEquipment_001();
        syncPosition.setSystemEquipment(systemEquipment);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPosition);
        this.userDefinedListService.writeUDLToEntity(context, systemParam, new EntityId("OBJ", systemParam.getCode()));
        return systemParam.getCode();
    }

    @Override
    public String createSystem(EAMContext context, Equipment systemParam) throws EAMException {
        SystemEquipment systemEquipment = new SystemEquipment();
        systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(systemEquipment.getCLASSID()), systemEquipment.getUSERDEFINEDAREA(), systemParam.getClassCode(), "OBJ"));
        this.initializeSystemObject(systemEquipment, systemParam, context);
        this.tools.getEAMFieldTools().transformWSHubObject(systemEquipment, systemParam, context);
        MP0311_AddSystemEquipment_001 addPosition = new MP0311_AddSystemEquipment_001();
        addPosition.setSystemEquipment(systemEquipment);
        MP0311_AddSystemEquipment_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPosition);
        String systemCode = result.getResultData().getSYSTEMID().getEQUIPMENTCODE();
        this.userDefinedListService.writeUDLToEntityCopyFrom(context, systemParam, new EntityId("OBJ", systemCode));
        return systemCode;
    }

    @Override
    public String deleteSystem(EAMContext context, String systemCode, String organization) throws EAMException {
        MP0314_DeleteSystemEquipment_001 deleteSystem = new MP0314_DeleteSystemEquipment_001();
        deleteSystem.setSYSTEMID(new EQUIPMENTID_Type());
        deleteSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        deleteSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteSystem);
        this.userDefinedListService.deleteUDLFromEntity(context, new EntityId("OBJ", systemCode));
        return systemCode;
    }

    private void initializeSystemObject(SystemEquipment systemEAM, Equipment systemParam, EAMContext context) throws EAMException {
        if (systemEAM.getSYSTEMID() == null) {
            systemEAM.setSYSTEMID(new EQUIPMENTID_Type());
            systemEAM.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context, systemParam.getOrganization()));
            systemEAM.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        }
        if (systemParam.getDescription() != null) {
            systemEAM.getSYSTEMID().setDESCRIPTION(systemParam.getDescription());
        }
        if (systemParam.getHierarchyLocationCode() != null || systemParam.getHierarchyPrimarySystemCode() != null) {
            if (systemEAM.getSystemParentHierarchy() == null) {
                systemEAM.setSystemParentHierarchy(new SystemParentHierarchy());
            }
            this.populateSystemHierarchy(context, systemParam, systemEAM);
        }
    }

    private void populateSystemHierarchy(EAMContext context, Equipment systemParam, SystemEquipment systemEAM) {
        SystemParentHierarchy systemParentHierarchy = systemEAM.getSystemParentHierarchy();
        if (systemParam.getHierarchyPrimarySystemDependent() != null && systemParam.getHierarchyPrimarySystemDependent().booleanValue() && !"".equals(systemParam.getHierarchyPrimarySystemCode()) || systemParam.getHierarchyPrimarySystemDependent() == null && systemParentHierarchy.getDEPENDENTPRIMARYSYSTEM() != null && !"".equals(systemParam.getHierarchyPrimarySystemCode())) {
            systemParentHierarchy.setDEPENDENTLOCATION(null);
            systemParentHierarchy.setDEPENDENTPRIMARYSYSTEM(EquipmentHierarchyTools.createPrimarySystemParent(this.tools.getOrganizationCode(context, systemParam.getHierarchyPrimarySystemOrg()), systemParam.getHierarchyPrimarySystemCode(), systemParam.getHierarchyPrimarySystemCostRollUp(), systemParentHierarchy.getDEPENDENTPRIMARYSYSTEM()));
        } else {
            systemParentHierarchy.setDEPENDENTPRIMARYSYSTEM(null);
            systemParentHierarchy.setDEPENDENTLOCATION(EquipmentHierarchyTools.createLocationParent(this.tools.getOrganizationCode(context), systemParam.getHierarchyLocationCode(), systemParentHierarchy.getDEPENDENTLOCATION()));
            systemParentHierarchy.setNONDEPENDENTPRIMARYSYSTEM(EquipmentHierarchyTools.createPrimarySystemParent(this.tools.getOrganizationCode(context, systemParam.getHierarchyPrimarySystemOrg()), systemParam.getHierarchyPrimarySystemCode(), systemParam.getHierarchyPrimarySystemCostRollUp(), systemParentHierarchy.getNONDEPENDENTPRIMARYSYSTEM()));
        }
    }
}

