/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.entities;

import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestSort;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GridRequest
implements Serializable {
    private static final long serialVersionUID = 6690766576660475229L;
    private String gridID;
    private String dataspyID;
    private Integer rowCount;
    private Integer cursorPosition;
    private String userFunctionName;
    private String gridName;
    private GRIDTYPE gridType = GRIDTYPE.LIST;
    private Boolean useNative = true;
    private String JPAType;
    private Boolean countTotal = false;
    private Boolean queryTimeout = false;
    private Integer queryTimeoutWaitingTime = 15000;
    private String lang = "EN";
    private Boolean returnHeaderData = false;
    private Boolean includeMetadata = false;
    private Boolean fetchAllResults = false;
    private String departmentSecurityGridColumn = null;
    private Map<String, String> params;
    private List<GridRequestFilter> gridRequestFilters;
    private GridRequestSort[] gridRequestSorts;

    public GridRequest() {
        this.cursorPosition = 1;
        this.rowCount = 100;
    }

    public GridRequest(String gridName) {
        this();
        this.gridName = gridName;
    }

    public GridRequest(String gridName, Integer rowCount) {
        this();
        this.rowCount = rowCount;
        this.gridName = gridName;
    }

    public GridRequest(String gridName, GRIDTYPE gridType) {
        this();
        this.gridName = gridName;
        this.gridType = gridType;
    }

    public GridRequest(String gridID, String gridName, String dataspyID) {
        this();
        this.gridID = gridID;
        this.dataspyID = dataspyID;
        this.gridName = gridName;
    }

    public GridRequest(String gridName, GRIDTYPE gridType, Integer rowCount) {
        this();
        this.gridName = gridName;
        this.gridType = gridType;
        this.rowCount = rowCount;
    }

    public GridRequest(GridRequest o) {
        this.gridID = o.gridID;
        this.dataspyID = o.dataspyID;
        this.rowCount = o.rowCount;
        this.cursorPosition = o.cursorPosition;
        this.gridName = o.gridName;
        this.gridType = o.gridType;
        this.useNative = o.useNative;
        this.JPAType = o.JPAType;
        this.countTotal = o.countTotal;
        this.queryTimeout = o.queryTimeout;
        this.queryTimeoutWaitingTime = o.queryTimeoutWaitingTime;
        this.params = o.params;
        this.gridRequestFilters = o.gridRequestFilters;
        this.gridRequestSorts = o.gridRequestSorts;
        this.fetchAllResults = o.fetchAllResults;
        this.departmentSecurityGridColumn = o.departmentSecurityGridColumn;
    }

    public String getGridID() {
        return this.gridID;
    }

    public void setGridID(String gridID) {
        this.gridID = gridID;
    }

    public String getDataspyID() {
        return this.dataspyID;
    }

    public void setDataspyID(String dataspyID) {
        this.dataspyID = dataspyID;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Integer rowCount) {
        this.rowCount = rowCount;
    }

    public Integer getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(Integer cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public String getGridName() {
        return this.gridName;
    }

    public void setGridName(String gridName) {
        this.gridName = gridName;
    }

    public Boolean getReturnHeaderData() {
        return this.returnHeaderData;
    }

    public void setReturnHeaderData(Boolean returnHeaderData) {
        this.returnHeaderData = returnHeaderData;
    }

    public Boolean getFetchAllResults() {
        return this.fetchAllResults;
    }

    public void setFetchAllResults(Boolean fetchAllResults) {
        this.fetchAllResults = fetchAllResults;
    }

    @JsonProperty(value="gridSort")
    @XmlElementWrapper(name="gridSorts")
    @XmlElement(name="gridSort")
    public GridRequestSort[] getGridRequestSorts() {
        return this.gridRequestSorts;
    }

    public void setGridRequestSorts(GridRequestSort[] gridRequestSorts) {
        this.gridRequestSorts = gridRequestSorts;
    }

    @JsonProperty(value="gridFilter")
    @XmlElementWrapper(name="gridFilters")
    @XmlElement(name="gridFilter")
    public List<GridRequestFilter> getGridRequestFilters() {
        if (this.gridRequestFilters == null) {
            this.gridRequestFilters = new LinkedList<GridRequestFilter>();
        }
        return this.gridRequestFilters;
    }

    public void setGridRequestFilters(List<GridRequestFilter> gridRequestFilters) {
        this.gridRequestFilters = gridRequestFilters;
    }

    public GRIDTYPE getGridType() {
        return this.gridType;
    }

    public void setGridType(GRIDTYPE gridType) {
        this.gridType = gridType;
    }

    public Boolean getUseNative() {
        return this.useNative;
    }

    public void setUseNative(Boolean useNative) {
        this.useNative = useNative;
    }

    public Boolean getCountTotal() {
        return this.countTotal;
    }

    public void setCountTotal(Boolean countTotal) {
        this.countTotal = countTotal;
    }

    public Boolean getIncludeMetadata() {
        return this.includeMetadata;
    }

    public void setIncludeMetadata(Boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public Map<String, String> getParams() {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getJPAType() {
        return this.JPAType;
    }

    public void setJPAType(String jPAType) {
        this.JPAType = jPAType;
    }

    public Boolean getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Boolean queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public Integer getQueryTimeoutWaitingTime() {
        return this.queryTimeoutWaitingTime;
    }

    public void setQueryTimeoutWaitingTime(Integer queryTimeoutWaitingTime) {
        this.queryTimeoutWaitingTime = queryTimeoutWaitingTime;
    }

    public String getDepartmentSecurityGridColumn() {
        return this.departmentSecurityGridColumn;
    }

    public void setDepartmentSecurityGridColumn(String departmentSecurityGridColumn) {
        this.departmentSecurityGridColumn = departmentSecurityGridColumn;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getUserFunctionName() {
        return this.userFunctionName;
    }

    public void setUserFunctionName(String userFunctionName) {
        this.userFunctionName = userFunctionName;
    }

    public void sortBy(String sortBy) {
        this.sortBy(sortBy, "ASC");
    }

    public void sortBy(String sortBy, String order) {
        this.gridRequestSorts = new GridRequestSort[1];
        this.gridRequestSorts[0] = new GridRequestSort();
        this.gridRequestSorts[0].setSortBy(sortBy);
        this.gridRequestSorts[0].setSortType(order);
    }

    public void addFilter(String fieldName, String fieldValue, String operator) {
        this.getGridRequestFilters().add(new GridRequestFilter(fieldName, fieldValue, operator));
    }

    public void addFilter(String fieldName, String fieldValue, String operator, GridRequestFilter.JOINER joiner) {
        this.getGridRequestFilters().add(new GridRequestFilter(fieldName, fieldValue, operator, joiner));
    }

    public void addFilter(String fieldName, String fieldValue, String operator, GridRequestFilter.JOINER joiner, Boolean leftParenthesis, Boolean rightParenthesis) {
        this.getGridRequestFilters().add(new GridRequestFilter(fieldName, fieldValue, operator, joiner, leftParenthesis, rightParenthesis));
    }

    public void addParam(String key, String value) {
        this.getParams().put(key, value);
    }

    public String toString() {
        return "GridRequest [" + (String)(this.gridID != null ? "gridID=" + this.gridID + ", " : "") + (String)(this.dataspyID != null ? "dataspyID=" + this.dataspyID + ", " : "") + (String)(this.rowCount != null ? "rowCount=" + this.rowCount + ", " : "") + (String)(this.cursorPosition != null ? "cursorPosition=" + this.cursorPosition + ", " : "") + (String)(this.gridName != null ? "gridName=" + this.gridName + ", " : "") + (String)(this.gridType != null ? "gridType=" + String.valueOf((Object)this.gridType) + ", " : "") + (String)(this.useNative != null ? "useNative=" + this.useNative + ", " : "") + (String)(this.JPAType != null ? "JPAType=" + this.JPAType + ", " : "") + (String)(this.countTotal != null ? "countTotal=" + this.countTotal + ", " : "") + (String)(this.queryTimeout != null ? "queryTimeout=" + this.queryTimeout + ", " : "") + (String)(this.queryTimeoutWaitingTime != null ? "queryTimeoutWaitingTime=" + this.queryTimeoutWaitingTime + ", " : "") + (String)(this.fetchAllResults != null ? "fetchAllResults=" + this.fetchAllResults + ", " : "") + (String)(this.departmentSecurityGridColumn != null ? "departmentSecurityGridColumn=" + this.departmentSecurityGridColumn + ", " : "") + (String)(this.params != null ? "params=" + String.valueOf(this.params) + ", " : "") + (String)(this.gridRequestFilters != null ? "gridRequestFilters=" + String.valueOf(this.gridRequestFilters) + ", " : "") + (String)(this.gridRequestSorts != null ? "gridRequestSorts=" + Arrays.toString(this.gridRequestSorts) : "") + "]";
    }

    @JsonIgnore
    public String getRequestKey() {
        return String.valueOf((Object)this.getGridType()) + "#" + this.getGridName() + "#" + this.getDataspyID();
    }

    public static enum GRIDTYPE {
        LIST,
        LOV;

    }
}

