/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.material.PartLotService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.lot_001.Lot;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.LOTID_Type;
import net.datastream.schemas.mp_functions.mp1201_001.MP1201_AddLot_001;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class PartLotServiceImpl
implements PartLotService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public PartLotServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public String createLot(EAMContext context, ch.cern.eam.wshub.core.services.material.entities.Lot lot) throws EAMException {
        Lot lotEAM = new Lot();
        lotEAM.setLOTID(new LOTID_Type());
        lotEAM.getLOTID().setLOTCODE(lot.getCode());
        lotEAM.getLOTID().setDESCRIPTION(lot.getDesc());
        lotEAM.getLOTID().setORGANIZATIONID(this.tools.getOrganization(context));
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(lot.getClassCode())) {
            lotEAM.setCLASSID(new CLASSID_Type());
            lotEAM.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            lotEAM.getCLASSID().setCLASSCODE(lot.getClassCode());
        }
        if (lot.getExpirationDate() != null) {
            this.tools.getDataTypeTools();
            lotEAM.setEXPIRATIONDATE(DataTypeTools.encodeEAMDate(lot.getExpirationDate(), "Lot Expiration Date"));
        }
        if (lot.getManufacturerLot() != null) {
            lotEAM.setMANUFACTLOT(lot.getManufacturerLot());
        }
        MP1201_AddLot_001 addlot = new MP1201_AddLot_001();
        addlot.setLot(lotEAM);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addLotOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addlot);
        return lot.getCode();
    }
}

