/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.workorders.CaseTaskService;
import ch.cern.eam.wshub.core.services.workorders.entities.EAMCaseTask;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.casemanagementtask_001.CaseManagementTask;
import net.datastream.schemas.mp_entities.casemanagementtask_001.TrackingDetails;
import net.datastream.schemas.mp_fields.CASEID_Type;
import net.datastream.schemas.mp_fields.CASEMANAGEMENTTASKID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.PLANNEDDURATIONUOM;
import net.datastream.schemas.mp_fields.PLANNEDDURATION_Type;
import net.datastream.schemas.mp_fields.PRIORITY;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_functions.mp3655_001.MP3655_AddCaseManagementTask_001;
import net.datastream.schemas.mp_functions.mp3656_001.MP3656_SyncCaseManagementTask_001;
import net.datastream.schemas.mp_functions.mp3657_001.MP3657_DeleteCaseManagementTask_001;
import net.datastream.schemas.mp_functions.mp3658_001.MP3658_GetCaseManagementTask_001;
import net.datastream.schemas.mp_results.mp3655_001.MP3655_AddCaseManagementTask_001_Result;
import net.datastream.schemas.mp_results.mp3656_001.MP3656_SyncCaseManagementTask_001_Result;
import net.datastream.schemas.mp_results.mp3658_001.MP3658_GetCaseManagementTask_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class CaseTaskServiceImpl
implements CaseTaskService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public CaseTaskServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public EAMCaseTask readCaseTask(EAMContext context, String caseTaskID) throws EAMException {
        MP3658_GetCaseManagementTask_001 getCaseTask = new MP3658_GetCaseManagementTask_001();
        getCaseTask.setCASEMANAGEMENTTASKID(new CASEMANAGEMENTTASKID_Type());
        getCaseTask.getCASEMANAGEMENTTASKID().setCASEMANAGEMENTTASKCODE(caseTaskID);
        MP3658_GetCaseManagementTask_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getCaseTask);
        CaseManagementTask caseTaskEAM = result.getResultData().getCaseManagementTask();
        EAMCaseTask caseTaskMT = new EAMCaseTask();
        if (caseTaskEAM.getCASEMANAGEMENTTASKID() != null) {
            caseTaskMT.setCaseCode(caseTaskEAM.getCASEID().getCASECODE());
            caseTaskMT.setTaskCode(caseTaskEAM.getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE());
            caseTaskMT.setDescription(caseTaskEAM.getCASEMANAGEMENTTASKID().getDESCRIPTION());
        }
        caseTaskMT.setSequence(caseTaskEAM.getSEQUENCE());
        if (caseTaskEAM.getSTEP() != null) {
            caseTaskMT.setStep(caseTaskEAM.getSTEP());
        }
        if (caseTaskEAM.getESTIMATEDCOSTS() != null) {
            this.tools.getDataTypeTools();
            caseTaskMT.setEstimatedCosts(DataTypeTools.decodeAmount(caseTaskEAM.getESTIMATEDCOSTS()));
        }
        if (caseTaskEAM.getPRIORITY() != null) {
            caseTaskMT.setPriority(caseTaskEAM.getPRIORITY().getPRIORITYCODE());
        }
        if (caseTaskEAM.getCREATEDBY() != null) {
            caseTaskMT.setCreatedBy(caseTaskEAM.getCREATEDBY().getUSERCODE());
        }
        if (caseTaskEAM.getCREATEDDATE() != null) {
            this.tools.getDataTypeTools();
            caseTaskMT.setDateCreated(DataTypeTools.decodeEAMDate(caseTaskEAM.getCREATEDDATE()));
        }
        if (caseTaskEAM.getUPDATEDBY() != null) {
            caseTaskMT.setUpdatedBy(caseTaskEAM.getUPDATEDBY().getUSERCODE());
        }
        if (caseTaskEAM.getDATEUPDATED() != null) {
            this.tools.getDataTypeTools();
            caseTaskMT.setDateUpdated(DataTypeTools.decodeEAMDate(caseTaskEAM.getDATEUPDATED()));
        }
        if (caseTaskEAM.getTrackingDetails() != null) {
            TrackingDetails trackingDetails = caseTaskEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            caseTaskMT.setStartDate(DataTypeTools.decodeEAMDate(caseTaskEAM.getTrackingDetails().getSTARTDATE()));
            if (trackingDetails.getCOMPLETEDDATE() != null) {
                this.tools.getDataTypeTools();
                caseTaskMT.setCompletedDate(DataTypeTools.decodeEAMDate(caseTaskEAM.getTrackingDetails().getCOMPLETEDDATE()));
            }
            if (trackingDetails.getSCHEDULEDSTARTDATE() != null) {
                this.tools.getDataTypeTools();
                caseTaskMT.setScheduledStartDate(DataTypeTools.decodeEAMDate(caseTaskEAM.getTrackingDetails().getSCHEDULEDSTARTDATE()));
            }
            if (trackingDetails.getSCHEDULEDENDDATE() != null) {
                this.tools.getDataTypeTools();
                caseTaskMT.setScheduledEndDate(DataTypeTools.decodeEAMDate(caseTaskEAM.getTrackingDetails().getSCHEDULEDENDDATE()));
            }
            if (caseTaskEAM.getTrackingDetails().getPLANNEDDURATION() != null) {
                PLANNEDDURATION_Type planneddurationType = caseTaskEAM.getTrackingDetails().getPLANNEDDURATION();
                if (planneddurationType.getPLANNEDDURATIONVALUE() != null) {
                    this.tools.getDataTypeTools();
                    caseTaskMT.setPlannedDuration(DataTypeTools.decodeQuantity(planneddurationType.getPLANNEDDURATIONVALUE()));
                }
                if (planneddurationType.getPLANNEDDURATIONUOM() != null && planneddurationType.getPLANNEDDURATIONUOM().getPLANNEDDURATIONUOMCODE() != null) {
                    caseTaskMT.setPlannedDurationUnit(planneddurationType.getPLANNEDDURATIONUOM().getPLANNEDDURATIONUOMCODE());
                }
            }
        }
        caseTaskMT.setCustomFields(this.tools.getCustomFieldsTools().readEAMCustomFields(caseTaskEAM.getUSERDEFINEDAREA(), context));
        return caseTaskMT;
    }

    @Override
    public String createCaseTask(EAMContext context, EAMCaseTask caseTaskMT) throws EAMException {
        CaseManagementTask caseManagement = new CaseManagementTask();
        caseManagement.setStandardUserDefinedFields(new StandardUserDefinedFields());
        this.initCaseTaskObject(caseManagement, caseTaskMT, context);
        MP3655_AddCaseManagementTask_001 initCaseTask = new MP3655_AddCaseManagementTask_001();
        initCaseTask.setCaseManagementTask(caseManagement);
        MP3655_AddCaseManagementTask_001_Result initCaseTaskResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), initCaseTask);
        return initCaseTaskResult.getResultData().getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE();
    }

    @Override
    public String updateCaseTask(EAMContext context, EAMCaseTask caseTaskMT) throws EAMException {
        MP3658_GetCaseManagementTask_001 getCaseTask = new MP3658_GetCaseManagementTask_001();
        getCaseTask.setCASEMANAGEMENTTASKID(new CASEMANAGEMENTTASKID_Type());
        getCaseTask.getCASEMANAGEMENTTASKID().setCASEMANAGEMENTTASKCODE(caseTaskMT.getTaskCode());
        MP3658_GetCaseManagementTask_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getCaseTask);
        CaseManagementTask caseManagementTask = result.getResultData().getCaseManagementTask();
        this.initCaseTaskObject(caseManagementTask, caseTaskMT, context);
        MP3656_SyncCaseManagementTask_001 syncCase = new MP3656_SyncCaseManagementTask_001();
        syncCase.setCaseManagementTask(caseManagementTask);
        MP3656_SyncCaseManagementTask_001_Result syncCaseResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncCase);
        return syncCaseResult.getResultData().getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE();
    }

    @Override
    public String deleteCaseTask(EAMContext context, String caseTaskID) throws EAMException {
        MP3657_DeleteCaseManagementTask_001 deleteCaseTask = new MP3657_DeleteCaseManagementTask_001();
        CASEMANAGEMENTTASKID_Type caseManagementTaskIdType = new CASEMANAGEMENTTASKID_Type();
        caseManagementTaskIdType.setCASEMANAGEMENTTASKCODE(caseTaskID);
        deleteCaseTask.setCASEMANAGEMENTTASKID(caseManagementTaskIdType);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteCaseTask);
        return deleteCaseTask.getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE();
    }

    private void initCaseTaskObject(CaseManagementTask caseTaskEAM, EAMCaseTask caseTaskMT, EAMContext context) throws EAMException {
        if (caseTaskEAM.getCASEID() == null) {
            CASEID_Type caseIdType = new CASEID_Type();
            caseIdType.setCASECODE(caseTaskMT.getCaseCode());
            caseTaskEAM.setCASEID(caseIdType);
        }
        if (caseTaskEAM.getCASEID().getORGANIZATIONID() == null) {
            caseTaskEAM.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (caseTaskEAM.getCASEMANAGEMENTTASKID() == null) {
            caseTaskEAM.setCASEMANAGEMENTTASKID(new CASEMANAGEMENTTASKID_Type());
            caseTaskEAM.getCASEMANAGEMENTTASKID().setCASEMANAGEMENTTASKCODE("0");
        }
        if (caseTaskMT.getDescription() != null) {
            caseTaskEAM.getCASEMANAGEMENTTASKID().setDESCRIPTION(caseTaskMT.getDescription());
        }
        if (caseTaskMT.getSequence() != null) {
            caseTaskEAM.setSEQUENCE(caseTaskMT.getSequence().longValue());
        }
        if (caseTaskMT.getEstimatedCosts() != null) {
            this.tools.getDataTypeTools();
            caseTaskEAM.setESTIMATEDCOSTS(DataTypeTools.encodeAmount(caseTaskMT.getEstimatedCosts(), null));
        }
        if (caseTaskMT.getSequence() != null) {
            caseTaskEAM.setSEQUENCE(caseTaskMT.getSequence().longValue());
        }
        if (caseTaskMT.getStep() != null) {
            caseTaskEAM.setSTEP(caseTaskMT.getStep());
        }
        if (caseTaskMT.getPriority() != null) {
            caseTaskEAM.setPRIORITY(new PRIORITY());
            caseTaskEAM.getPRIORITY().setPRIORITYCODE(caseTaskMT.getPriority());
        }
        if (caseTaskMT.getAssignedTo() != null) {
            if (caseTaskEAM.getTrackingDetails() == null) {
                caseTaskEAM.setTrackingDetails(new TrackingDetails());
            }
            caseTaskEAM.getTrackingDetails().setASSIGNEDTO(new PERSONID_Type());
            caseTaskEAM.getTrackingDetails().getASSIGNEDTO().setPERSONCODE(caseTaskMT.getAssignedTo());
        }
        if (caseTaskMT.getStartDate() != null) {
            if (caseTaskEAM.getTrackingDetails() == null) {
                caseTaskEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setSTARTDATE(DataTypeTools.encodeEAMDate(caseTaskMT.getStartDate(), "Start Date"));
        }
        if (caseTaskMT.getCompletedDate() != null) {
            if (caseTaskEAM.getTrackingDetails() == null) {
                caseTaskEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setCOMPLETEDDATE(DataTypeTools.encodeEAMDate(caseTaskMT.getCompletedDate(), "Completed Date"));
        }
        if (caseTaskMT.getScheduledStartDate() != null) {
            if (caseTaskEAM.getTrackingDetails() == null) {
                caseTaskEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setSCHEDULEDSTARTDATE(DataTypeTools.encodeEAMDate(caseTaskMT.getScheduledStartDate(), "Scheduling Start Date"));
        }
        if (caseTaskMT.getPlannedDuration() != null && caseTaskMT.getPlannedDurationUnit() != null) {
            if (caseTaskEAM.getTrackingDetails() == null) {
                caseTaskEAM.setTrackingDetails(new TrackingDetails());
            }
            if (caseTaskEAM.getTrackingDetails().getPLANNEDDURATION() == null) {
                caseTaskEAM.getTrackingDetails().setPLANNEDDURATION(new PLANNEDDURATION_Type());
                caseTaskEAM.getTrackingDetails().getPLANNEDDURATION().setPLANNEDDURATIONUOM(new PLANNEDDURATIONUOM());
                caseTaskEAM.getTrackingDetails().getPLANNEDDURATION().getPLANNEDDURATIONUOM().setPLANNEDDURATIONUOMCODE(caseTaskMT.getPlannedDurationUnit());
                PLANNEDDURATION_Type pLANNEDDURATION_Type = caseTaskEAM.getTrackingDetails().getPLANNEDDURATION();
                this.tools.getDataTypeTools();
                pLANNEDDURATION_Type.setPLANNEDDURATIONVALUE(DataTypeTools.encodeQuantity(caseTaskMT.getPlannedDuration(), "Planned Duration"));
            }
        }
        if (caseTaskMT.getRequestedStartDate() != null) {
            if (caseTaskEAM.getTrackingDetails() == null) {
                caseTaskEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setREQUESTEDSTART(DataTypeTools.encodeEAMDate(caseTaskMT.getRequestedStartDate(), "Requested Start Date"));
        }
        if (caseTaskMT.getRequestedEndDate() != null) {
            if (caseTaskEAM.getTrackingDetails() == null) {
                caseTaskEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setREQUESTEDEND(DataTypeTools.encodeEAMDate(caseTaskMT.getRequestedEndDate(), "Requested End Date"));
        }
    }
}

