/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.SafetyService;
import ch.cern.eam.wshub.core.services.workorders.impl.Safety;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety;
import net.datastream.schemas.mp_entities.worksafety_001.WorkSafety;
import net.datastream.schemas.mp_functions.mp3219_001.MP3219_AddEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3220_001.MP3220_SyncEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3221_001.MP3221_DeleteEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3222_001.MP3222_GetEntitySafety_001;
import net.datastream.schemas.mp_functions.mp7983_001.MP7983_GetWorkSafety_001;
import net.datastream.schemas.mp_functions.mp7984_001.MP7984_AddWorkSafety_001;
import net.datastream.schemas.mp_functions.mp7985_001.MP7985_SyncWorkSafety_001;
import net.datastream.schemas.mp_functions.mp7986_001.MP7986_DeleteWorkSafety_001;
import net.datastream.wsdls.eamws.EAMWebServicesPT;
import org.openapplications.oagis_segments.QUANTITY;

public class SafetyServiceImpl
implements SafetyService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public SafetyServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<List<Safety>> readSafetiesBatch(EAMContext context, String entityType, List<String> entityCode) {
        List callableList = entityCode.stream().map(code -> () -> this.readSafeties(context, entityType, (String)code)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<String> setSafetiesBatch(EAMContext context, String entityType, Map<String, List<Safety>> entityCodeToSafeties) {
        List callableList = entityCodeToSafeties.keySet().stream().map(code -> () -> this.setSafeties(context, entityType, (String)code, (List)entityCodeToSafeties.get(code))).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public List<Safety> readSafeties(EAMContext context, String entityType, String entityCode) throws EAMException {
        GridRequest request = new GridRequest();
        request.setGridType(GridRequest.GRIDTYPE.LIST);
        if (this.isWorkOrder(entityType)) {
            request.setGridName("WSJOBS_KSF");
            request.addParam("param.workordernum", entityCode);
            request.addParam("parameter.r5role", "");
            request.setUserFunctionName("WSJOBS");
        } else if (this.isObject(entityType)) {
            request.setGridName("OSOBJA_ESF");
            request.setUserFunctionName("OSOBJA");
            request.addParam("parameter.object", entityCode);
            request.addParam("parameter.objorganization", this.tools.getOrganizationCode(context));
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
        GridRequestResult result = this.gridsService.executeQuery(context, request);
        List<Safety> safeties = GridTools.convertGridResultToObject(Safety.class, null, result);
        safeties.stream().forEach(safety -> safety.setUserDefinedFields(null));
        return safeties;
    }

    @Override
    public String setSafeties(EAMContext context, String entityType, String entityCode, List<Safety> safeties) throws EAMException {
        if (!this.isWorkOrder(entityType) && !this.isObject(entityType)) {
            throw Tools.generateFault("Invalid entityType");
        }
        Map<String, Safety> currentSafetiesMap = this.toMap(this.readSafeties(context, entityType, entityCode));
        for (Safety safety : safeties) {
            if (safety == null) continue;
            String id = safety.getId();
            Safety currentSafety = currentSafetiesMap.get(id);
            currentSafetiesMap.remove(id);
            if (safety.getReadOnly()) continue;
            if (currentSafety == null) {
                this.addSafety(context, entityType, entityCode, safety);
                continue;
            }
            if (!Safety.canBeChangedBy(currentSafety, safety)) continue;
            this.syncSafety(context, entityType, entityCode, safety);
        }
        for (Safety safety : currentSafetiesMap.values()) {
            this.removeSafety(context, entityType, safety.getId());
        }
        return "OK";
    }

    @Override
    public Safety readSafety(EAMContext context, String entityType, String safetyCode) throws EAMException {
        if (this.isObject(entityType)) {
            MP3222_GetEntitySafety_001 getEntitySafety = new MP3222_GetEntitySafety_001();
            getEntitySafety.setSAFETYCODE(safetyCode);
            EntitySafety eamSafety = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEntitySafety).getResultData().getEntitySafety();
            Safety safety = new Safety();
            return this.tools.getEAMFieldTools().transformEAMObject(safety, eamSafety, context);
        }
        if (this.isWorkOrder(entityType)) {
            MP7983_GetWorkSafety_001 getWorkSafety = new MP7983_GetWorkSafety_001();
            getWorkSafety.setSAFETYCODE(safetyCode);
            WorkSafety workSafety = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkSafety).getResultData().getWorkSafety();
            Safety safety = new Safety();
            return this.tools.getEAMFieldTools().transformEAMObject(safety, workSafety, context);
        }
        throw Tools.generateFault("Invalid entityType");
    }

    private String getFullEntityCode(EAMContext context, String entityType, String entityCode) {
        String extension = this.isObject(entityType) ? "#" + this.tools.getOrganizationCode(context) : "";
        return entityCode + extension;
    }

    private EntitySafety transformToEntitySafety(EAMContext context, String entityType, String entityCode, Safety safety, EntitySafety original) throws EAMException {
        EntitySafety entitySafetyEAM = original == null ? new EntitySafety() : original;
        this.tools.getEAMFieldTools().transformWSHubObject(entitySafetyEAM, safety, context);
        if (safety.getId() == null) {
            entitySafetyEAM.setSAFETYCODE("0");
        }
        entitySafetyEAM.setENTITY(entityType);
        entitySafetyEAM.setENTITYSAFETYCODE(this.getFullEntityCode(context, entityType, entityCode));
        entitySafetyEAM.getHAZARDID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, entitySafetyEAM.getHAZARDID().getREVISIONNUM(), true));
        entitySafetyEAM.getPRECAUTIONID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, entitySafetyEAM.getPRECAUTIONID().getREVISIONNUM(), false));
        return entitySafetyEAM;
    }

    private WorkSafety transformToWorkSafety(EAMContext context, String entityType, String entityCode, Safety safety, WorkSafety original) throws EAMException {
        WorkSafety workSafetyEAM = original == null ? new WorkSafety() : original;
        this.tools.getEAMFieldTools().transformWSHubObject(workSafetyEAM, safety, context);
        if (safety.getId() == null) {
            workSafetyEAM.setSAFETYCODE("0");
        }
        workSafetyEAM.setENTITY(entityType);
        workSafetyEAM.setENTITYSAFETYCODE(this.getFullEntityCode(context, entityType, entityCode));
        workSafetyEAM.getHAZARDID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, workSafetyEAM.getHAZARDID().getREVISIONNUM(), true));
        workSafetyEAM.getPRECAUTIONID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, workSafetyEAM.getPRECAUTIONID().getREVISIONNUM(), false));
        return workSafetyEAM;
    }

    private void addSafety(EAMContext context, String entityType, String entityCode, Safety safety) throws EAMException {
        if (this.isObject(entityType)) {
            EntitySafety entitySafetyEAM = this.transformToEntitySafety(context, entityType, entityCode, safety, null);
            entitySafetyEAM.setSAFETYCODE("0");
            MP3219_AddEntitySafety_001 addEntitySafety = new MP3219_AddEntitySafety_001();
            addEntitySafety.getEntitySafety().add(entitySafetyEAM);
            this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addEntitySafety);
        } else if (this.isWorkOrder(entityType)) {
            WorkSafety workSafetyEAM = this.transformToWorkSafety(context, entityType, entityCode, safety, null);
            workSafetyEAM.setSAFETYCODE("0");
            MP7984_AddWorkSafety_001 addWorkSafety_001 = new MP7984_AddWorkSafety_001();
            addWorkSafety_001.getWorkSafety().add(workSafetyEAM);
            this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addWorkSafety_001);
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
    }

    private void removeSafety(EAMContext context, String entityType, String safetyId) throws EAMException {
        if (this.isObject(entityType)) {
            MP3221_DeleteEntitySafety_001 deleteEntitySafety = new MP3221_DeleteEntitySafety_001();
            deleteEntitySafety.setSAFETYCODE(safetyId);
            this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteEntitySafety);
        } else if (this.isWorkOrder(entityType)) {
            MP7986_DeleteWorkSafety_001 deleteWorkSafety = new MP7986_DeleteWorkSafety_001();
            deleteWorkSafety.setSAFETYCODE(safetyId);
            this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteWorkSafety);
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
    }

    private void syncSafety(EAMContext context, String entityType, String entityCode, Safety safety) throws EAMException {
        if (this.isObject(entityType)) {
            MP3222_GetEntitySafety_001 getEntitySafety = new MP3222_GetEntitySafety_001();
            getEntitySafety.setSAFETYCODE(safety.getId());
            EntitySafety previousSafety = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEntitySafety).getResultData().getEntitySafety();
            EntitySafety entitySafetyEAM = this.transformToEntitySafety(context, entityType, entityCode, safety, previousSafety);
            MP3220_SyncEntitySafety_001 syncEntitySafety = new MP3220_SyncEntitySafety_001();
            syncEntitySafety.setEntitySafety(entitySafetyEAM);
            this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncEntitySafety);
        } else if (this.isWorkOrder(entityType)) {
            MP7983_GetWorkSafety_001 getWorkSafety = new MP7983_GetWorkSafety_001();
            getWorkSafety.setSAFETYCODE(safety.getId());
            WorkSafety previousSafety = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkSafety).getResultData().getWorkSafety();
            WorkSafety workSafetyEAM = this.transformToWorkSafety(context, entityType, entityCode, safety, previousSafety);
            MP7985_SyncWorkSafety_001 syncWorkSafety = new MP7985_SyncWorkSafety_001();
            syncWorkSafety.setWorkSafety(workSafetyEAM);
            this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncWorkSafety);
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
    }

    private QUANTITY getRevisionQUANTITY(EAMContext context, Safety safety, QUANTITY oldQuantity, boolean isHazard) throws EAMException {
        String id = isHazard ? safety.getHazardCode() : safety.getPrecautionCode();
        String label = isHazard ? "Hazard Code" : "Precaution Code";
        return oldQuantity == null ? DataTypeTools.encodeQuantity(this.getLatestRevision(context, id, isHazard), label) : oldQuantity;
    }

    private BigDecimal getLatestRevision(EAMContext context, String id, boolean isHazard) throws EAMException {
        if (id == null) {
            throw Tools.generateFault(isHazard ? "Hazard Code is null" : "Precaution Code is null");
        }
        GridRequest gridRequest = new GridRequest(isHazard ? "LVSAFETYHAZARD" : "LVPRECAUTION", GridRequest.GRIDTYPE.LOV);
        gridRequest.addFilter(isHazard ? "hazardcode" : "precaution", id, "=");
        gridRequest.setRowCount(1);
        String revision = GridTools.extractSingleResult(this.gridsService.executeQuery(context, gridRequest), "revision");
        return new BigDecimal(revision);
    }

    private Map<String, Safety> toMap(List<Safety> safeties) {
        return safeties.stream().collect(Collectors.toMap(Safety::getId, Function.identity(), (firstSafety, otherSafety) -> firstSafety));
    }

    private boolean isWorkOrder(String entityType) {
        return entityType.equals("EVNT");
    }

    private boolean isObject(String entityType) {
        return entityType.equals("OBJ");
    }
}

