/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.material.entities.MaterialList;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderMiscService;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskPlan;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.datastream.schemas.mp_entities.materiallistpart_001.MaterialListPart;
import net.datastream.schemas.mp_entities.meterreading_001.MeterReading;
import net.datastream.schemas.mp_entities.routeequipment_001.RouteEquipment;
import net.datastream.schemas.mp_entities.task_001.Task;
import net.datastream.schemas.mp_entities.workorderadditionalcosts_001.WorkOrderAdditionalCosts;
import net.datastream.schemas.mp_entities.workorderpart_001.WorkOrderPart;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.MATERIALLISTID_Type;
import net.datastream.schemas.mp_fields.MATERIALLISTPARTID_Type;
import net.datastream.schemas.mp_fields.MULTIEQUIPSPLITINFO;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.ROUTEEQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.ROUTEEQUIPMENTTYPE_Type;
import net.datastream.schemas.mp_fields.ROUTE_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_fields.WORKORDERPARTID;
import net.datastream.schemas.mp_functions.mp0044_001.MP0044_AddMeterReading_001;
import net.datastream.schemas.mp_functions.mp0067_001.MP0067_AddMaterialListPart_001;
import net.datastream.schemas.mp_functions.mp0071_001.MP0071_AddWorkOrderPart_001;
import net.datastream.schemas.mp_functions.mp0080_001.MP0080_AddTask_001;
import net.datastream.schemas.mp_functions.mp7153_001.MP7153_AddRouteEquipment_001;
import net.datastream.schemas.mp_functions.mp7156_001.MP7156_DeleteRouteEquipment_001;
import net.datastream.schemas.mp_functions.mp7336_001.MP7336_GetWOEquipLinearDetails_001;
import net.datastream.schemas.mp_functions.mp7593_001.MP7593_AddWorkOrderAdditionalCosts_001;
import net.datastream.schemas.mp_results.mp0044_001.MP0044_AddMeterReading_001_Result;
import net.datastream.schemas.mp_results.mp7336_001.AdditionalWOEquipDetails;
import net.datastream.schemas.mp_results.mp7336_001.MP7336_GetWOEquipLinearDetails_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class WorkOrderMiscServiceImpl
implements WorkOrderMiscService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public WorkOrderMiscServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public String createMeterReading(EAMContext context, ch.cern.eam.wshub.core.services.workorders.entities.MeterReading meterReadingParam) throws EAMException {
        MeterReading meterreadingeam = new MeterReading();
        this.tools.getEAMFieldTools().transformWSHubObject(meterreadingeam, meterReadingParam, context);
        if (meterReadingParam.getActualValue() != null) {
            this.tools.getDataTypeTools();
            meterreadingeam.setACTUALREADING(DataTypeTools.encodeQuantity(meterReadingParam.getActualValue(), "Meter Reading Value"));
        } else if (meterReadingParam.getDifferenceValue() != null) {
            this.tools.getDataTypeTools();
            meterreadingeam.setDIFFERENCEREADING(DataTypeTools.encodeQuantity(meterReadingParam.getDifferenceValue(), "Meter Reading Value"));
        } else {
            throw Tools.generateFault("Supply actual reading or difference reading value.");
        }
        if (meterReadingParam.getReadingDate() == null) {
            this.tools.getDataTypeTools();
            meterreadingeam.setREADINGDATE(DataTypeTools.formatDate("SYSDATE", "Meter Reading Date"));
        } else {
            this.tools.getDataTypeTools();
            meterreadingeam.setREADINGDATE(DataTypeTools.encodeEAMDate(meterReadingParam.getReadingDate(), "Meter Reading Date"));
        }
        MP0044_AddMeterReading_001 addmeterreading = new MP0044_AddMeterReading_001();
        addmeterreading.setMeterReading(meterreadingeam);
        MP0044_AddMeterReading_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addMeterReadingOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addmeterreading);
        return result.getResultData().getMETERREADINGCODE();
    }

    @Override
    public String createWorkOrderAdditionalCost(EAMContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderAdditionalCosts workOrderAddCostsParam) throws EAMException {
        WorkOrderAdditionalCosts workOrderAddCosts = new WorkOrderAdditionalCosts();
        this.tools.getEAMFieldTools().transformWSHubObject(workOrderAddCosts, workOrderAddCostsParam, context);
        this.tools.getDataTypeTools();
        workOrderAddCosts.setWOADDITIONALCOSTQTY(DataTypeTools.encodeQuantity(BigDecimal.ONE, "Additional Quantity"));
        MULTIEQUIPSPLITINFO multiEquipSplitInfo = new MULTIEQUIPSPLITINFO();
        WOID_Type woIdType = new WOID_Type();
        woIdType.setJOBNUM(workOrderAddCostsParam.getWorkOrderNumber());
        multiEquipSplitInfo.setRELATEDWORKORDERID(woIdType);
        workOrderAddCosts.setMULTIEQUIPSPLITINFO(multiEquipSplitInfo);
        MP7593_AddWorkOrderAdditionalCosts_001 addCost = new MP7593_AddWorkOrderAdditionalCosts_001();
        addCost.setWorkOrderAdditionalCosts(workOrderAddCosts);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addWorkOrderAdditionalCostsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addCost);
        return "done";
    }

    @Override
    public String createMaterialList(EAMContext context, MaterialList materialList) throws EAMException {
        MP0067_AddMaterialListPart_001 matList = new MP0067_AddMaterialListPart_001();
        matList.setMaterialListPart(new MaterialListPart());
        matList.getMaterialListPart().setMATERIALLISTPARTID(new MATERIALLISTPARTID_Type());
        matList.getMaterialListPart().getMATERIALLISTPARTID().setMATERIALLISTID(new MATERIALLISTID_Type());
        if (materialList.getMaterialListCode() != null && !materialList.getMaterialListCode().trim().equals("")) {
            matList.getMaterialListPart().getMATERIALLISTPARTID().getMATERIALLISTID().setMTLREVISION(Long.valueOf(0L));
            matList.getMaterialListPart().getMATERIALLISTPARTID().getMATERIALLISTID().setMTLCODE(materialList.getMaterialListCode().toUpperCase().trim());
            matList.getMaterialListPart().getMATERIALLISTPARTID().getMATERIALLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        matList.getMaterialListPart().getMATERIALLISTPARTID().setMATERIALLISTPARTLINENUM(this.tools.getDataTypeTools().encodeLong(materialList.getLineNumber(), "Line Number"));
        if (materialList.getPartCode() != null && !materialList.getPartCode().trim().equals("")) {
            matList.getMaterialListPart().setPARTID(new PARTID_Type());
            matList.getMaterialListPart().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            matList.getMaterialListPart().getPARTID().setPARTCODE(materialList.getPartCode());
        }
        MaterialListPart materialListPart = matList.getMaterialListPart();
        this.tools.getDataTypeTools();
        materialListPart.setPARTQUANTITY(DataTypeTools.encodeQuantity(materialList.getQuantity(), "Quantity"));
        if (materialList.getReserve() != null) {
            matList.getMaterialListPart().setRESERVEPART(materialList.getReserve().trim());
        }
        if (materialList.getEquipmentCode() != null && !materialList.getEquipmentCode().trim().equals("")) {
            matList.getMaterialListPart().setEQUIPMENTID(new EQUIPMENTID_Type());
            matList.getMaterialListPart().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            matList.getMaterialListPart().getEQUIPMENTID().setEQUIPMENTCODE(materialList.getEquipmentCode());
        }
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addMaterialListPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), matList);
        return "done";
    }

    @Override
    public String addWorkOrderPart(EAMContext context, ch.cern.eam.wshub.core.services.entities.WorkOrderPart workOrderPart) throws EAMException {
        WorkOrderPart wop = new WorkOrderPart();
        wop.setPARTID(new PARTID_Type());
        wop.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        wop.getPARTID().setPARTCODE(workOrderPart.getPartCode());
        if (workOrderPart.getStoreCode() != null) {
            wop.setSTOREID(new STOREID_Type());
            wop.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            wop.getSTOREID().setSTORECODE(workOrderPart.getStoreCode());
        }
        wop.setWORKORDERPARTID(new WORKORDERPARTID());
        wop.getWORKORDERPARTID().setACTIVITYID(new ACTIVITYID());
        wop.getWORKORDERPARTID().getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        wop.getWORKORDERPARTID().getACTIVITYID().getACTIVITYCODE().setValue(this.tools.getDataTypeTools().encodeLong(workOrderPart.getActivityCode(), "Activity Code"));
        wop.getWORKORDERPARTID().getACTIVITYID().setWORKORDERID(new WOID_Type());
        wop.getWORKORDERPARTID().getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        wop.getWORKORDERPARTID().getACTIVITYID().getWORKORDERID().setJOBNUM(workOrderPart.getWorkOrderNumber());
        if (workOrderPart.getPlannedQty() != null) {
            this.tools.getDataTypeTools();
            wop.setPLANNEDPARTQUANTITY(DataTypeTools.encodeQuantity(workOrderPart.getPlannedQty(), "Planned Qty."));
        }
        if (workOrderPart.getReservedQty() != null) {
            this.tools.getDataTypeTools();
            wop.setRESERVEDPARTQUANTITY(DataTypeTools.encodeQuantity(workOrderPart.getReservedQty(), "Reserved Qty."));
        }
        if (workOrderPart.getAllocatedQty() != null) {
            this.tools.getDataTypeTools();
            wop.setALLOCATEDPARTQUANTITY(DataTypeTools.encodeQuantity(workOrderPart.getAllocatedQty(), "Allocated Qty."));
        }
        if (workOrderPart.getPlannedSource() != null && !workOrderPart.getPlannedSource().trim().equals("")) {
            wop.setDIRECT(workOrderPart.getPlannedSource());
        }
        MP0071_AddWorkOrderPart_001 addwop = new MP0071_AddWorkOrderPart_001();
        addwop.setWorkOrderPart(wop);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addWorkOrderPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addwop);
        return "done";
    }

    @Override
    public String createRouteEquipment(EAMContext context, ch.cern.eam.wshub.core.services.workorders.entities.RouteEquipment routeEquipment) throws EAMException {
        RouteEquipment routeEquipmentEAM = new RouteEquipment();
        routeEquipmentEAM.setROUTEEQUIPMENTID(new ROUTEEQUIPMENTID_Type());
        routeEquipmentEAM.getROUTEEQUIPMENTID().setROUTEEQUIPMENTSEQUENCE(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteEquipmentSequence(), "Route Equipment Sequence"));
        routeEquipmentEAM.getROUTEEQUIPMENTID().setROUTEID(new ROUTE_Type());
        routeEquipmentEAM.getROUTEEQUIPMENTID().getROUTEID().setROUTECODE(routeEquipment.getRouteCode());
        if (routeEquipment.getRouteRevision() != null) {
            routeEquipmentEAM.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteRevision(), "Route Revision")));
        } else {
            routeEquipmentEAM.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(0L));
        }
        routeEquipmentEAM.setROUTEEQUIPMENTTYPE(new ROUTEEQUIPMENTTYPE_Type());
        routeEquipmentEAM.getROUTEEQUIPMENTTYPE().setEQUIPMENTID(new EQUIPMENTID_Type());
        routeEquipmentEAM.getROUTEEQUIPMENTTYPE().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        routeEquipmentEAM.getROUTEEQUIPMENTTYPE().getEQUIPMENTID().setEQUIPMENTCODE(routeEquipment.getEquipmentCode());
        routeEquipmentEAM.getROUTEEQUIPMENTTYPE().setOBJRTYPE(routeEquipment.getObjRType());
        routeEquipmentEAM.getROUTEEQUIPMENTTYPE().setOBJTYPE(routeEquipment.getObjType());
        MP7153_AddRouteEquipment_001 addRouteEquipment = new MP7153_AddRouteEquipment_001();
        addRouteEquipment.setRouteEquipment(routeEquipmentEAM);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addRouteEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addRouteEquipment);
        return "done";
    }

    @Override
    public String deleteRouteEquipment(EAMContext context, ch.cern.eam.wshub.core.services.workorders.entities.RouteEquipment routeEquipment) throws EAMException {
        MP7156_DeleteRouteEquipment_001 deleteRouteEquipment = new MP7156_DeleteRouteEquipment_001();
        deleteRouteEquipment.setROUTEEQUIPMENTID(new ROUTEEQUIPMENTID_Type());
        deleteRouteEquipment.getROUTEEQUIPMENTID().setROUTEEQUIPMENTSEQUENCE(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteEquipmentSequence(), "Route Equipment Sequence"));
        deleteRouteEquipment.getROUTEEQUIPMENTID().setROUTEID(new ROUTE_Type());
        deleteRouteEquipment.getROUTEEQUIPMENTID().getROUTEID().setROUTECODE(routeEquipment.getRouteCode());
        if (routeEquipment.getRouteRevision() != null) {
            deleteRouteEquipment.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteRevision(), "Route Revision")));
        } else {
            deleteRouteEquipment.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(0L));
        }
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteRouteEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteRouteEquipment);
        return "done";
    }

    @Override
    public String createTaskPlan(EAMContext context, TaskPlan taskPlan) throws EAMException {
        if (taskPlan.getTaskRevision() == null) {
            taskPlan.setTaskRevision(BigInteger.ZERO);
        }
        if (taskPlan.getRevisionStatus() == null) {
            taskPlan.setRevisionStatus("A");
        }
        MP0080_AddTask_001 addTask = new MP0080_AddTask_001();
        addTask.setTask(this.tools.getEAMFieldTools().transformWSHubObject(new Task(), taskPlan, context));
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addTask);
        return "done";
    }

    @Override
    public AdditionalWOEquipDetails getEquipLinearDetails(EAMContext context, String eqCode) throws EAMException {
        MP7336_GetWOEquipLinearDetails_001 op = new MP7336_GetWOEquipLinearDetails_001();
        op.setEQUIPMENTID(new EQUIPMENTID_Type());
        op.getEQUIPMENTID().setEQUIPMENTCODE(eqCode);
        op.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        op.setORGANIZATIONID(this.tools.getOrganization(context));
        MP7336_GetWOEquipLinearDetails_001_Result additionalWOEquipDetails = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getWOEquipLinearDetailsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), op);
        return additionalWOEquipDetails.getResultData().getAdditionalWOEquipDetails();
    }
}

