/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools.soaphandler;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class NSEraserHandler
implements SOAPHandler<SOAPMessageContext> {
    final Logger logger;

    public NSEraserHandler(Logger logger) {
        this.logger = logger;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        boolean outbound = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
        if (outbound) {
            try {
                Iterator headerIter = context.getMessage().getSOAPPart().getEnvelope().getHeader().getChildElements();
                while (headerIter.hasNext()) {
                    this.cleanSOAPElement((SOAPElement)headerIter.next());
                }
                this.cleanSOAPElement((SOAPElement)context.getMessage().getSOAPPart().getEnvelope().getBody().getChildElements().next());
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage());
            }
        }
        return true;
    }

    private void cleanSOAPElement(SOAPElement soapElement) {
        String headerNSPrefix = soapElement.getElementName().getPrefix();
        Iterator namespaceIT = soapElement.getNamespacePrefixes();
        ArrayList<String> result = new ArrayList<String>();
        while (namespaceIT.hasNext()) {
            result.add((String)namespaceIT.next());
        }
        result.stream().filter(ns -> !ns.equals(headerNSPrefix)).forEach(arg_0 -> ((SOAPElement)soapElement).removeNamespaceDeclaration(arg_0));
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

