/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools.soaphandler;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class WSLoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    final Pattern regex;
    final Logger logger;

    public WSLoggingHandler(Logger logger) {
        this.logger = logger;
        this.regex = Pattern.compile("(<([a-zA-Z0-9]+:)?password>)([\\s\\S]*?)(</([a-zA-Z0-9]+:)?password>)", 2);
    }

    public boolean handleMessage(SOAPMessageContext context) {
        String soapMessage = this.soapMessageToString(context.getMessage());
        System.out.println(soapMessage);
        try {
            Iterator it = context.getMessage().getSOAPBody().getChildElements();
            while (it.hasNext()) {
                SOAPElement se = (SOAPElement)it.next();
                if (!se.getElementName().getLocalName().equalsIgnoreCase("InformationAlert")) continue;
                se.detachNode();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String soapMessageToString(SOAPMessage message) {
        String result = null;
        if (message != null) {
            ByteArrayOutputStream baos = null;
            try {
                baos = new ByteArrayOutputStream();
                message.writeTo((OutputStream)baos);
                result = baos.toString();
            }
            catch (Exception exception) {
            }
            finally {
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public boolean handleFault(SOAPMessageContext context) {
        String soapMessage = this.soapMessageToString(context.getMessage());
        System.out.println(soapMessage);
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

