/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.interceptors;

import ch.cern.eam.wshub.core.annotations.Operation;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.interceptors.InforInterceptor;
import ch.cern.eam.wshub.core.interceptors.LogDataReferenceType;
import ch.cern.eam.wshub.core.interceptors.beans.InforErrorData;
import ch.cern.eam.wshub.core.interceptors.beans.InforExtractedData;
import ch.cern.eam.wshub.core.interceptors.beans.InforRequestData;
import ch.cern.eam.wshub.core.interceptors.beans.InforResponseData;
import ch.cern.eam.wshub.core.services.INFOR_OPERATION;
import ch.cern.eam.wshub.core.tools.ExceptionInfo;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InforInvocationHandler<T>
implements InvocationHandler {
    private final T target;
    private final InforInterceptor inforInterceptor;
    private final Tools tools;

    public InforInvocationHandler(T target, InforInterceptor inforInterceptor, Tools tools) {
        this.target = target;
        this.inforInterceptor = inforInterceptor;
        this.tools = tools;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean intercept;
        Operation operation = method.getAnnotation(Operation.class);
        boolean bl = intercept = this.inforInterceptor != null && operation != null && operation.logOperation() != null;
        if (!intercept) {
            try {
                return method.invoke(this.target, args);
            }
            catch (Exception e) {
                throw this.convertException(e.getCause());
            }
        }
        INFOR_OPERATION inforOperation = operation.logOperation();
        long startNanoTime = System.nanoTime();
        InforContext inforContext = args.length >= 0 ? (InforContext)args[0] : null;
        Object input = args.length >= 1 ? args[1] : null;
        InforRequestData request = new InforRequestData.Builder().withInforContext(inforContext).withInput(input).build();
        this.inforInterceptor.before(inforOperation, request);
        try {
            Object result = method.invoke(this.target, args);
            InforResponseData response = new InforResponseData.Builder().withResponseTime(System.nanoTime() - startNanoTime).withResponse(result).build();
            InforExtractedData extractedData = this.extractDataReference(operation, input, result);
            this.inforInterceptor.afterSuccess(inforOperation, request, response, extractedData);
            return result;
        }
        catch (Exception e) {
            InforException ie = this.convertException(e.getCause());
            InforErrorData error = new InforErrorData.Builder().withResponseTime(System.nanoTime() - startNanoTime).withException(ie).build();
            InforExtractedData extractedData = this.extractDataReference(operation, input, null);
            this.inforInterceptor.afterError(inforOperation, request, error, extractedData);
            this.tools.log(Level.SEVERE, "Error while calling Infor service " + (Object)((Object)inforOperation));
            throw ie;
        }
    }

    private InforExtractedData extractDataReference(Operation operation, Object input, Object result) {
        String logFieldName1 = operation.logDataReference1FieldName();
        LogDataReferenceType logDataReference1 = operation.logDataReference1();
        String extractDataReference1 = this.readDataReferenceValue(input, result, logFieldName1, logDataReference1);
        String logFieldName2 = operation.logDataReference2FieldName();
        LogDataReferenceType logDataReference2 = operation.logDataReference2();
        String extractDataReference2 = this.readDataReferenceValue(input, result, logFieldName2, logDataReference2);
        return new InforExtractedData.Builder().withDataReference1(extractDataReference1).withDataReference2(extractDataReference2).build();
    }

    private String readDataReferenceValue(Object input, Object result, String logFieldName, LogDataReferenceType logDataReference) {
        if (logDataReference == LogDataReferenceType.INPUT && input != null) {
            return input.toString().replaceAll("'", "''");
        }
        if (logDataReference == LogDataReferenceType.INPUTFIELD && input != null) {
            try {
                Field field = input.getClass().getDeclaredField(logFieldName);
                field.setAccessible(true);
                return ((String)field.get(input)).replaceAll("'", "''");
            }
            catch (Exception e) {
                return null;
            }
        }
        if (logDataReference == LogDataReferenceType.RESULT && result != null) {
            return result.toString();
        }
        return null;
    }

    private InforException convertException(Throwable e) {
        if (e instanceof SOAPFaultException) {
            SOAPFaultException se = (SOAPFaultException)e;
            return new InforException(e.getMessage(), (Throwable)se, this.extractSOAPFaultException(se));
        }
        return new InforException(e.getMessage(), e, null);
    }

    private ExceptionInfo[] extractSOAPFaultException(SOAPFaultException exception) {
        LinkedList<ExceptionInfo> exs = new LinkedList<ExceptionInfo>();
        try {
            NodeList nodeList = exception.getFault().getDetail().getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ExceptionInfo exceptionInfo = new ExceptionInfo();
                Node locationNode = nodeList.item(i).getAttributes().getNamedItem("location_reference");
                if (locationNode != null) {
                    String locationString = locationNode.getTextContent().replace("/", "_");
                    locationString = locationString.startsWith("_") ? "EAMID" + locationString : "EAMID_" + locationString;
                    exceptionInfo.setLocation(locationString);
                }
                Node exceptionNode = nodeList.item(i).getFirstChild();
                exceptionInfo.setMessage(exceptionNode.getLastChild().getTextContent());
                Node nameAttribute = exceptionNode.getAttributes().getNamedItem("name");
                if (nameAttribute != null) {
                    exceptionInfo.setName(nameAttribute.getTextContent());
                }
                exs.add(exceptionInfo);
            }
        }
        catch (Exception e) {
            return null;
        }
        return exs.toArray(new ExceptionInfo[0]);
    }
}

