/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.entities;

import ch.cern.eam.wshub.core.tools.DataTypeTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultMutableTreeNode;
import net.datastream.schemas.mp_entities.extmenus_001.ExtMenus;
import net.datastream.schemas.mp_fields.FOLDER_Type;
import net.datastream.schemas.mp_fields.FUNCTION_Type;
import net.datastream.schemas.mp_fields.MENU_Type;

public class MenuEntryNode
extends DefaultMutableTreeNode {
    private static final String ROOT_NODE = "ROOT_NODE";
    private String id;
    private String description;
    private String functionId;
    private String systemFunctionId;
    private boolean isHidden;
    private long sequenceNumber;
    private boolean readAllowed;
    private boolean creationAllowed;
    private boolean deleteAllowed;
    private boolean updateAllowed;

    public MenuEntryNode(FOLDER_Type folder) {
        Objects.requireNonNull(folder);
        this.id = folder.getEXTMENUCODE();
        this.description = folder.getFOLDERID().getFOLDERDESCRIPTION();
        this.functionId = folder.getFOLDERID().getFOLDERCODE();
        this.sequenceNumber = folder.getSEQUENCENUMBER();
    }

    public MenuEntryNode(MENU_Type menu) {
        Objects.requireNonNull(menu);
        this.id = menu.getEXTMENUCODE();
        this.description = menu.getMENUID().getMENUDESCRIPTION();
        this.functionId = menu.getMENUID().getMENUCODE();
        this.sequenceNumber = menu.getSEQUENCENUMBER();
    }

    public MenuEntryNode(FUNCTION_Type function) {
        Objects.requireNonNull(function);
        this.id = function.getEXTMENUCODE();
        this.description = function.getFUNCTIONID().getFUNCTIONDESCRIPTION();
        this.functionId = function.getFUNCTIONID().getFUNCTIONCODE();
        this.systemFunctionId = function.getSYSTEMFUNCTION();
        this.isHidden = DataTypeTools.decodeBoolean(function.getHIDEMENU());
        this.sequenceNumber = function.getSEQUENCENUMBER();
        if (function.getUSERGROUPPERMISSIONS() != null) {
            this.readAllowed = "?".equals(function.getUSERGROUPPERMISSIONS().getSELECTPERMISSION());
            this.creationAllowed = "+".equals(function.getUSERGROUPPERMISSIONS().getINSERTPERMISSION());
            this.updateAllowed = "*".equals(function.getUSERGROUPPERMISSIONS().getUPDATEPERMISSION());
            this.deleteAllowed = "X".equals(function.getUSERGROUPPERMISSIONS().getDELETEPERMISSION());
        }
    }

    public MenuEntryNode(ExtMenus entryAdded) {
        Objects.requireNonNull(entryAdded);
        this.id = entryAdded.getEXTMENUID().getEXTMENUCODE();
        this.description = entryAdded.getFUNCTIONID().getFUNCTIONDESCRIPTION();
        this.functionId = entryAdded.getFUNCTIONID().getFUNCTIONCODE();
        this.sequenceNumber = entryAdded.getSEQUENCENUMBER();
    }

    public MenuEntryNode() {
        this.description = ROOT_NODE;
    }

    public List<MenuEntryNode> getChildren() {
        ArrayList<MenuEntryNode> children = new ArrayList<MenuEntryNode>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            children.add((MenuEntryNode)this.getChildAt(i));
        }
        return children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuEntryNode)) {
            return false;
        }
        MenuEntryNode other = (MenuEntryNode)o;
        return this.getDescription().equals(other.getDescription()) && this.getFunctionId().equals(other.getFunctionId()) && this.getParentMenuEntry().equals(other.getParentMenuEntry());
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public MenuEntryNode getParentMenuEntry() {
        return (MenuEntryNode)this.getParent();
    }

    public boolean isReadAllowed() {
        return this.readAllowed;
    }

    public void setReadAllowed(boolean readAllowed) {
        this.readAllowed = readAllowed;
    }

    public boolean isCreationAllowed() {
        return this.creationAllowed;
    }

    public void setCreationAllowed(boolean creationAllowed) {
        this.creationAllowed = creationAllowed;
    }

    public boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    public void setDeleteAllowed(boolean deleteAllowed) {
        this.deleteAllowed = deleteAllowed;
    }

    public boolean isUpdateAllowed() {
        return this.updateAllowed;
    }

    public void setUpdateAllowed(boolean updateAllowed) {
        this.updateAllowed = updateAllowed;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public String getSystemFunctionId() {
        return this.systemFunctionId;
    }

    public void setSystemFunctionId(String systemFunctionId) {
        this.systemFunctionId = systemFunctionId;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }
}

