/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.administration.DataspyService;
import ch.cern.eam.wshub.core.services.administration.entities.DataspyCopy;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import net.datastream.schemas.mp_fields.SCREENDATASPYID_Type;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.mp6516_001.MP6516_CopyScreenDataspy_001;
import net.datastream.schemas.mp_functions.mp6518_001.MP6518_DeleteScreenDataspy_001;
import net.datastream.schemas.mp_results.mp6516_001.MP6516_CopyScreenDataspy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class DataspyServiceImpl
implements DataspyService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public DataspyServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public String copyDataspy(InforContext context, DataspyCopy dataspyCopy) throws InforException {
        MP6516_CopyScreenDataspy_001 copyScreenDataspy = new MP6516_CopyScreenDataspy_001();
        this.tools.getDataTypeTools();
        copyScreenDataspy.setDDSPYID(DataTypeTools.encodeQuantity(dataspyCopy.getDataspyCode(), "Dataspy Code"));
        copyScreenDataspy.setUSERID(new USERID_Type());
        copyScreenDataspy.getUSERID().setUSERCODE(dataspyCopy.getUserCode());
        this.tools.getDataTypeTools();
        copyScreenDataspy.setDEFAULT(DataTypeTools.encodeBoolean(dataspyCopy.getDefaultDataspy(), BooleanType.PLUS_MINUS));
        MP6516_CopyScreenDataspy_001_Result result = null;
        String lastDataspy = this.getLastDataspy(context, dataspyCopy.getUserCode());
        result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).copyScreenDataspyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), copyScreenDataspy);
        result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).copyScreenDataspyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), copyScreenDataspy);
        String lastDataspyAfter = this.getLastDataspy(context, dataspyCopy.getUserCode());
        if (lastDataspyAfter != null && !lastDataspyAfter.equals(lastDataspy)) {
            return lastDataspyAfter.replaceAll(",", "");
        }
        return null;
    }

    private String getLastDataspy(InforContext context, String userCode) throws InforException {
        GridRequest gridRequest = new GridRequest("BEWSDP", 1);
        gridRequest.addFilter("dds_owner", userCode, "=");
        gridRequest.sortBy("dds_ddspyid", "DESC");
        GridRequestResult gridRequestResult = this.gridsService.executeQuery(context, gridRequest);
        return GridTools.extractSingleResult(gridRequestResult, "dds_ddspyid");
    }

    @Override
    public String deleteDataspy(InforContext context, BigDecimal dataspyId) throws InforException {
        MP6518_DeleteScreenDataspy_001 deleteScreenDataspy = new MP6518_DeleteScreenDataspy_001();
        deleteScreenDataspy.setSCREENDATASPYID(new SCREENDATASPYID_Type());
        deleteScreenDataspy.getSCREENDATASPYID().setDDSPYID(DataTypeTools.encodeQuantity(dataspyId, "Dataspy ID"));
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteScreenDataspyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteScreenDataspy);
        return dataspyId.toPlainString();
    }
}

