/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PartLotService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.lot_001.Lot;
import net.datastream.schemas.mp_fields.LOTID_Type;
import net.datastream.schemas.mp_functions.mp1201_001.MP1201_AddLot_001;
import net.datastream.schemas.mp_functions.mp1202_001.MP1202_SyncLot_001;
import net.datastream.schemas.mp_functions.mp1203_001.MP1203_DeleteLot_001;
import net.datastream.schemas.mp_functions.mp1205_001.MP1205_GetLot_001;
import net.datastream.schemas.mp_results.mp1202_001.MP1202_SyncLot_001_Result;
import net.datastream.schemas.mp_results.mp1203_001.MP1203_DeleteLot_001_Result;
import net.datastream.schemas.mp_results.mp1205_001.MP1205_GetLot_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PartLotServiceImpl
implements PartLotService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PartLotServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createLot(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Lot lot) throws InforException {
        Lot lotInfor = new Lot();
        this.tools.getInforFieldTools().transformWSHubObject(lotInfor, lot, context);
        MP1201_AddLot_001 addLot = new MP1201_AddLot_001();
        addLot.setLot(lotInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addLotOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addLot);
        return lot.getCode();
    }

    @Override
    public ch.cern.eam.wshub.core.services.material.entities.Lot readLot(InforContext context, String lotPk) throws InforException {
        Lot lot = this.readLotInfor(context, lotPk);
        return this.tools.getInforFieldTools().transformInforObject(new ch.cern.eam.wshub.core.services.material.entities.Lot(), lot, context);
    }

    @Override
    public String updateLot(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Lot lot) throws InforException {
        MP1202_SyncLot_001 syncLot = new MP1202_SyncLot_001();
        Lot prev = this.readLotInfor(context, lot.getCode());
        this.tools.getInforFieldTools().transformWSHubObject(prev, lot, context);
        syncLot.setLot(prev);
        MP1202_SyncLot_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncLotOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncLot);
        return result.getResultData().getLot().getLOTID().getLOTCODE();
    }

    @Override
    public String deleteLot(InforContext context, String lotCode) throws InforException {
        MP1203_DeleteLot_001 deleteLot = new MP1203_DeleteLot_001();
        LOTID_Type idType = new LOTID_Type();
        idType.setLOTCODE(lotCode);
        idType.setORGANIZATIONID(this.tools.getOrganization(context));
        deleteLot.setLOTID(idType);
        MP1203_DeleteLot_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteLotOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteLot);
        return result.getResultData().getLOTID().getLOTCODE();
    }

    private Lot readLotInfor(InforContext context, String lotCode) throws InforException {
        MP1205_GetLot_001 getLot = new MP1205_GetLot_001();
        LOTID_Type idType = new LOTID_Type();
        idType.setLOTCODE(lotCode);
        idType.setORGANIZATIONID(this.tools.getOrganization(context));
        getLot.setLOTID(idType);
        MP1205_GetLot_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getLotOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLot);
        return result.getResultData().getLot();
    }
}

