/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforClient;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.Pair;
import ch.cern.eam.wshub.core.services.entities.Signature;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.ChecklistService;
import ch.cern.eam.wshub.core.services.workorders.TaskPlanService;
import ch.cern.eam.wshub.core.services.workorders.entities.Activity;
import ch.cern.eam.wshub.core.services.workorders.entities.Finding;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskPlan;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskplanCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.UserQualification;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklist;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistDefaultResult;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistDefinition;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistItem;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignature;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignatureResponse;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignatureResult;
import ch.cern.eam.wshub.core.services.workorders.impl.TaskPlanServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.CacheKey;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.taskchecklist_001.TaskChecklist;
import net.datastream.schemas.mp_entities.workorderactivitychecklist_001.WorkOrderActivityCheckList;
import net.datastream.schemas.mp_entities.workorderactivitychecklistdefault_001.WorkOrderActivityCheckListDefault;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.ASPECTID_Type;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_fields.CHECKLISTID_Type;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.ENTITYCODEID_Type;
import net.datastream.schemas.mp_fields.ESIGNATURE;
import net.datastream.schemas.mp_fields.FINDINGID_Type;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.POINTTYPEID_Type;
import net.datastream.schemas.mp_fields.TASKLISTID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDCODEID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp5782_001.MP5782_UpdateWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp5782_001.WorkOrderActivityDetail;
import net.datastream.schemas.mp_functions.mp7913_001.MP7913_SyncWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7916_001.MP7916_AddTaskChecklist_001;
import net.datastream.schemas.mp_functions.mp7997_001.MP7997_PerformWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7998_001.MP7998_ReviewWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7999_001.MP7999_GetWorkOrderActivityCheckListDefault_001;
import net.datastream.schemas.mp_functions.mp8000_001.MP8000_CreateFollowUpWorkOrder_001;
import net.datastream.schemas.mp_results.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001_Result;
import net.datastream.schemas.mp_results.mp7999_001.MP7999_GetWorkOrderActivityCheckListDefault_001_Result;
import net.datastream.schemas.mp_results.mp8000_001.MP8000_CreateFollowUpWorkOrder_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class ChecklistServiceImpl
implements ChecklistService {
    private static final String PERFORMED_BY_1 = "PB01";
    private static final String PERFORMED_BY_2 = "PB02";
    private static final String REVIEWED_BY_1 = "RB01";
    private final Tools tools;
    private final InforWebServicesPT inforws;
    private final GridsService gridsService;
    private final TaskPlanService taskPlanService;

    public ChecklistServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.taskPlanService = new TaskPlanServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public WorkOrderActivityChecklistSignatureResult[] getSignatures(InforContext context, String workOrderCode, String activityCode, TaskPlan taskPlan) throws InforException {
        MP7999_GetWorkOrderActivityCheckListDefault_001_Result fetchedChecklistValues = this.getChecklistDefaults(context, workOrderCode, activityCode);
        WorkOrderActivityChecklistSignatureResult[] signatures = this.getFilteredSignatures(context, fetchedChecklistValues, taskPlan);
        this.getResponsibilityDescriptions(context, signatures);
        return signatures;
    }

    private WorkOrderActivityChecklistSignatureResult[] getFilteredSignatures(InforContext context, MP7999_GetWorkOrderActivityCheckListDefault_001_Result fetchedChecklistValues, TaskPlan taskPlan) {
        WorkOrderActivityChecklistDefaultResult workOrderActivityCheckListDefaultResult = new WorkOrderActivityChecklistDefaultResult();
        this.tools.getInforFieldTools().transformInforObject(workOrderActivityCheckListDefaultResult, fetchedChecklistValues.getResultData().getWorkOrderActivityCheckListDefault(), context);
        return this.filterSignatures(workOrderActivityCheckListDefaultResult, taskPlan);
    }

    private void getResponsibilityDescriptions(InforContext context, WorkOrderActivityChecklistSignatureResult[] signatures) throws InforException {
        GridRequest gridRequest = new GridRequest("LVUSERRESPONSIBILITIES");
        gridRequest.setDataspyID("4297");
        gridRequest.getParams().put("param.rentity", "RESP");
        LinkedList<GridRequestFilter> filters = new LinkedList<GridRequestFilter>();
        for (WorkOrderActivityChecklistSignatureResult signatureResult : signatures) {
            String responsibilityCode = signatureResult.getResponsibilityCode();
            if (responsibilityCode == null) continue;
            filters.add(new GridRequestFilter("responsibility", responsibilityCode, "=", GridRequestFilter.JOINER.OR, false, false));
        }
        if (filters.isEmpty()) {
            return;
        }
        gridRequest.setGridRequestFilters(filters);
        Map<String, String> responsibilityToDescription = GridTools.convertGridResultToMap("responsibility", "description", this.gridsService.executeQuery(context, gridRequest));
        Arrays.stream(signatures).forEach(signature -> {
            if (responsibilityToDescription.containsKey(signature.getResponsibilityCode())) {
                signature.setResponsibilityDescription((String)responsibilityToDescription.get(signature.getResponsibilityCode()));
            }
        });
    }

    private WorkOrderActivityChecklistSignatureResult[] filterSignatures(WorkOrderActivityChecklistDefaultResult workOrderActivityCheckList, TaskPlan taskPlan) {
        boolean performedBy2Hidden;
        String reviewerQualification = workOrderActivityCheckList.getReviewerQualification();
        String performer1Qualification = workOrderActivityCheckList.getPerformer1Qualification();
        String performer2Qualification = workOrderActivityCheckList.getPerformer2Qualification();
        String viewerQualification = taskPlan.getViewOnlyResponsibility();
        List<Object> qualifications = new ArrayList();
        if (workOrderActivityCheckList.getUserQualifications() != null) {
            qualifications = workOrderActivityCheckList.getUserQualifications().stream().map(UserQualification::getUserDefinedCode).collect(Collectors.toList());
        }
        boolean noRequiredQualifications = reviewerQualification == null && performer1Qualification == null && performer2Qualification == null && viewerQualification == null;
        boolean isViewer = noRequiredQualifications || viewerQualification != null && qualifications.contains(viewerQualification);
        boolean isPerformer1 = noRequiredQualifications || performer1Qualification == null && isViewer || qualifications.contains(performer1Qualification);
        boolean isPerformer2 = noRequiredQualifications || performer2Qualification == null && isPerformer1 || qualifications.contains(performer2Qualification);
        boolean isReviewer = noRequiredQualifications || reviewerQualification == null && (isPerformer1 || isPerformer2) || qualifications.contains(reviewerQualification);
        LinkedList<WorkOrderActivityChecklistSignatureResult> signatures = new LinkedList<WorkOrderActivityChecklistSignatureResult>();
        if (isPerformer1 || isReviewer || isViewer) {
            WorkOrderActivityChecklistSignatureResult perf1 = new WorkOrderActivityChecklistSignatureResult();
            perf1.setType(PERFORMED_BY_1);
            perf1.setSigner(workOrderActivityCheckList.getPerformer1Name());
            perf1.setViewAsViewer(isViewer);
            perf1.setViewAsPerformer(isPerformer1);
            perf1.setViewAsReviewer(isReviewer);
            perf1.setTime(workOrderActivityCheckList.getTimePerf1() != null ? workOrderActivityCheckList.getTimePerf1() : null);
            perf1.setResponsibilityCode(performer1Qualification);
            signatures.add(perf1);
        }
        if (!(performedBy2Hidden = taskPlan.getUserDefinedFields().getUdfchkbox02().booleanValue()) && (isPerformer2 || isReviewer || isViewer)) {
            WorkOrderActivityChecklistSignatureResult perf2 = new WorkOrderActivityChecklistSignatureResult();
            perf2.setType(PERFORMED_BY_2);
            perf2.setSigner(workOrderActivityCheckList.getPerformer2Name());
            perf2.setViewAsViewer(isViewer);
            perf2.setViewAsPerformer(isPerformer2);
            perf2.setViewAsReviewer(isReviewer);
            perf2.setTime(workOrderActivityCheckList.getTimePerf2() != null ? workOrderActivityCheckList.getTimePerf2() : null);
            perf2.setResponsibilityCode(performer2Qualification);
            signatures.add(perf2);
        }
        if (isPerformer1 || isPerformer2 || isReviewer || isViewer) {
            WorkOrderActivityChecklistSignatureResult reviewer = new WorkOrderActivityChecklistSignatureResult();
            reviewer.setType(REVIEWED_BY_1);
            reviewer.setSigner(workOrderActivityCheckList.getReviewerName());
            reviewer.setViewAsViewer(isViewer);
            reviewer.setViewAsPerformer(isReviewer);
            reviewer.setViewAsReviewer(isReviewer);
            reviewer.setTime(workOrderActivityCheckList.getTimeRev1() != null ? workOrderActivityCheckList.getTimeRev1() : null);
            if (reviewerQualification == null && performer1Qualification != null && performer2Qualification == null) {
                reviewerQualification = performer1Qualification;
            }
            reviewer.setResponsibilityCode(reviewerQualification);
            signatures.add(reviewer);
        }
        return signatures.toArray(new WorkOrderActivityChecklistSignatureResult[0]);
    }

    private MP7999_GetWorkOrderActivityCheckListDefault_001_Result getChecklistDefaults(InforContext context, String workOrderCode, String activityCode) throws InforException {
        MP7999_GetWorkOrderActivityCheckListDefault_001 getWorkOrderActivityCheckListDefault = new MP7999_GetWorkOrderActivityCheckListDefault_001();
        this.transformGetWorkOrderActivityCheckListDefaultRequest(getWorkOrderActivityCheckListDefault, workOrderCode, activityCode);
        return this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderActivityCheckListDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkOrderActivityCheckListDefault);
    }

    private void transformGetWorkOrderActivityCheckListDefaultRequest(MP7999_GetWorkOrderActivityCheckListDefault_001 getWorkOrderActivityCheckListDefault, String workOrderCode, String activityCode) {
        ACTIVITYCODE activityCodeField = new ACTIVITYCODE();
        activityCodeField.setValue(Long.parseLong(activityCode));
        getWorkOrderActivityCheckListDefault.setACTIVITYCODE(activityCodeField);
        WOID_Type workOrderID = new WOID_Type();
        workOrderID.setJOBNUM(workOrderCode);
        workOrderID.setAuto_Generated(Boolean.valueOf(true));
        getWorkOrderActivityCheckListDefault.setWORKORDERID(workOrderID);
    }

    @Override
    public WorkOrderActivityChecklistSignatureResponse eSignWorkOrderActivityChecklist(InforContext context, WorkOrderActivityChecklistSignature workOrderActivityCheckListSignature) throws InforException {
        Signature signature = new Signature();
        signature.setUserCode(workOrderActivityCheckListSignature.getUserCode());
        signature.setPassword(workOrderActivityCheckListSignature.getPassword());
        signature.setSignatureType(workOrderActivityCheckListSignature.getSignatureType());
        context.setSignature(signature);
        if (signature.getSignatureType().endsWith("02")) {
            workOrderActivityCheckListSignature.setSequenceNumber(new BigInteger("2"));
        }
        if (workOrderActivityCheckListSignature.getSignatureType().startsWith("PB")) {
            return this.performWorkOrderActivityChecklist(context, workOrderActivityCheckListSignature);
        }
        return this.reviewWorkOrderActivityCheckList(context, workOrderActivityCheckListSignature);
    }

    private WorkOrderActivityChecklistSignatureResponse performWorkOrderActivityChecklist(InforContext context, WorkOrderActivityChecklistSignature workOrderActivityCheckListSignature) throws InforException {
        MP7997_PerformWorkOrderActivityCheckList_001 performWorkOrderActivityCheckList = new MP7997_PerformWorkOrderActivityCheckList_001();
        this.tools.getInforFieldTools().transformWSHubObject(performWorkOrderActivityCheckList, workOrderActivityCheckListSignature, context);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).performWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), performWorkOrderActivityCheckList);
        MP7999_GetWorkOrderActivityCheckListDefault_001_Result getResult = this.getChecklistDefaults(context, workOrderActivityCheckListSignature.getWorkOrderCode(), workOrderActivityCheckListSignature.getActivityCodeValue().toString());
        if (workOrderActivityCheckListSignature.getSequenceNumber() != null && workOrderActivityCheckListSignature.getSequenceNumber().intValue() == 2) {
            return this.transformESIGNATUREtoResponse(getResult.getResultData().getWorkOrderActivityCheckListDefault().getPERFORMEDBYESIGN2().getESIGNATURE());
        }
        return this.transformESIGNATUREtoResponse(getResult.getResultData().getWorkOrderActivityCheckListDefault().getPERFORMEDBYESIGN().getESIGNATURE());
    }

    private WorkOrderActivityChecklistSignatureResponse reviewWorkOrderActivityCheckList(InforContext context, WorkOrderActivityChecklistSignature workOrderActivityCheckListSignature) throws InforException {
        MP7998_ReviewWorkOrderActivityCheckList_001 reviewWorkOrderActivityCheckList = new MP7998_ReviewWorkOrderActivityCheckList_001();
        this.tools.getInforFieldTools().transformWSHubObject(reviewWorkOrderActivityCheckList, workOrderActivityCheckListSignature, context);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).reviewWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), reviewWorkOrderActivityCheckList);
        MP7999_GetWorkOrderActivityCheckListDefault_001_Result getResult = this.getChecklistDefaults(context, workOrderActivityCheckListSignature.getWorkOrderCode(), workOrderActivityCheckListSignature.getActivityCodeValue().toString());
        return this.transformESIGNATUREtoResponse(getResult.getResultData().getWorkOrderActivityCheckListDefault().getREVIEWEDBYESIGN().getESIGNATURE());
    }

    private WorkOrderActivityChecklistSignatureResponse transformESIGNATUREtoResponse(ESIGNATURE eSignature) {
        WorkOrderActivityChecklistSignatureResponse response = new WorkOrderActivityChecklistSignatureResponse();
        response.setSigner(eSignature.getUSERID().getDESCRIPTION());
        response.setTimeStamp(DataTypeTools.decodeInforDate(eSignature.getEXTERNALDATETIME()));
        return response;
    }

    @Override
    public String updateWorkOrderActivityCheckList(InforContext context, WorkOrderActivityChecklist workOrderActivityChecklist, boolean shouldMergeExistingValues) throws InforException {
        if (shouldMergeExistingValues) {
            MP7999_GetWorkOrderActivityCheckListDefault_001_Result fetchedExistingValues = this.getChecklistDefaults(context, workOrderActivityChecklist.getWorkOrderCode(), String.valueOf(workOrderActivityChecklist.getActivityCode()));
            this.mergeChecklistValues(workOrderActivityChecklist, fetchedExistingValues);
        }
        MP5782_UpdateWorkOrderActivityCheckList_001 updateCheckList = new MP5782_UpdateWorkOrderActivityCheckList_001();
        updateCheckList.setWorkOrderActivityDetail(this.tools.getInforFieldTools().transformWSHubObject(new WorkOrderActivityDetail(), workOrderActivityChecklist, context));
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).updateWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), updateCheckList);
        return "OK";
    }

    private void mergeChecklistValues(WorkOrderActivityChecklist workOrderActivityChecklist, MP7999_GetWorkOrderActivityCheckListDefault_001_Result fetchedValues) {
        WorkOrderActivityCheckListDefault existingValues = fetchedValues.getResultData().getWorkOrderActivityCheckListDefault();
        if (workOrderActivityChecklist.getJobSequence() == null) {
            workOrderActivityChecklist.setJobSequence(existingValues.getJOBSEQUENCE());
        }
        if (workOrderActivityChecklist.getRejectPerformedBy() == null) {
            workOrderActivityChecklist.setRejectPerformedBy(Boolean.parseBoolean(existingValues.getREJECTPERFORMEDBY()));
        }
        if (workOrderActivityChecklist.getRejectPerformedBy2() == null) {
            workOrderActivityChecklist.setRejectPerformedBy2(Boolean.parseBoolean(existingValues.getREJECTPERFORMEDBY2()));
        }
        if (workOrderActivityChecklist.getRejectionReason() == null) {
            workOrderActivityChecklist.setRejectionReason(existingValues.getREJECTIONREASON());
        }
        if (workOrderActivityChecklist.getConditionOptionUserDefinedCode() == null && existingValues.getCONDITIONOPTION() != null) {
            workOrderActivityChecklist.setConditionOptionUserDefinedCode(existingValues.getCONDITIONOPTION().getUSERDEFINEDCODE());
        }
    }

    @Override
    public String updateWorkOrderChecklistItem(InforContext context, WorkOrderActivityChecklistItem workOrderActivityChecklistItem, TaskPlan taskPlan) throws InforException {
        MP7914_GetWorkOrderActivityCheckList_001 getwoactchl = new MP7914_GetWorkOrderActivityCheckList_001();
        getwoactchl.setCHECKLISTCODE(workOrderActivityChecklistItem.getCheckListCode());
        MP7914_GetWorkOrderActivityCheckList_001_Result getresult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getwoactchl);
        WorkOrderActivityCheckList workOrderActivityCheckListInfor = getresult.getResultData().getWorkOrderActivityCheckList();
        if (workOrderActivityChecklistItem.getFollowUp() != null) {
            this.tools.getDataTypeTools();
            workOrderActivityCheckListInfor.setFOLLOWUP(DataTypeTools.encodeBoolean(workOrderActivityChecklistItem.getFollowUp(), BooleanType.PLUS_MINUS));
        }
        if (workOrderActivityChecklistItem.getNotApplicableOption() != null) {
            USERDEFINEDCODEID_Type option = new USERDEFINEDCODEID_Type();
            option.setUSERDEFINEDCODE(workOrderActivityChecklistItem.getNotApplicableOption());
            workOrderActivityCheckListInfor.setNOTAPPLICABLEOPTION(option);
        }
        Function<String, String> getStringBool = key -> String.valueOf(key.equals(workOrderActivityChecklistItem.getResult()));
        switch (workOrderActivityChecklistItem.getType()) {
            case "01": {
                if ("COMPLETED".equalsIgnoreCase(workOrderActivityChecklistItem.getResult())) {
                    workOrderActivityCheckListInfor.setCOMPLETED("true");
                    break;
                }
                workOrderActivityCheckListInfor.setCOMPLETED("false");
                break;
            }
            case "02": {
                workOrderActivityCheckListInfor.setYES(getStringBool.apply("YES"));
                workOrderActivityCheckListInfor.setNO(getStringBool.apply("NO"));
                break;
            }
            case "03": {
                if (workOrderActivityChecklistItem.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityChecklistItem.getFinding());
                    break;
                }
                workOrderActivityCheckListInfor.setFINDINGID(null);
                break;
            }
            case "06": {
                if (workOrderActivityChecklistItem.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityChecklistItem.getFinding());
                } else {
                    workOrderActivityCheckListInfor.setFINDINGID(null);
                }
            }
            case "04": 
            case "05": {
                BigDecimal possibleNumericValue;
                BigDecimal numericValue = workOrderActivityChecklistItem.getNumericValue();
                if (numericValue == null && (possibleNumericValue = DataTypeTools.encodeBigDecimal(workOrderActivityChecklistItem.getResult(), "")) != null) {
                    numericValue = possibleNumericValue;
                }
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(numericValue, "Checklists Value"));
                break;
            }
            case "07": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setREPAIRSNEEDED(getStringBool.apply("REPAIRSNEEDED"));
                if (DataTypeTools.isEmpty(workOrderActivityChecklistItem.getFinding())) {
                    workOrderActivityCheckListInfor.setRESOLUTIONID(null);
                    break;
                }
                workOrderActivityCheckListInfor.setRESOLUTIONID(new USERDEFINEDCODEID_Type());
                workOrderActivityCheckListInfor.getRESOLUTIONID().setUSERDEFINEDCODE(workOrderActivityChecklistItem.getFinding());
                break;
            }
            case "08": {
                workOrderActivityCheckListInfor.setGOOD(getStringBool.apply("GOOD"));
                workOrderActivityCheckListInfor.setPOOR(getStringBool.apply("POOR"));
                break;
            }
            case "10": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(workOrderActivityChecklistItem.getNumericValue(), "Checklists Value"));
            }
            case "09": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setADJUSTED(getStringBool.apply("ADJUSTED"));
                break;
            }
            case "12": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(workOrderActivityChecklistItem.getNumericValue(), "Checklists Value"));
            }
            case "11": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setNONCONFORMITYFLAG(getStringBool.apply("NONCONFORMITY"));
                break;
            }
            case "13": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setCHECKLISTDATE(DataTypeTools.encodeInforDate(workOrderActivityChecklistItem.getDate(), ""));
                break;
            }
            case "14": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setCHECKLISTDATETIME(DataTypeTools.encodeInforDate(workOrderActivityChecklistItem.getDateTime(), ""));
                break;
            }
            case "15": {
                workOrderActivityCheckListInfor.setCHECKLISTFREETEXT(workOrderActivityChecklistItem.getFreeText());
                break;
            }
            case "16": {
                if (DataTypeTools.isEmpty(workOrderActivityChecklistItem.getEntityCode())) {
                    workOrderActivityCheckListInfor.setENTITYCODEID(null);
                    break;
                }
                workOrderActivityCheckListInfor.setENTITYCODEID(new ENTITYCODEID_Type());
                workOrderActivityCheckListInfor.getENTITYCODEID().setCODE(workOrderActivityChecklistItem.getEntityCode());
                ORGANIZATIONID_Type organizationidType = new ORGANIZATIONID_Type();
                organizationidType.setORGANIZATIONCODE(DataTypeTools.isEmpty(workOrderActivityChecklistItem.getEntityCodeOrg()) ? this.tools.getOrganizationCode(context) : workOrderActivityChecklistItem.getEntityCodeOrg());
                workOrderActivityCheckListInfor.getENTITYCODEID().setORGANIZATIONID(organizationidType);
                break;
            }
            case "17": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(workOrderActivityChecklistItem.getNumericValue(), "Checklists Value"));
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE2(DataTypeTools.encodeQuantity(workOrderActivityChecklistItem.getNumericValue2(), "Checklists Value"));
            }
        }
        if (workOrderActivityChecklistItem.getNotes() != null) {
            workOrderActivityCheckListInfor.setNOTES(workOrderActivityChecklistItem.getNotes());
        }
        MP7913_SyncWorkOrderActivityCheckList_001 syncwoactchl = new MP7913_SyncWorkOrderActivityCheckList_001();
        syncwoactchl.setWorkOrderActivityCheckList(workOrderActivityCheckListInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncwoactchl);
        if (taskPlan != null) {
            this.invalidateSignatures(context, workOrderActivityChecklistItem.getWorkOrderCode(), workOrderActivityChecklistItem.getActivityCode(), taskPlan);
        }
        return null;
    }

    private void invalidateSignatures(InforContext context, String workOrderCode, String activityCode, TaskPlan taskPlan) throws InforException {
        TaskPlan fetchedTaskPlan = this.taskPlanService.getTaskPlan(context, taskPlan);
        MP7999_GetWorkOrderActivityCheckListDefault_001_Result fetchedChecklistValues = this.getChecklistDefaults(context, workOrderCode, activityCode);
        WorkOrderActivityChecklistSignatureResult[] signatures = this.getFilteredSignatures(context, fetchedChecklistValues, fetchedTaskPlan);
        if (signatures.length == 0) {
            return;
        }
        WorkOrderActivityChecklist checklist = new WorkOrderActivityChecklist(workOrderCode, Long.parseLong(activityCode));
        for (WorkOrderActivityChecklistSignatureResult signature : signatures) {
            if (signature.getSigner() == null) continue;
            if (PERFORMED_BY_1.equals(signature.getType())) {
                checklist.setRejectPerformedBy(true);
                continue;
            }
            if (!PERFORMED_BY_2.equals(signature.getType())) continue;
            checklist.setRejectPerformedBy2(true);
        }
        if (Boolean.TRUE.equals(checklist.getRejectPerformedBy()) || Boolean.TRUE.equals(checklist.getRejectPerformedBy2())) {
            checklist.setRejectionReason("The checklist was updated.");
        }
        this.mergeChecklistValues(checklist, fetchedChecklistValues);
        this.updateWorkOrderActivityCheckList(context, checklist, false);
    }

    @Override
    public String createTaskplanChecklist(InforContext context, TaskplanCheckList taskChecklist) throws InforException {
        TaskChecklist taskChecklistInfor = new TaskChecklist();
        taskChecklistInfor.setTASKLISTID(new TASKLISTID_Type());
        taskChecklistInfor.getTASKLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
        taskChecklistInfor.getTASKLISTID().setTASKCODE(taskChecklist.getTaskPlanCode());
        if (taskChecklist.getTaskPlanRevision() == null) {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(0L));
        } else {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getTaskPlanRevision(), "Task Revision")));
        }
        taskChecklistInfor.setCHECKLISTID(new CHECKLISTID_Type());
        taskChecklistInfor.getCHECKLISTID().setCHECKLISTCODE("0");
        taskChecklistInfor.getCHECKLISTID().setDESCRIPTION(taskChecklist.getChecklistDesc());
        taskChecklistInfor.setSEQUENCE(this.tools.getDataTypeTools().encodeLong(taskChecklist.getSequence(), "Sequence number"));
        taskChecklistInfor.setTYPE(new TYPE_Type());
        taskChecklistInfor.getTYPE().setTYPECODE(taskChecklist.getType());
        taskChecklistInfor.setREQUIREDTOCLOSEDOC(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getREQUIREDTOCLOSEDOC().setUSERDEFINEDCODE(taskChecklist.getRequiredEntry());
        taskChecklistInfor.setEQUIPMENTLEVEL(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getEQUIPMENTLEVEL().setUSERDEFINEDCODE(taskChecklist.getEquipmentLevel());
        if (taskChecklist.getFindings() != null) {
            taskChecklistInfor.setPOSSIBLEFINDINGS(taskChecklist.getFindings());
        }
        if (taskChecklist.getUOM() != null) {
            taskChecklistInfor.setUOMID(new UOMID_Type());
            taskChecklistInfor.getUOMID().setUOMCODE(taskChecklist.getUOM());
        }
        if (taskChecklist.getAspectCode() != null) {
            taskChecklistInfor.setASPECTID(new ASPECTID_Type());
            taskChecklistInfor.getASPECTID().setASPECTCODE(taskChecklist.getAspectCode());
        }
        if (taskChecklist.getPointType() != null) {
            taskChecklistInfor.setPOINTTYPEID(new POINTTYPEID_Type());
            taskChecklistInfor.getPOINTTYPEID().setPOINTTYPECODE(taskChecklist.getPointType());
        }
        taskChecklistInfor.setREPEATINGOCCURRENCES(taskChecklist.getRepeatingOccurrences());
        if (taskChecklist.getFollowUpTaskPlan() != null) {
            taskChecklistInfor.setFOLLOWUPTASKID(new TASKLISTID_Type());
            taskChecklistInfor.getFOLLOWUPTASKID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getFOLLOWUPTASKID().setTASKCODE(taskChecklist.getFollowUpTaskPlan());
            if (taskChecklist.getFollowUpTaskPlanRevision() != null) {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getFollowUpTaskPlanRevision(), "Follow Up Task Plan Revision")));
            } else {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(0L));
            }
        }
        if (taskChecklist.getClassCode() != null && !taskChecklist.getClassCode().trim().isEmpty()) {
            taskChecklistInfor.setCLASSID(new CLASSID_Type());
            taskChecklistInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getCLASSID().setCLASSCODE(taskChecklist.getClassCode());
        }
        if (taskChecklist.getCategoryCode() != null && !taskChecklist.getCategoryCode().trim().isEmpty()) {
            taskChecklistInfor.setCATEGORYID(new CATEGORYID());
            taskChecklistInfor.getCATEGORYID().setCATEGORYCODE(taskChecklist.getCategoryCode());
        }
        if (DataTypeTools.isNotEmpty(taskChecklist.getEquipmentFilter())) {
            taskChecklistInfor.setEQUIPMENTFILTER(taskChecklist.getEquipmentFilter());
        }
        MP7916_AddTaskChecklist_001 addTaskChecklist = new MP7916_AddTaskChecklist_001();
        addTaskChecklist.setTaskChecklist(taskChecklistInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addTaskChecklistOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addTaskChecklist);
        return "OK";
    }

    @Override
    public WorkOrderActivityChecklistItem[] readWorkOrderChecklistItems(InforContext context, Activity activity) throws InforException {
        GridRequest gridRequest = new GridRequest("WSJOBS_ACK");
        gridRequest.setRowCount(2000);
        gridRequest.setUseNative(true);
        gridRequest.setUserFunctionName("WSJOBS");
        gridRequest.getParams().put("param.workordernum", activity.getWorkOrderNumber());
        gridRequest.getParams().put("param.activity", activity.getActivityCode().toString());
        gridRequest.getParams().put("param.jobseq", "0");
        GridRequestResult gridRequestResult = this.gridsService.executeQuery(context, gridRequest);
        LinkedList<WorkOrderActivityChecklistItem> checklists = new LinkedList<WorkOrderActivityChecklistItem>();
        for (GridRequestRow row : gridRequestResult.getRows()) {
            checklists.add(this.getCheckList(context, row, activity));
        }
        return checklists.toArray(new WorkOrderActivityChecklistItem[0]);
    }

    private WorkOrderActivityChecklistItem getCheckList(InforContext context, GridRequestRow row, Activity activity) throws InforException {
        WorkOrderActivityChecklistItem checklist = new WorkOrderActivityChecklistItem();
        checklist.setWorkOrderCode(activity.getWorkOrderNumber());
        checklist.setActivityCode(activity.getActivityCode().toString());
        checklist.setCheckListCode(GridTools.getCellContent("checklistcode", row));
        checklist.setSequence(GridTools.getCellContent("checklistsequence", row));
        checklist.setEquipmentCode(GridTools.getCellContent("equipment", row));
        checklist.setEquipmentDesc(GridTools.getCellContent("equipmentdesc", row));
        checklist.setType(GridTools.getCellContent("checklisttype", row));
        checklist.setColor(GridTools.getCellContent("color", row));
        checklist.setFollowUp(DataTypeTools.decodeBoolean(GridTools.getCellContent("followup", row)));
        String followUpWorkOrderActivity = GridTools.getCellContent("followupwoactivity", row);
        if (DataTypeTools.isNotEmpty(followUpWorkOrderActivity)) {
            checklist.setFollowUpWorkOrder(followUpWorkOrderActivity.split("-")[0]);
        }
        String required = GridTools.getCellContent("requiredtoclosedocument", row);
        checklist.setRequiredToClose("Yes".equalsIgnoreCase(required));
        checklist.setConditional("X".equalsIgnoreCase(GridTools.getCellContent("conditionpk", row)));
        checklist.setNotes(GridTools.getCellContent("notes", row));
        checklist.setDesc(GridTools.getCellContent("checklistdescription", row));
        checklist.setHideFollowUp(this.cellEquals(row, "hidefollowup", "true"));
        checklist.setMinimumValue(DataTypeTools.encodeBigInteger(GridTools.getCellContent("minimumslidervalue", row), "minimumslidervalue"));
        checklist.setMaximumValue(DataTypeTools.encodeBigInteger(GridTools.getCellContent("maximumslidervalue", row), "maximumslidervalue"));
        checklist.setMinimumValue2(DataTypeTools.encodeBigInteger(GridTools.getCellContent("minimumslidervalue2", row), "minimumslidervalue2"));
        checklist.setMaximumValue2(DataTypeTools.encodeBigInteger(GridTools.getCellContent("maximumslidervalue2", row), "maximumslidervalue2"));
        checklist.setNotApplicableOption(GridTools.getCellContent("notapplicable", row));
        checklist.setChecklistDefinitionCode(GridTools.getCellContent("taskchecklistcode", row));
        switch (checklist.getType()) {
            case "01": {
                if (this.cellEquals(row, "completed", "true")) {
                    checklist.setResult("COMPLETED");
                    break;
                }
                checklist.setResult(WorkOrderActivityChecklistItem.ReturnType.NULL);
                break;
            }
            case "02": {
                if (this.cellEquals(row, "yes", "true")) {
                    checklist.setResult("YES");
                    break;
                }
                if (this.cellEquals(row, "no", "true")) {
                    checklist.setResult("NO");
                    break;
                }
                checklist.setResult(null);
                break;
            }
            case "03": {
                checklist.setFinding(GridTools.getCellContent("finding", row));
                checklist.setPossibleFindings(this.getPossibleFindings(context, row));
                break;
            }
            case "06": {
                checklist.setFinding(GridTools.getCellContent("finding", row));
                checklist.setPossibleFindings(this.getPossibleFindings(context, row));
            }
            case "04": 
            case "05": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
                checklist.setResult(GridTools.getCellContent("value", row));
                break;
            }
            case "08": {
                if (this.cellEquals(row, "good", "true")) {
                    checklist.setResult("GOOD");
                    break;
                }
                if (this.cellEquals(row, "poor", "true")) {
                    checklist.setResult("POOR");
                    break;
                }
                checklist.setResult(WorkOrderActivityChecklistItem.ReturnType.NULL);
                break;
            }
            case "12": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
            }
            case "11": {
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "nonconformityfound", "true")) {
                    checklist.setResult("NONCONFORMITY");
                    break;
                }
                checklist.setResult(WorkOrderActivityChecklistItem.ReturnType.NULL);
                break;
            }
            case "10": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
            }
            case "09": {
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "adjusted", "true")) {
                    checklist.setResult("ADJUSTED");
                    break;
                }
                checklist.setResult(WorkOrderActivityChecklistItem.ReturnType.NULL);
                break;
            }
            case "07": {
                checklist.setFinding(GridTools.getCellContent("resolution", row));
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "repairsneeded", "true")) {
                    checklist.setResult("REPAIRSNEEDED");
                    break;
                }
                checklist.setResult(WorkOrderActivityChecklistItem.ReturnType.NULL);
                break;
            }
            case "13": {
                checklist.setDate(DataTypeTools.convertStringToDate(GridTools.getCellContent("checklistdate", row)));
                break;
            }
            case "14": {
                checklist.setDateTime(DataTypeTools.convertStringToDate(GridTools.getCellContent("checklistdatetime", row)));
                break;
            }
            case "15": {
                checklist.setFreeText(GridTools.getCellContent("checklistfreetext", row));
                break;
            }
            case "16": {
                checklist.setEntityCode(GridTools.getCellContent("entitycode", row));
                checklist.setEntityCodeOrg(GridTools.getCellContent("entitycodeorg", row));
                checklist.setEntityType(GridTools.getCellContent("rentitycode", row));
                checklist.setEntityClass(GridTools.getCellContent("entityclassoptions", row));
                break;
            }
            case "17": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setNumericValue2(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value2", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
                checklist.setUOM2(GridTools.getCellContent("uom2", row));
            }
        }
        return checklist;
    }

    private List<Finding> getPossibleFindings(InforContext context, GridRequestRow row) {
        List<String> possibleFindings = Arrays.asList(GridTools.getCellContent("possiblefindings", row).split(","));
        return possibleFindings.stream().map(findingCode -> {
            String findingsCacheKey = Tools.getCacheKey(context, findingCode);
            Function<String, String> loader = key -> this.loadFinding(context, (String)findingCode);
            String finding = Optional.ofNullable(InforClient.cacheMap.get((Object)CacheKey.FINDINGS)).map(cache -> (String)cache.get((Object)findingsCacheKey, loader)).orElseGet(() -> (String)loader.apply(findingsCacheKey));
            return new Finding((String)findingCode, finding != null ? finding : findingCode);
        }).collect(Collectors.toList());
    }

    private String loadFinding(InforContext context, String findingCode) {
        try {
            GridRequest gridRequest = new GridRequest("ISFIND", GridRequest.GRIDTYPE.LIST);
            gridRequest.addFilter("findingcode", findingCode, "=");
            return GridTools.extractSingleResult(this.gridsService.executeQuery(context, gridRequest), "findingdesc");
        }
        catch (Exception e) {
            this.tools.log(Level.WARNING, "Finding could not be fetched: " + e.getMessage());
            return null;
        }
    }

    private boolean cellEquals(GridRequestRow row, String key, String value) {
        return GridTools.getCellContent(key, row) != null && GridTools.getCellContent(key, row).equals(value);
    }

    private String getValue(ResultSet v_result) throws SQLException {
        double value = v_result.getDouble("ack_value");
        if (v_result.wasNull()) {
            return null;
        }
        return Double.toString(value);
    }

    @Override
    public Long createFollowUpWorkOrders(InforContext context, Activity activity) throws InforException {
        MP8000_CreateFollowUpWorkOrder_001 createFUWO = new MP8000_CreateFollowUpWorkOrder_001();
        createFUWO.setACTIVITYID(new ACTIVITYID());
        createFUWO.getACTIVITYID().setWORKORDERID(new WOID_Type());
        createFUWO.getACTIVITYID().getWORKORDERID().setJOBNUM(activity.getWorkOrderNumber());
        createFUWO.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        createFUWO.getACTIVITYID().getACTIVITYCODE().setValue(activity.getActivityCode().longValue());
        createFUWO.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP8000_CreateFollowUpWorkOrder_001_Result createFUWOResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).createFollowUpWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), createFUWO);
        return createFUWOResult.getResultData().getWORKORDERCOUNT();
    }

    @Override
    public WorkOrderActivityChecklistDefinition getChecklistDefinition(InforContext context, TaskPlan taskPlan, String code) throws InforException {
        GridRequest gridRequest = new GridRequest("WSTASK_TCH", 1);
        gridRequest.addParam("param.task", taskPlan.getCode());
        gridRequest.addParam("param.revision", taskPlan.getTaskRevision() == null ? null : taskPlan.getTaskRevision().toString());
        gridRequest.addFilter("checklistitem", code, "EQUALS");
        GridRequestResult result = this.gridsService.executeQuery(context, gridRequest);
        WorkOrderActivityChecklistDefinition definition = GridTools.convertGridResultToObject(WorkOrderActivityChecklistDefinition.class, null, result).stream().findFirst().orElse(null);
        String notApplicableOptionsString = GridTools.extractSingleResult(result, "naoptions");
        if (notApplicableOptionsString == null || notApplicableOptionsString.isEmpty()) {
            return definition;
        }
        GridRequest notApplicableOptionsRequest = new GridRequest("LVNAOPTIONS", 2000);
        Map<String, String> notApplicableOptionsMap = GridTools.convertGridResultToMap("code", "description", this.gridsService.executeQuery(context, notApplicableOptionsRequest));
        List<Pair> notApplicableOptions = Arrays.stream(notApplicableOptionsString.split(",")).map(optionCode -> new Pair((String)optionCode, (String)notApplicableOptionsMap.get(optionCode))).collect(Collectors.toList());
        definition.setNotApplicableOptions(notApplicableOptions);
        return definition;
    }
}

