/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.equipment.AssetService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentFacadeService;
import ch.cern.eam.wshub.core.services.equipment.PositionService;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.equipment.impl.AssetServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentTools;
import ch.cern.eam.wshub.core.services.equipment.impl.PositionServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.SystemServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class EquipmentFacadeServiceImpl
implements EquipmentFacadeService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private AssetService assetService;
    private PositionService positionService;
    private SystemService systemService;
    private EquipmentTools equipmentTools;

    public EquipmentFacadeServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.assetService = new AssetServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.positionService = new PositionServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.systemService = new SystemServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.equipmentTools = new EquipmentTools(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createEquipmentBatch(InforContext inforContext, List<Equipment> equipmentList) {
        return this.tools.batchOperation(inforContext, this::createEquipment, equipmentList);
    }

    @Override
    public BatchResponse<Equipment> readEquipmentBatch(InforContext inforContext, List<String> equipmentCodes) {
        return this.tools.batchOperation(inforContext, this::readEquipment, equipmentCodes);
    }

    @Override
    public BatchResponse<String> updateEquipmentBatch(InforContext inforContext, List<Equipment> equipmentList) {
        return this.tools.batchOperation(inforContext, this::updateEquipment, equipmentList);
    }

    @Override
    public BatchResponse<String> deleteEquipmentBatch(InforContext inforContext, List<String> equipmentCodes) {
        return this.tools.batchOperation(inforContext, this::deleteEquipment, equipmentCodes);
    }

    @Override
    public String updateEquipment(InforContext inforContext, Equipment equipment) throws InforException {
        Map<String, String> customFieldMap = equipment.getCustomFieldMap();
        if (customFieldMap != null) {
            CustomField[] customFields = (CustomField[])customFieldMap.entrySet().stream().map(s -> new CustomField((String)s.getKey(), (String)s.getValue())).toArray(CustomField[]::new);
            equipment.setCustomFields(customFields);
        }
        if (equipment.getSystemTypeCode() == null) {
            equipment.setSystemTypeCode(this.equipmentTools.getEquipmentSystemTypeForEquipment(inforContext, equipment.getCode(), equipment.getOrganization()));
        }
        switch (equipment.getSystemTypeCode()) {
            case "A": {
                return this.assetService.updateAsset(inforContext, equipment);
            }
            case "P": {
                return this.positionService.updatePosition(inforContext, equipment);
            }
            case "S": {
                return this.systemService.updateSystem(inforContext, equipment);
            }
            case "L": {
                throw Tools.generateFault("Locations are not available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Wrong equipment type.");
    }

    @Override
    public String createEquipment(InforContext inforContext, Equipment equipment) throws InforException {
        if (equipment.getTypeCode() == null) {
            throw Tools.generateFault("Equipment type can not be empty.");
        }
        Map<String, String> customFieldMap = equipment.getCustomFieldMap();
        if (customFieldMap != null) {
            CustomField[] customFields = (CustomField[])customFieldMap.entrySet().stream().map(s -> new CustomField((String)s.getKey(), (String)s.getValue())).toArray(CustomField[]::new);
            equipment.setCustomFields(customFields);
        }
        if (equipment.getSystemTypeCode() == null) {
            equipment.setSystemTypeCode(this.equipmentTools.getEquipmentSystemTypeForUserType(inforContext, equipment.getTypeCode()));
        }
        switch (equipment.getSystemTypeCode()) {
            case "A": {
                return this.assetService.createAsset(inforContext, equipment);
            }
            case "P": {
                return this.positionService.createPosition(inforContext, equipment);
            }
            case "S": {
                return this.systemService.createSystem(inforContext, equipment);
            }
            case "L": {
                throw Tools.generateFault("Locations are not available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    @Override
    public Equipment readEquipment(InforContext inforContext, String equipmentCode) throws InforException {
        Equipment equipment;
        String equipmentTypeCode;
        String code = Tools.extractEntityCode(equipmentCode);
        String organization = Tools.extractOrganizationCode(equipmentCode);
        switch (equipmentTypeCode = this.equipmentTools.getEquipmentSystemTypeForEquipment(inforContext, code, organization)) {
            case "A": {
                equipment = this.assetService.readAsset(inforContext, code, organization);
                break;
            }
            case "P": {
                equipment = this.positionService.readPosition(inforContext, code, organization);
                break;
            }
            case "S": {
                equipment = this.systemService.readSystem(inforContext, code, organization);
                break;
            }
            case "L": {
                throw Tools.generateFault("Locations are no longer available here. Use LocationService.");
            }
            default: {
                throw Tools.generateFault("Equipment type not recognized.");
            }
        }
        CustomField[] customFields = equipment.getCustomFields();
        if (customFields != null) {
            Map<String, String> collect = Arrays.stream(customFields).collect(Collectors.toMap(CustomField::getCode, s -> s.getValue() != null ? s.getValue() : ""));
            equipment.setCustomFieldMap(collect);
        }
        return equipment;
    }

    @Override
    public String deleteEquipment(InforContext inforContext, String equipmentCode) throws InforException {
        String equipmentTypeCode;
        String code = Tools.extractEntityCode(equipmentCode);
        String organization = Tools.extractOrganizationCode(equipmentCode);
        switch (equipmentTypeCode = this.equipmentTools.getEquipmentSystemTypeForEquipment(inforContext, code, organization)) {
            case "A": {
                return this.assetService.deleteAsset(inforContext, code, organization);
            }
            case "P": {
                return this.positionService.deletePosition(inforContext, code, organization);
            }
            case "S": {
                return this.systemService.deleteSystem(inforContext, code, organization);
            }
            case "L": {
                throw Tools.generateFault("Locations are no longer available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    @Override
    public String readEquipmentType(InforContext inforContext, String equipmentCode) throws InforException {
        return this.equipmentTools.getEquipmentSystemTypeForEquipment(inforContext, Tools.extractEntityCode(equipmentCode), Tools.extractOrganizationCode(equipmentCode));
    }
}

