/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.NonPoReceiptPartService;
import ch.cern.eam.wshub.core.services.material.NonPoReceiptService;
import ch.cern.eam.wshub.core.services.material.entities.NoPoReceipt;
import ch.cern.eam.wshub.core.services.material.entities.NoPoReceiptPart;
import ch.cern.eam.wshub.core.services.material.entities.TransactionLineId;
import ch.cern.eam.wshub.core.services.material.impl.NonPoReceiptPartServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.nonporeceipt_001.NonPOReceipt;
import net.datastream.schemas.mp_fields.TRANSACTIONID_Type;
import net.datastream.schemas.mp_functions.mp1243_001.MP1243_AddNonPOReceipt_001;
import net.datastream.schemas.mp_functions.mp1244_001.MP1244_SyncNonPOReceipt_001;
import net.datastream.schemas.mp_functions.mp1245_001.MP1245_DeleteNonPOReceipt_001;
import net.datastream.schemas.mp_functions.mp1247_001.MP1247_GetNonPOReceipt_001;
import net.datastream.schemas.mp_results.mp1243_001.MP1243_AddNonPOReceipt_001_Result;
import net.datastream.schemas.mp_results.mp1244_001.MP1244_SyncNonPOReceipt_001_Result;
import net.datastream.schemas.mp_results.mp1245_001.MP1245_DeleteNonPOReceipt_001_Result;
import net.datastream.schemas.mp_results.mp1247_001.MP1247_GetNonPOReceipt_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class NonPoReceiptServiceImpl
implements NonPoReceiptService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private NonPoReceiptPartService nonPoReceiptPartService;

    public NonPoReceiptServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.nonPoReceiptPartService = new NonPoReceiptPartServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public String createNoPoReceipt(InforContext context, NoPoReceipt receipt) throws InforException {
        NonPOReceipt transactionInfor = new NonPOReceipt();
        this.tools.getInforFieldTools().transformWSHubObject(transactionInfor, receipt, context);
        MP1243_AddNonPOReceipt_001 addtransaction = new MP1243_AddNonPOReceipt_001();
        transactionInfor.setTRANSACTIONID(this.createDefaultTransactionType(context, receipt));
        addtransaction.setNonPOReceipt(transactionInfor);
        MP1243_AddNonPOReceipt_001_Result addNonPoReceipt = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addNonPOReceiptOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addtransaction);
        String transactionCode = addNonPoReceipt.getResultData().getTRANSACTIONID().getTRANSACTIONCODE();
        if (receipt.getParts() != null && !receipt.getParts().isEmpty()) {
            receipt.getParts().stream().peek(part -> part.setTransactionCode(transactionCode)).collect(Collectors.toList());
            this.nonPoReceiptPartService.createNoPoReceiptPartBatch(context, receipt.getParts());
        }
        return transactionCode;
    }

    @Override
    public NoPoReceipt readNoPoReceipt(InforContext context, String receiptCode) throws InforException {
        NonPOReceipt transaction = this.readNonPoReceiptInfor(context, receiptCode);
        NoPoReceipt result = this.tools.getInforFieldTools().transformInforObject(new NoPoReceipt(), transaction, context);
        List<NoPoReceiptPart> parts = this.nonPoReceiptPartService.getNoPoReceiptParts(context, receiptCode);
        result.setParts(parts != null ? parts : Collections.emptyList());
        return result;
    }

    @Override
    public String updateNoPoReceipt(InforContext context, NoPoReceipt receipt) throws InforException {
        List<TransactionLineId> toDeleteIds;
        MP1244_SyncNonPOReceipt_001 syncTransaction = new MP1244_SyncNonPOReceipt_001();
        NonPOReceipt prev = this.readNonPoReceiptInfor(context, receipt.getCode());
        List<NoPoReceiptPart> oldParts = this.nonPoReceiptPartService.getNoPoReceiptParts(context, receipt.getCode());
        this.tools.getInforFieldTools().transformWSHubObject(prev, receipt, context);
        syncTransaction.setNonPOReceipt(prev);
        MP1244_SyncNonPOReceipt_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncNonPOReceiptOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncTransaction);
        ArrayList<NoPoReceiptPart> toCreate = new ArrayList<NoPoReceiptPart>();
        ArrayList<NoPoReceiptPart> toUpdate = new ArrayList<NoPoReceiptPart>();
        if (receipt.getParts() != null && !receipt.getParts().isEmpty()) {
            for (NoPoReceiptPart newPart : receipt.getParts()) {
                if (newPart.getTransactionLineId() == null) {
                    toCreate.add(newPart);
                    continue;
                }
                toUpdate.add(newPart);
            }
        }
        if (!(toDeleteIds = oldParts.stream().filter(oldPart -> receipt.getParts().stream().noneMatch(newPart -> Objects.equals(newPart.getTransactionLineId(), oldPart.getTransactionLineId()))).map(oldPart -> new TransactionLineId(oldPart.getTransactionCode(), oldPart.getTransactionLineId())).collect(Collectors.toList())).isEmpty()) {
            this.nonPoReceiptPartService.deleteNoPoReceiptPartBatch(context, toDeleteIds);
        }
        if (!toUpdate.isEmpty()) {
            this.nonPoReceiptPartService.updateNoPoReceiptPartBatch(context, toUpdate);
        }
        if (!toCreate.isEmpty()) {
            this.nonPoReceiptPartService.createNoPoReceiptPartBatch(context, toCreate);
        }
        this.nonPoReceiptPartService.updateNoPoReceiptPartBatch(context, receipt.getParts());
        return result.getResultData().getTRANSACTIONID().getTRANSACTIONCODE();
    }

    @Override
    public String deleteNoPoReceipt(InforContext context, String receiptCode) throws InforException {
        MP1245_DeleteNonPOReceipt_001 deleteTransaction = new MP1245_DeleteNonPOReceipt_001();
        TRANSACTIONID_Type transactionIdType = new TRANSACTIONID_Type();
        transactionIdType.setTRANSACTIONCODE(receiptCode);
        transactionIdType.setORGANIZATIONID(this.tools.getOrganization(context));
        deleteTransaction.setTRANSACTIONID(transactionIdType);
        NoPoReceipt prev = this.readNoPoReceipt(context, receiptCode);
        ArrayList<TransactionLineId> ids = new ArrayList<TransactionLineId>();
        if (prev.getParts() != null) {
            for (NoPoReceiptPart part : prev.getParts()) {
                ids.add(new TransactionLineId(part.getTransactionCode(), part.getTransactionLineId()));
            }
            if (!ids.isEmpty()) {
                this.nonPoReceiptPartService.deleteNoPoReceiptPartBatch(context, ids);
            }
        }
        this.nonPoReceiptPartService.deleteNoPoReceiptPartBatch(context, ids);
        MP1245_DeleteNonPOReceipt_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteNonPOReceiptOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteTransaction);
        return result.getResultData().getTRANSACTIONID().getTRANSACTIONCODE();
    }

    private NonPOReceipt readNonPoReceiptInfor(InforContext context, String transactionCode) throws InforException {
        MP1247_GetNonPOReceipt_001 getTransaction = new MP1247_GetNonPOReceipt_001();
        TRANSACTIONID_Type transactionIdType = new TRANSACTIONID_Type();
        transactionIdType.setTRANSACTIONCODE(transactionCode);
        transactionIdType.setORGANIZATIONID(this.tools.getOrganization(context));
        getTransaction.setTRANSACTIONID(transactionIdType);
        MP1247_GetNonPOReceipt_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getNonPOReceiptOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getTransaction);
        return result.getResultData().getNonPOReceipt();
    }

    private TRANSACTIONID_Type createDefaultTransactionType(InforContext context, NoPoReceipt receipt) throws InforException {
        TRANSACTIONID_Type idType = new TRANSACTIONID_Type();
        idType.setTRANSACTIONCODE("@[EMPTY]#*");
        idType.setDESCRIPTION(receipt.getDescription());
        idType.setORGANIZATIONID(this.tools.getOrganization(context));
        return idType;
    }
}

