/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.entities;

import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.annotations.EAMField;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.Department;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Entity
@Table(name="R5USERS")
@NamedQueries(value={@NamedQuery(name="ALL_ACTIVE_USERS", query="Select user from EAMUser user WHERE user.classCode IS NULL OR user.classCode <> '*INA'"), @NamedQuery(name="ALL_GROUP_MEMBER_USERNAMES", query="Select userCode from EAMUser user WHERE user.userGroup = :group")})
public class EAMUser
implements Serializable {
    private static final long serialVersionUID = 1149632956701915140L;
    public static final String ALL_ACTIVE_USERS = "ALL_ACTIVE_USERS";
    public static final String ALL_GROUP_MEMBER_USERNAMES = "ALL_GROUP_MEMBER_USERNAMES";
    @Id
    @Column(name="USR_CODE")
    @EAMField(xpath={"USERID/USERCODE"})
    private String userCode;
    @Column(name="USR_DESC")
    @EAMField(xpath={"USERID/DESCRIPTION"})
    private String userDesc;
    @Column(name="USR_GROUP")
    @EAMField(xpath={"USERGROUP"})
    private String userGroup;
    @Column(name="USR_EXPUSER")
    @Temporal(value=TemporalType.DATE)
    @EAMField(xpath={"USEREXPIREDATE"})
    private Date userIDExpirationDate;
    @XmlTransient
    @Transient
    @EAMField(xpath={"PASSWORD"})
    private String password;
    @Transient
    @EAMField(xpath={"PASSEXPIREDATE"})
    private Date passwordExpirationDate;
    @Column(name="USR_EMAILADDRESS")
    @EAMField(xpath={"EMAIL"})
    private String emailAddress;
    @Column(name="USR_MRC")
    @EAMField(xpath={"DEPARTMENTCODE"})
    private String department;
    @Column(name="USR_CLASS")
    @EAMField(xpath={"CLASSID/CLASSCODE"})
    private String classCode;
    @Column(name="USR_LOCALE")
    @EAMField(xpath={"LOCALE"})
    private String locale;
    @Transient
    private String employeeCode;
    @Transient
    private String employeeDesc;
    @Transient
    @EAMField(xpath={"USERDEFINEDAREA"})
    private CustomField[] customFields;
    @Transient
    @EAMField(xpath={"StandardUserDefinedFields"})
    private UserDefinedFields userDefinedFields;
    @Transient
    private Map<String, Department> departmentalSecurity;

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUserDesc() {
        return this.userDesc;
    }

    public void setUserDesc(String userDesc) {
        this.userDesc = userDesc;
    }

    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @XmlElementWrapper(name="customFields")
    @XmlElement(name="customField")
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = classCode;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getUserIDExpirationDate() {
        return this.userIDExpirationDate;
    }

    public void setUserIDExpirationDate(Date userIDExpirationDate) {
        this.userIDExpirationDate = userIDExpirationDate;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    public void setPasswordExpirationDate(Date passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    public List<String> getUserDepartments() {
        LinkedList<String> userDepartments = new LinkedList<String>();
        if (this.getDepartment() != null) {
            userDepartments.add(this.getDepartment());
        }
        if (this.getUserDefinedFields() != null && this.getUserDefinedFields().getUdfchar10() != null) {
            String[] udfDepartments = this.getUserDefinedFields().getUdfchar10().replaceAll("\\s+", "").trim().split(",");
            userDepartments.addAll(Arrays.asList(udfDepartments));
        }
        Collections.sort(userDepartments);
        return userDepartments;
    }

    public UserDefinedFields getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public void setUserDefinedFields(UserDefinedFields userDefinedFields) {
        this.userDefinedFields = userDefinedFields;
    }

    public String getEmployeeCode() {
        return this.employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getEmployeeDesc() {
        return this.employeeDesc;
    }

    public void setEmployeeDesc(String employeeDesc) {
        this.employeeDesc = employeeDesc;
    }

    public Map<String, Department> getDepartmentalSecurity() {
        return this.departmentalSecurity;
    }

    public void setDepartmentalSecurity(Map<String, Department> departmentalSecurity) {
        this.departmentalSecurity = departmentalSecurity;
    }

    public String toString() {
        return "EAMUser [" + (String)(this.userCode != null ? "userCode=" + this.userCode + ", " : "") + (String)(this.userDesc != null ? "userDesc=" + this.userDesc + ", " : "") + (String)(this.userGroup != null ? "userGroup=" + this.userGroup + ", " : "") + (String)(this.userIDExpirationDate != null ? "userIDExpirationDate=" + String.valueOf(this.userIDExpirationDate) + ", " : "") + (String)(this.password != null ? "password=" + this.password + ", " : "") + (String)(this.passwordExpirationDate != null ? "passwordExpirationDate=" + String.valueOf(this.passwordExpirationDate) + ", " : "") + (String)(this.emailAddress != null ? "emailAddress=" + this.emailAddress + ", " : "") + (String)(this.department != null ? "department=" + this.department + ", " : "") + (String)(this.classCode != null ? "classCode=" + this.classCode + ", " : "") + (String)(this.customFields != null ? "customFields=" + Arrays.toString(this.customFields) + ", " : "") + (String)(this.userDefinedFields != null ? "userDefinedFields=" + String.valueOf(this.userDefinedFields) : "") + "]";
    }
}

