/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.material.PartMiscService;
import ch.cern.eam.wshub.core.services.material.entities.Bin;
import ch.cern.eam.wshub.core.services.material.entities.Bin2BinTransfer;
import ch.cern.eam.wshub.core.services.material.entities.IssueReturnPartTransaction;
import ch.cern.eam.wshub.core.services.material.entities.IssueReturnPartTransactionLine;
import ch.cern.eam.wshub.core.services.material.entities.IssueReturnPartTransactionType;
import ch.cern.eam.wshub.core.services.material.entities.PartAssociation;
import ch.cern.eam.wshub.core.services.material.entities.PartManufacturer;
import ch.cern.eam.wshub.core.services.material.entities.PartSubstitute;
import ch.cern.eam.wshub.core.services.material.entities.PartSupplier;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder;
import ch.cern.eam.wshub.core.services.workorders.impl.WorkOrderServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import jakarta.persistence.EntityManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.datastream.schemas.mp_entities.binstock_001.BinStock;
import net.datastream.schemas.mp_entities.catalogue_001.Catalogue;
import net.datastream.schemas.mp_entities.issuereturntransaction_001.IssueReturnTransaction;
import net.datastream.schemas.mp_entities.issuereturntransactionline_001.IssueReturnTransactionLine;
import net.datastream.schemas.mp_entities.issuereturntransactionline_001.IssueReturnTransactionLines;
import net.datastream.schemas.mp_entities.partsassociated_001.PartsAssociated;
import net.datastream.schemas.mp_entities.storebin_001.StoreBin;
import net.datastream.schemas.mp_entities.substitutepart_001.SubstitutePart;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.BUDGET_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.MULTIEQUIPSPLITINFOBATCH;
import net.datastream.schemas.mp_fields.PARTASSOCIATEDID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.PICKLIST_Type;
import net.datastream.schemas.mp_fields.PROJECTBUDGETID_Type;
import net.datastream.schemas.mp_fields.PROJECTID_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.SUBSTITUTEPART_Type;
import net.datastream.schemas.mp_fields.SUPPLIERID_Type;
import net.datastream.schemas.mp_fields.TRANSACTIONID_Type;
import net.datastream.schemas.mp_fields.TRANSACTIONLINEID;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0220_001.MP0220_AddIssueReturnTransaction_001;
import net.datastream.schemas.mp_functions.mp0271_001.MP0271_AddCatalogue_001;
import net.datastream.schemas.mp_functions.mp0281_001.MP0281_AddStoreBin_001;
import net.datastream.schemas.mp_functions.mp0282_001.MP0282_GetStoreBin_001;
import net.datastream.schemas.mp_functions.mp0283_001.MP0283_SyncStoreBin_001;
import net.datastream.schemas.mp_functions.mp0284_001.MP0284_DeleteStoreBin_001;
import net.datastream.schemas.mp_functions.mp0286_001.MP0286_Bin2BinTransfer_001;
import net.datastream.schemas.mp_functions.mp0612_001.MP0612_AddPartsAssociated_001;
import net.datastream.schemas.mp_functions.mp0614_001.MP0614_DeletePartsAssociated_001;
import net.datastream.schemas.mp_functions.mp2051_001.MP2051_AddSubstitutePart_001;
import net.datastream.schemas.mp_results.mp0220_001.MP0220_AddIssueReturnTransaction_001_Result;
import net.datastream.schemas.mp_results.mp0282_001.MP0282_GetStoreBin_001_Result;
import net.datastream.schemas.mp_results.mp0283_001.MP0283_SyncStoreBin_001_Result;
import net.datastream.schemas.mp_results.mp0284_001.MP0284_DeleteStoreBin_001_Result;
import net.datastream.schemas.mp_results.mp0612_001.MP0612_AddPartsAssociated_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class PartMiscServiceImpl
implements PartMiscService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private WorkOrderService workOrderService;

    public PartMiscServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.workOrderService = new WorkOrderServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public String addPartSupplier(EAMContext context, PartSupplier partSupplierParam) throws EAMException {
        Catalogue catalogue = new Catalogue();
        if (partSupplierParam.getPartCode() != null) {
            catalogue.setPARTID(new PARTID_Type());
            catalogue.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            catalogue.getPARTID().setPARTCODE(partSupplierParam.getPartCode());
        }
        if (partSupplierParam.getSupplierPartDescription() != null) {
            catalogue.setSUPPLIERPARTDESCRIPTION(partSupplierParam.getSupplierPartDescription());
        }
        if (partSupplierParam.getCatalogReference() != null) {
            // empty if block
        }
        if (partSupplierParam.getGrossPrice() != null) {
            this.tools.getDataTypeTools();
            catalogue.setGROSSPRICE(DataTypeTools.encodeAmount(partSupplierParam.getGrossPrice(), "Gross Price"));
        }
        if (partSupplierParam.getMinimumOrderQty() != null) {
            this.tools.getDataTypeTools();
            catalogue.setMINIMUMQTY(DataTypeTools.encodeAmount(partSupplierParam.getMinimumOrderQty(), "Minimum Order Qty."));
        }
        if (partSupplierParam.getSupplierCode() != null) {
            catalogue.setSUPPLIERID(new SUPPLIERID_Type());
            catalogue.getSUPPLIERID().setORGANIZATIONID(this.tools.getOrganization(context));
            catalogue.getSUPPLIERID().setSUPPLIERCODE(partSupplierParam.getSupplierCode());
        }
        MP0271_AddCatalogue_001 addCatalogue = new MP0271_AddCatalogue_001();
        addCatalogue.setCatalogue(catalogue);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addCatalogueOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addCatalogue);
        return null;
    }

    @Override
    public List<String> createIssueReturnTransaction(EAMContext context, List<IssueReturnPartTransaction> issueReturnPartTransactionList) throws EAMException {
        ArrayList<String> results = new ArrayList<String>();
        for (IssueReturnPartTransaction tr : issueReturnPartTransactionList) {
            results.add(this.createIssueReturnTransaction(context, tr));
        }
        return results;
    }

    @Override
    public String createIssueReturnTransaction(EAMContext context, IssueReturnPartTransaction issueReturnPartTransaction) throws EAMException {
        IssueReturnTransaction issueReturnTransactionEAM = new IssueReturnTransaction();
        if (issueReturnPartTransaction.getTransactionType() != null) {
            if (issueReturnPartTransaction.getTransactionType().toUpperCase().startsWith("I")) {
                issueReturnTransactionEAM.setISSUERETURNTYPE("ISSUE");
            } else {
                issueReturnTransactionEAM.setISSUERETURNTYPE("RETURN");
            }
        }
        switch (issueReturnPartTransaction.getTransactionOn()) {
            case WORKORDER: {
                if (issueReturnPartTransaction.getWorkOrderNumber() == null || issueReturnPartTransaction.getActivityCode() == null) break;
                issueReturnTransactionEAM.setACTIVITYID(new ACTIVITYID());
                issueReturnTransactionEAM.getACTIVITYID().setWORKORDERID(new WOID_Type());
                issueReturnTransactionEAM.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionEAM.getACTIVITYID().getWORKORDERID().setJOBNUM(issueReturnPartTransaction.getWorkOrderNumber());
                issueReturnTransactionEAM.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
                issueReturnTransactionEAM.getACTIVITYID().getACTIVITYCODE().setValue(this.tools.getDataTypeTools().encodeLong(issueReturnPartTransaction.getActivityCode(), "Activity Code"));
                break;
            }
            case PROJECT: {
                if (issueReturnPartTransaction.getProjectCode() == null || issueReturnPartTransaction.getBudgetCode() == null) break;
                issueReturnTransactionEAM.setPROJECTBUDGET(new PROJECTBUDGETID_Type());
                issueReturnTransactionEAM.getPROJECTBUDGET().setPROJECTID(new PROJECTID_Type());
                issueReturnTransactionEAM.getPROJECTBUDGET().getPROJECTID().setPROJECTCODE(issueReturnPartTransaction.getProjectCode());
                issueReturnTransactionEAM.getPROJECTBUDGET().getPROJECTID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionEAM.getPROJECTBUDGET().getPROJECTID().setDESCRIPTION(issueReturnPartTransaction.getProjectDesc());
                issueReturnTransactionEAM.getPROJECTBUDGET().setBUDGETID(new BUDGET_Type());
                issueReturnTransactionEAM.getPROJECTBUDGET().getBUDGETID().setBUDGETCODE(issueReturnPartTransaction.getBudgetCode());
                issueReturnTransactionEAM.getPROJECTBUDGET().getBUDGETID().setDESCRIPTION(issueReturnPartTransaction.getBudgetDesc());
                break;
            }
            case EQUIPMENT: {
                if (issueReturnPartTransaction.getEquipmentCode() == null || issueReturnPartTransaction.getEquipmentCode().trim().equals("")) break;
                issueReturnTransactionEAM.setEQUIPMENTID(new EQUIPMENTID_Type());
                issueReturnTransactionEAM.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionEAM.getEQUIPMENTID().setEQUIPMENTCODE(issueReturnPartTransaction.getEquipmentCode().toUpperCase());
                break;
            }
            case EMPLOYEE: {
                if (issueReturnPartTransaction.getEmployeeCode() == null || issueReturnPartTransaction.getEmployeeCode().trim().equals("")) break;
                issueReturnTransactionEAM.setISSUETO(new PERSONID_Type());
                issueReturnTransactionEAM.getISSUETO().setPERSONCODE(issueReturnPartTransaction.getEmployeeCode().toUpperCase());
                issueReturnTransactionEAM.getISSUETO().setDESCRIPTION(issueReturnPartTransaction.getEmployeeDesc());
                break;
            }
        }
        if (issueReturnPartTransaction.getPickTicketCode() != null && !issueReturnPartTransaction.getPickTicketCode().trim().equals("")) {
            issueReturnTransactionEAM.setPICKLISTID(new PICKLIST_Type());
            issueReturnTransactionEAM.getPICKLISTID().setPICKLIST(issueReturnPartTransaction.getPickTicketCode());
        }
        if (issueReturnPartTransaction.getDepartmentCode() != null) {
            issueReturnTransactionEAM.setDEPARTMENTID(new DEPARTMENTID_Type());
            issueReturnTransactionEAM.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            issueReturnTransactionEAM.getDEPARTMENTID().setDEPARTMENTCODE(issueReturnPartTransaction.getDepartmentCode().toUpperCase());
        }
        if (issueReturnPartTransaction.getStoreCode() != null) {
            issueReturnTransactionEAM.setSTOREID(new STOREID_Type());
            issueReturnTransactionEAM.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            issueReturnTransactionEAM.getSTOREID().setSTORECODE(issueReturnPartTransaction.getStoreCode().toUpperCase());
        }
        issueReturnTransactionEAM.setTRANSACTIONID(new TRANSACTIONID_Type());
        issueReturnTransactionEAM.getTRANSACTIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        issueReturnTransactionEAM.getTRANSACTIONID().setTRANSACTIONCODE("0");
        issueReturnTransactionEAM.setIssueReturnTransactionLines(new IssueReturnTransactionLines());
        for (IssueReturnPartTransactionLine line : issueReturnPartTransaction.getTransactionlines()) {
            IssueReturnTransactionLine issueReturnTransactionLine = this.tools.getEAMFieldTools().transformWSHubObject(new IssueReturnTransactionLine(), line, context);
            if (issueReturnTransactionLine.getLOT() == null) {
                issueReturnTransactionLine.setLOT("*");
            }
            issueReturnTransactionLine.setTRANSACTIONLINEID(new TRANSACTIONLINEID());
            issueReturnTransactionLine.getTRANSACTIONLINEID().setTRANSACTIONID(new TRANSACTIONID_Type());
            issueReturnTransactionLine.getTRANSACTIONLINEID().getTRANSACTIONID().setTRANSACTIONCODE("0");
            issueReturnTransactionEAM.getIssueReturnTransactionLines().getIssueReturnTransactionLine().add(issueReturnTransactionLine);
            if (!DataTypeTools.isNotEmpty(line.getAssetIDCode()) || !"ISSUE".equalsIgnoreCase(issueReturnPartTransaction.getTransactionType()) || !IssueReturnPartTransactionType.WORKORDER.equals((Object)issueReturnPartTransaction.getTransactionOn())) continue;
            issueReturnTransactionLine.setATTACHEQUIPMENT("true");
            issueReturnTransactionLine.setATTACHTOEQUIPMENT(new EQUIPMENTID_Type());
            WorkOrder workOrder = this.workOrderService.readWorkOrder(context, issueReturnPartTransaction.getWorkOrderNumber());
            issueReturnTransactionLine.getATTACHTOEQUIPMENT().setEQUIPMENTCODE(workOrder.getEquipmentCode());
            issueReturnTransactionLine.getATTACHTOEQUIPMENT().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (issueReturnPartTransaction.getRelatedWorkOrder() != null) {
            issueReturnTransactionEAM.setMULTIEQUIPSPLITINFOBATCH(new MULTIEQUIPSPLITINFOBATCH());
            WOID_Type woid_type = new WOID_Type();
            woid_type.setJOBNUM(issueReturnPartTransaction.getRelatedWorkOrder());
            issueReturnTransactionEAM.getMULTIEQUIPSPLITINFOBATCH().setRELATEDWORKORDERID(woid_type);
        }
        MP0220_AddIssueReturnTransaction_001 addIssueReturnTransaction = new MP0220_AddIssueReturnTransaction_001();
        addIssueReturnTransaction.setIssueReturnTransaction(issueReturnTransactionEAM);
        MP0220_AddIssueReturnTransaction_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addIssueReturnTransactionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addIssueReturnTransaction);
        String transactId = result.getResultData().getIssueReturnTransaction().getTRANSACTIONID().getTRANSACTIONCODE();
        return transactId;
    }

    @Override
    public String createPartAssociation(EAMContext context, PartAssociation partAssociation) throws EAMException {
        MP0612_AddPartsAssociated_001 addpass = new MP0612_AddPartsAssociated_001();
        addpass.setPartsAssociated(new PartsAssociated());
        if (partAssociation.getPartCode() != null) {
            addpass.getPartsAssociated().setPARTID(new PARTID_Type());
            addpass.getPartsAssociated().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            addpass.getPartsAssociated().getPARTID().setPARTCODE(partAssociation.getPartCode().toUpperCase());
        }
        if (partAssociation.getQuantity() != null) {
            PartsAssociated partsAssociated = addpass.getPartsAssociated();
            this.tools.getDataTypeTools();
            partsAssociated.setPARTQUANTITY(DataTypeTools.encodeQuantity(partAssociation.getQuantity(), "Part Quantity"));
        }
        if (partAssociation.getUOM() != null) {
            addpass.getPartsAssociated().setUOMCODE(partAssociation.getUOM());
        }
        if (partAssociation.getAssociationEntity() != null) {
            addpass.getPartsAssociated().setENTITY(partAssociation.getAssociationEntity().toUpperCase());
        } else {
            addpass.getPartsAssociated().setENTITY("OBJ");
        }
        if (partAssociation.getEquipmentCode() != null) {
            addpass.getPartsAssociated().setPARTASSOCIATEDCODE(partAssociation.getEquipmentCode() + "#*");
        }
        addpass.getPartsAssociated().setPARTASSOCIATEDID(new PARTASSOCIATEDID_Type());
        addpass.getPartsAssociated().getPARTASSOCIATEDID().setPARTASSOCIATEDPK("0");
        addpass.getPartsAssociated().setPARTASSOCIATEDTYPE("*");
        MP0612_AddPartsAssociated_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addPartsAssociatedOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addpass);
        return result.getResultData().getPartsAssociated().getPARTASSOCIATEDID().getPARTASSOCIATEDPK();
    }

    @Override
    public String deletePartAssociation(EAMContext context, PartAssociation partAssociation) throws EAMException {
        MP0614_DeletePartsAssociated_001 deletepass = new MP0614_DeletePartsAssociated_001();
        deletepass.setPARTASSOCIATEDID(new PARTASSOCIATEDID_Type());
        deletepass.getPARTASSOCIATEDID().setParentcode(partAssociation.getEquipmentCode() + "#*");
        try (EntityManager em = this.tools.getEntityManager();){
            deletepass.getPARTASSOCIATEDID().setPARTASSOCIATEDPK(((PartAssociation)em.createNamedQuery("GET_PART_ASSOCIATION", PartAssociation.class).setParameter("partCode", (Object)partAssociation.getPartCode()).setParameter("equipmentCode", (Object)(partAssociation.getEquipmentCode() + "#*")).getSingleResult()).getPk());
        }
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deletePartsAssociatedOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deletepass);
        return "OK";
    }

    @Override
    public String createPartSubstitute(EAMContext context, PartSubstitute partSubstitute) throws EAMException {
        MP2051_AddSubstitutePart_001 addPartSub = new MP2051_AddSubstitutePart_001();
        addPartSub.setSubstitutePart(new SubstitutePart());
        addPartSub.getSubstitutePart().setSUBSTITUTEPARTID(new SUBSTITUTEPART_Type());
        if (partSubstitute.getPartA() != null) {
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().setPARTAID(new PARTID_Type());
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTAID().setORGANIZATIONID(this.tools.getOrganization(context));
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTAID().setPARTCODE(partSubstitute.getPartA().toUpperCase().trim());
        }
        if (partSubstitute.getPartB() != null) {
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().setPARTBID(new PARTID_Type());
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTBID().setORGANIZATIONID(this.tools.getOrganization(context));
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTBID().setPARTCODE(partSubstitute.getPartB().toUpperCase().trim());
        }
        if (partSubstitute.getCondition() != null) {
            addPartSub.getSubstitutePart().setPARTCONDITIONTEMPLATECONDITIONCODE(partSubstitute.getCondition());
        }
        if (partSubstitute.getFullyCompatible() != null) {
            addPartSub.getSubstitutePart().setFULLYCOMPATIBLE(partSubstitute.getFullyCompatible());
        }
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addSubstitutePartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPartSub);
        return "OK";
    }

    @Override
    public String addStoreBin(EAMContext context, Bin binParam) throws EAMException {
        StoreBin storeBin = this.tools.getEAMFieldTools().transformWSHubObject(new StoreBin(), binParam, context);
        MP0281_AddStoreBin_001 addStoreBin = new MP0281_AddStoreBin_001();
        addStoreBin.setStoreBin(storeBin);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addStoreBinOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addStoreBin);
        return null;
    }

    @Override
    public Bin readStoreBin(EAMContext context, Bin binParam) throws EAMException {
        StoreBin storeBin = this.tools.getEAMFieldTools().transformWSHubObject(new StoreBin(), binParam, context);
        MP0282_GetStoreBin_001 getStoreBin = new MP0282_GetStoreBin_001();
        getStoreBin.setSTOREBINID(storeBin.getSTOREBINID());
        MP0282_GetStoreBin_001_Result mp0282_getStoreBin_001_result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getStoreBinOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getStoreBin);
        StoreBin result = mp0282_getStoreBin_001_result.getResultData().getStoreBin();
        return this.tools.getEAMFieldTools().transformEAMObject(new Bin(), result, context);
    }

    @Override
    public String updateStoreBin(EAMContext context, Bin binParam) throws EAMException {
        StoreBin storeBin = this.tools.getEAMFieldTools().transformWSHubObject(new StoreBin(), binParam, context);
        MP0282_GetStoreBin_001 getStoreBin = new MP0282_GetStoreBin_001();
        getStoreBin.setSTOREBINID(storeBin.getSTOREBINID());
        MP0282_GetStoreBin_001_Result mp0282_getStoreBin_001_result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getStoreBinOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getStoreBin);
        StoreBin result = mp0282_getStoreBin_001_result.getResultData().getStoreBin();
        StoreBin storeBin2 = this.tools.getEAMFieldTools().transformWSHubObject(result, binParam, context);
        MP0283_SyncStoreBin_001 syncStoreBin = new MP0283_SyncStoreBin_001();
        syncStoreBin.setStoreBin(storeBin2);
        MP0283_SyncStoreBin_001_Result syncResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncStoreBinOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncStoreBin);
        return null;
    }

    @Override
    public String deleteStoreBin(EAMContext context, Bin binParam) throws EAMException {
        StoreBin storeBin = this.tools.getEAMFieldTools().transformWSHubObject(new StoreBin(), binParam, context);
        MP0284_DeleteStoreBin_001 deleteBinOp = new MP0284_DeleteStoreBin_001();
        deleteBinOp.setSTOREBINID(storeBin.getSTOREBINID());
        MP0284_DeleteStoreBin_001_Result deleteStoreBin_001_Result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteStoreBinOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteBinOp);
        return null;
    }

    @Override
    public PartManufacturer[] getPartManufacturers(EAMContext context, String partCode) throws EAMException {
        LinkedList<PartManufacturer> partManufacturers = new LinkedList<PartManufacturer>();
        String sqlQuery = "select r5partmfgs.mfp_part, r5partmfgs.mfp_manufacturer, r5manufacturers.mfg_desc, r5partmfgs.mfp_manufactpart, r5partmfgs.mfp_manufactdraw, r5partmfgs.mfp_primary, r5partmfgs.mfp_notused from r5partmfgs,r5manufacturers where mfp_manufacturer = mfg_code and mfp_part= '" + partCode + "'";
        Connection v_connection = null;
        Statement stmt = null;
        ResultSet v_result = null;
        try {
            v_connection = this.tools.getDataSource().getConnection();
            stmt = v_connection.createStatement();
            v_result = stmt.executeQuery(sqlQuery);
            while (v_result.next()) {
                PartManufacturer partManufacturer = new PartManufacturer();
                partManufacturer.setPartCode(v_result.getString("mfp_part"));
                partManufacturer.setManufacturerCode(v_result.getString("mfp_manufacturer"));
                partManufacturer.setManufacturerDesc(v_result.getString("mfg_desc"));
                partManufacturer.setManufacturerPartNumber(v_result.getString("mfp_manufactpart"));
                partManufacturer.setDrawingNumber(v_result.getString("mfp_manufactdraw"));
                partManufacturer.setPrimary(DataTypeTools.decodeBoolean(v_result.getString("mfp_primary")));
                partManufacturer.setOutOfService(DataTypeTools.decodeBoolean(v_result.getString("mfp_notused")));
                partManufacturers.addLast(partManufacturer);
            }
        }
        catch (Exception e) {
            throw Tools.generateFault("Couldn't read the manufacturers: " + e.getMessage());
        }
        finally {
            try {
                if (v_result != null) {
                    v_result.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (v_connection != null) {
                    v_connection.close();
                }
            }
            catch (Exception e) {
                throw Tools.generateFault("Couldn't read the manufacturers");
            }
        }
        return partManufacturers.toArray(new PartManufacturer[0]);
    }

    @Override
    public String createBin2binTransfer(EAMContext context, Bin2BinTransfer bin2BinTransfer) throws EAMException {
        net.datastream.schemas.mp_entities.bin2bintransfer_001.Bin2BinTransfer bin2BinTransferEAM = new net.datastream.schemas.mp_entities.bin2bintransfer_001.Bin2BinTransfer();
        BinStock binStockEAM = new BinStock();
        bin2BinTransferEAM.setBinStock(binStockEAM);
        bin2BinTransferEAM.setBIN(bin2BinTransfer.getDestinationBin());
        binStockEAM.setSTOREID(new STOREID_Type());
        binStockEAM.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        binStockEAM.getSTOREID().setSTORECODE(bin2BinTransfer.getStoreCode());
        IssueReturnPartTransactionLine transactionLine = bin2BinTransfer.getTransactionLine();
        if (transactionLine != null) {
            binStockEAM.setPARTID(new PARTID_Type());
            binStockEAM.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            binStockEAM.getPARTID().setPARTCODE(this.treatCodeSafe(transactionLine.getPartCode()));
            bin2BinTransferEAM.setSTOCKQTY(DataTypeTools.encodeQuantity(transactionLine.getTransactionQty(), "Stock Quantity"));
            binStockEAM.setBIN(transactionLine.getBin());
            binStockEAM.setLOT(transactionLine.getLot());
            if (DataTypeTools.isNotEmpty(transactionLine.getAssetIDCode())) {
                bin2BinTransferEAM.setASSETID(new EQUIPMENTID_Type());
                bin2BinTransferEAM.getASSETID().setEQUIPMENTCODE(transactionLine.getAssetIDCode());
                bin2BinTransferEAM.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
            }
            IssueReturnTransactionLine lineEAM = this.tools.getEAMFieldTools().transformWSHubObject(new IssueReturnTransactionLine(), transactionLine, context);
            bin2BinTransferEAM.getBinStock().setStandardUserDefinedFields(lineEAM.getStandardUserDefinedFields());
        }
        MP0286_Bin2BinTransfer_001 opBean = new MP0286_Bin2BinTransfer_001();
        opBean.setBin2BinTransfer(bin2BinTransferEAM);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).bin2BinTransferOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), opBean);
        return null;
    }

    @Override
    public BatchResponse<String> createBin2binTransferBatch(EAMContext context, List<Bin2BinTransfer> bin2BinTransferList) {
        return this.tools.batchOperation(context, this::createBin2binTransfer, bin2BinTransferList);
    }

    private String treatCodeSafe(String code) {
        if (code == null) {
            return null;
        }
        return code.trim().toUpperCase();
    }
}

