/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.material.PartService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.datastream.schemas.mp_entities.part_001.Part;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_functions.mp0240_001.MP0240_AddPart_001;
import net.datastream.schemas.mp_functions.mp0241_001.MP0241_GetPart_001;
import net.datastream.schemas.mp_functions.mp0242_001.MP0242_SyncPart_001;
import net.datastream.schemas.mp_functions.mp0243_001.MP0243_DeletePart_001;
import net.datastream.schemas.mp_functions.mp0244_001.MP0244_GetPartDefault_001;
import net.datastream.schemas.mp_functions.mp2072_001.ChangePartNumber;
import net.datastream.schemas.mp_functions.mp2072_001.MP2072_ChangePartNumber_001;
import net.datastream.schemas.mp_results.mp0240_001.MP0240_AddPart_001_Result;
import net.datastream.schemas.mp_results.mp0241_001.MP0241_GetPart_001_Result;
import net.datastream.schemas.mp_results.mp0242_001.MP0242_SyncPart_001_Result;
import net.datastream.schemas.mp_results.mp0244_001.MP0244_GetPartDefault_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class PartServiceImpl
implements PartService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private UserDefinedListService userDefinedListService;

    public PartServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.userDefinedListService = new UserDefinedListServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createPartBatch(EAMContext context, List<ch.cern.eam.wshub.core.services.material.entities.Part> parts) {
        return this.tools.batchOperation(context, this::createPart, parts);
    }

    @Override
    public BatchResponse<ch.cern.eam.wshub.core.services.material.entities.Part> readPartBatch(EAMContext context, List<String> partCodes) {
        return this.tools.batchOperation(context, this::readPart, partCodes);
    }

    @Override
    public BatchResponse<String> updatePartBatch(EAMContext context, List<ch.cern.eam.wshub.core.services.material.entities.Part> parts) {
        return this.tools.batchOperation(context, this::updatePart, parts);
    }

    @Override
    public BatchResponse<String> deletePartBatch(EAMContext context, List<String> partCodes) {
        return this.tools.batchOperation(context, this::deletePart, partCodes);
    }

    @Override
    public ch.cern.eam.wshub.core.services.material.entities.Part readPartDefault(EAMContext context, String organization) throws EAMException {
        MP0244_GetPartDefault_001 getPartDefault_001 = new MP0244_GetPartDefault_001();
        if (DataTypeTools.isEmpty(organization)) {
            getPartDefault_001.setORGANIZATIONID(this.tools.getOrganization(context));
        } else {
            getPartDefault_001.setORGANIZATIONID(new ORGANIZATIONID_Type());
            getPartDefault_001.getORGANIZATIONID().setORGANIZATIONCODE(organization);
        }
        MP0244_GetPartDefault_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getPartDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPartDefault_001);
        ch.cern.eam.wshub.core.services.material.entities.Part part = this.tools.getEAMFieldTools().transformEAMObject(new ch.cern.eam.wshub.core.services.material.entities.Part(), result.getResultData().getPartDefault(), context);
        part.setUserDefinedList(new HashMap<String, ArrayList<UDLValue>>());
        return part;
    }

    @Override
    public ch.cern.eam.wshub.core.services.material.entities.Part readPart(EAMContext context, String partCode) throws EAMException {
        ch.cern.eam.wshub.core.services.material.entities.Part part = this.tools.getEAMFieldTools().transformEAMObject(new ch.cern.eam.wshub.core.services.material.entities.Part(), this.readPartEAM(context, Tools.extractEntityCode(partCode), Tools.extractOrganizationCode(partCode)), context);
        this.tools.processRunnables(() -> part.setClassDesc(this.tools.getFieldDescriptionsTools().readClassDesc(context, "PART", part.getClassCode())), () -> part.setCategoryDesc(this.tools.getFieldDescriptionsTools().readCategoryDesc(context, part.getCategoryCode())), () -> part.setUOMDesc(this.tools.getFieldDescriptionsTools().readUOMDesc(context, part.getUOM())), () -> part.setCommodityDesc(this.tools.getFieldDescriptionsTools().readCommodityDesc(context, part.getCommodityCode())), () -> {
            if (this.tools.isDatabaseConnectionConfigured()) {
                this.userDefinedListService.readUDLToEntity(context, part, new EntityId("PART", Tools.extractEntityCode(partCode)));
            }
        });
        return part;
    }

    private Part readPartEAM(EAMContext context, String partCode, String organization) throws EAMException {
        MP0241_GetPart_001 getPart = new MP0241_GetPart_001();
        getPart.setPARTID(new PARTID_Type());
        getPart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        getPart.getPARTID().setPARTCODE(partCode);
        MP0241_GetPart_001_Result getPartResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPart);
        return getPartResult.getResultData().getPart();
    }

    @Override
    public String createPart(EAMContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws EAMException {
        Part eamPart = new Part();
        eamPart.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(eamPart.getCLASSID()), eamPart.getUSERDEFINEDAREA(), partParam.getClassCode(), "PART"));
        this.tools.getEAMFieldTools().transformWSHubObject(eamPart, partParam, context);
        MP0240_AddPart_001 addPart = new MP0240_AddPart_001();
        addPart.setPart(eamPart);
        MP0240_AddPart_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPart);
        String partCode = result.getPARTID().getPARTCODE();
        this.userDefinedListService.writeUDLToEntityCopyFrom(context, partParam, new EntityId("PART", partCode));
        return partCode;
    }

    @Override
    public String updatePart(EAMContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws EAMException {
        if (partParam.getNewCode() != null && !partParam.getNewCode().trim().equals("")) {
            MP2072_ChangePartNumber_001 changePartNumber = new MP2072_ChangePartNumber_001();
            changePartNumber.setChangePartNumber(new ChangePartNumber());
            changePartNumber.getChangePartNumber().setOLDPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getOLDPARTID().setORGANIZATIONID(this.tools.getOrganization(context, partParam.getOrganization()));
            changePartNumber.getChangePartNumber().getOLDPARTID().setPARTCODE(partParam.getCode());
            changePartNumber.getChangePartNumber().setNEWPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getNEWPARTID().setORGANIZATIONID(this.tools.getOrganization(context, partParam.getOrganization()));
            changePartNumber.getChangePartNumber().getNEWPARTID().setPARTCODE(partParam.getNewCode());
            this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).changePartNumberOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), changePartNumber);
            partParam.setCode(partParam.getNewCode());
        }
        Part eamPart = this.readPartEAM(context, partParam.getCode(), partParam.getOrganization());
        eamPart.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(eamPart.getCLASSID()), eamPart.getUSERDEFINEDAREA(), partParam.getClassCode(), "PART"));
        this.tools.getEAMFieldTools().transformWSHubObject(eamPart, partParam, context);
        MP0242_SyncPart_001 syncPart = new MP0242_SyncPart_001();
        syncPart.setPart(eamPart);
        MP0242_SyncPart_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPart);
        String partCode = result.getResultData().getPart().getPARTID().getPARTCODE();
        this.userDefinedListService.writeUDLToEntity(context, partParam, new EntityId("PART", partCode));
        return partCode;
    }

    @Override
    public String deletePart(EAMContext context, String partCode) throws EAMException {
        MP0243_DeletePart_001 deletePart = new MP0243_DeletePart_001();
        deletePart.setPARTID(new PARTID_Type());
        deletePart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context, Tools.extractOrganizationCode(partCode)));
        deletePart.getPARTID().setPARTCODE(Tools.extractEntityCode(partCode));
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deletePartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deletePart);
        this.userDefinedListService.deleteUDLFromEntity(context, new EntityId("PART", partCode));
        return partCode;
    }
}

