/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.annotations.EAMField;
import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import ch.cern.eam.wshub.core.tools.CustomFieldsTools;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.datastream.schemas.mp_fields.USERDEFINEDAREA;
import org.openapplications.oagis_segments.AMOUNT;
import org.openapplications.oagis_segments.DATETIME;
import org.openapplications.oagis_segments.QUANTITY;

public class EAMFieldTools {
    private CustomFieldsTools customFieldsTools;
    private Tools tools;

    public EAMFieldTools(CustomFieldsTools customFieldsTools, Tools tools) {
        this.customFieldsTools = customFieldsTools;
        this.tools = tools;
    }

    public <I, W> I transformWSHubObject(I eamObject, W wshubObject, EAMContext context) throws EAMException {
        ArrayList exceptionList = new ArrayList();
        Arrays.stream(wshubObject.getClass().getDeclaredFields()).filter(wshubField -> wshubField.getAnnotation(EAMField.class) != null).filter(wshubField -> !wshubField.getAnnotation(EAMField.class).readOnly()).sorted(Comparator.comparing(field -> field.getAnnotation(EAMField.class).nullifyParentLevel())).forEach(wshubField -> {
            try {
                this.setEAMValue(wshubObject, (Field)wshubField, eamObject, context);
            }
            catch (EAMException e) {
                exceptionList.add(e);
            }
        });
        if (!exceptionList.isEmpty()) {
            String message = exceptionList.stream().map(Throwable::getMessage).reduce("", (t, acc) -> acc + "; " + t);
            throw Tools.generateFault(message);
        }
        return eamObject;
    }

    public <I, W> W transformEAMObject(W wshubObject, I eamObject, EAMContext eamContext) {
        Arrays.stream(wshubObject.getClass().getDeclaredFields()).filter(wshubField -> wshubField.getAnnotation(EAMField.class) != null).forEach(wshubField -> this.setWSHubValue(wshubObject, (Field)wshubField, eamObject, eamContext));
        return wshubObject;
    }

    private <I, W> void setEAMValue(W wshubObject, Field wshubField, I eamObject, EAMContext context) throws EAMException {
        EAMField eamField = wshubField.getAnnotation(EAMField.class);
        for (String xpath : eamField.xpath()) {
            List<String> fieldNamePath = this.convertXPathToPropertyChain(eamObject.getClass(), xpath, eamField.enforceValidXpath());
            try {
                wshubField.setAccessible(true);
                Object wshubFieldValue = wshubField.get(wshubObject);
                this.setEAMFieldByPath(eamObject, fieldNamePath, wshubFieldValue, wshubField, context);
                if (fieldNamePath.isEmpty()) continue;
                break;
            }
            catch (EAMException exception) {
                throw exception;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private <I, W> void setWSHubValue(W wshubObject, Field wshubField, I eamObject, EAMContext eamContext) {
        try {
            Object eamValue = this.getValue(eamObject, wshubField.getAnnotation(EAMField.class));
            if (eamValue == null) {
                return;
            }
            wshubField.setAccessible(true);
            if (eamValue.getClass().equals(String.class)) {
                String stringValue = (String)eamValue;
                if (wshubField.getType().equals(Boolean.class) || wshubField.getType().equals(Boolean.TYPE)) {
                    wshubField.set(wshubObject, DataTypeTools.decodeBoolean(stringValue));
                } else {
                    wshubField.set(wshubObject, stringValue);
                }
            } else if (eamValue.getClass().equals(DATETIME.class)) {
                DATETIME dateTimeValue = (DATETIME)eamValue;
                wshubField.set(wshubObject, DataTypeTools.decodeEAMDate(dateTimeValue));
            } else if (eamValue.getClass().equals(AMOUNT.class)) {
                AMOUNT amountValue = (AMOUNT)eamValue;
                wshubField.set(wshubObject, DataTypeTools.decodeAmount(amountValue));
            } else if (eamValue.getClass().equals(QUANTITY.class)) {
                QUANTITY quantityValue = (QUANTITY)eamValue;
                wshubField.set(wshubObject, DataTypeTools.decodeQuantity(quantityValue));
            } else if (eamValue.getClass().equals(USERDEFINEDAREA.class)) {
                USERDEFINEDAREA userDefinedAreaValue = (USERDEFINEDAREA)eamValue;
                wshubField.set(wshubObject, this.customFieldsTools.readEAMCustomFields(userDefinedAreaValue, eamContext));
            } else if (eamValue.getClass().equals(Long.class) || eamValue.getClass().equals(Long.TYPE)) {
                Long longValue = (Long)eamValue;
                wshubField.set(wshubObject, BigInteger.valueOf(longValue));
            } else if ("UserDefinedFields".equals(wshubField.getAnnotation(EAMField.class).xpath()[0]) || "StandardUserDefinedFields".equals(wshubField.getAnnotation(EAMField.class).xpath()[0])) {
                wshubField.set(wshubObject, this.transformEAMObject(new UserDefinedFields(), eamValue, eamContext));
            } else if (List.class.isAssignableFrom(eamValue.getClass())) {
                List eamValueAsList = (List)eamValue;
                if (wshubField.getGenericType() instanceof ParameterizedType) {
                    ParameterizedType listGenericType = (ParameterizedType)wshubField.getGenericType();
                    Class itemsType = (Class)listGenericType.getActualTypeArguments()[0];
                    ArrayList rawWSHubList = new ArrayList();
                    for (int i = 0; i < eamValueAsList.size(); ++i) {
                        rawWSHubList.add(itemsType.newInstance());
                        this.transformEAMObject(rawWSHubList.get(i), eamValueAsList.get(i), eamContext);
                    }
                    wshubField.set(wshubObject, rawWSHubList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Property: " + e.getMessage());
        }
    }

    private List<String> convertXPathToPropertyChain(Class eamClass, String xpath, Boolean enforceValidXpath) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            for (String xp : Arrays.asList(xpath.split("/"))) {
                Field field = Arrays.stream(eamClass.getDeclaredFields()).filter(decField -> decField.getAnnotation(XmlElement.class) != null && xp.equalsIgnoreCase(decField.getAnnotation(XmlElement.class).name()) || decField.getAnnotation(XmlAttribute.class) != null && xp.equalsIgnoreCase(decField.getAnnotation(XmlAttribute.class).name()) || xp.equals(decField.getName())).findFirst().orElse(null);
                result.add(field.getName());
                eamClass = field.getType();
            }
            return result;
        }
        catch (Exception exception) {
            return result;
        }
    }

    private <I> Object getValue(I eamObject, List<String> fieldNames) {
        if (fieldNames == null || fieldNames.size() == 0) {
            return null;
        }
        try {
            Object result = eamObject;
            for (String fieldName : fieldNames) {
                Field field = result.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                result = field.get(result);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private <I> Object getValue(I eamObject, EAMField eamField) {
        return Arrays.stream(eamField.xpath()).map(xpath -> this.convertXPathToPropertyChain(eamObject.getClass(), (String)xpath, false)).map(propList -> this.getValue(eamObject, (List<String>)propList)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void setOrganizationField(Object eamObject, EAMContext context) {
        try {
            Field orgField = eamObject.getClass().getDeclaredField("organizationid");
            orgField.setAccessible(true);
            String currentOrganization = (String)orgField.get(eamObject);
            if (currentOrganization == null) {
                orgField.set(eamObject, this.tools.getOrganization(context));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object setPreviousFields(Object eamObject, List<String> fields) {
        Object eamTempObject = eamObject;
        try {
            for (String field : fields) {
                Field eamField = eamTempObject.getClass().getDeclaredField(field);
                eamField.setAccessible(true);
                Object eamFieldValue = eamField.get(eamTempObject);
                if (eamFieldValue == null) {
                    eamField.set(eamTempObject, eamField.getType().newInstance());
                }
                eamTempObject = eamField.get(eamTempObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return eamTempObject;
    }

    private void setSingleField(Object eamObject, String eamFieldName, Object wshubFieldValue, Field wshubField, EAMContext context) throws EAMException {
        try {
            Field eamField = eamObject.getClass().getDeclaredField(eamFieldName);
            eamField.setAccessible(true);
            if (wshubFieldValue instanceof Date) {
                Date dateValue = (Date)wshubFieldValue;
                if (dateValue.getTime() == 0L) {
                    eamField.set(eamObject, null);
                } else {
                    this.tools.getDataTypeTools();
                    eamField.set(eamObject, DataTypeTools.encodeEAMDate(dateValue, eamFieldName));
                }
            } else if (wshubFieldValue.getClass().equals(BigDecimal.class)) {
                BigDecimal bigDecimalValue = (BigDecimal)wshubFieldValue;
                if (bigDecimalValue.equals(BigDecimal.valueOf(DataTypeTools.NULLIFY_VALUE.intValue()))) {
                    eamField.set(eamObject, null);
                } else if (eamField.getType().equals(AMOUNT.class)) {
                    eamField.set(eamObject, DataTypeTools.encodeAmount(bigDecimalValue, eamFieldName));
                } else if (eamField.getType().equals(QUANTITY.class)) {
                    eamField.set(eamObject, DataTypeTools.encodeQuantity(bigDecimalValue, eamFieldName));
                } else if (eamField.getType().equals(Double.class)) {
                    eamField.set(eamObject, bigDecimalValue.doubleValue());
                }
            } else if (wshubFieldValue.getClass().equals(BigInteger.class)) {
                BigInteger bigIntegerValue = (BigInteger)wshubFieldValue;
                if (bigIntegerValue.equals(BigInteger.valueOf(DataTypeTools.NULLIFY_VALUE.intValue()))) {
                    eamField.set(eamObject, null);
                } else {
                    eamField.set(eamObject, bigIntegerValue.longValue());
                }
            } else if (wshubFieldValue.getClass().equals(Boolean.class) || wshubFieldValue.getClass().equals(Boolean.TYPE)) {
                Boolean booleanValue = (Boolean)wshubFieldValue;
                eamField.set(eamObject, DataTypeTools.encodeBoolean(booleanValue, wshubField.getAnnotation(EAMField.class).booleanType()));
            } else if (wshubFieldValue.getClass().equals(CustomField[].class)) {
                CustomField[] customFields = (CustomField[])wshubFieldValue;
                USERDEFINEDAREA userdefinedarea = (USERDEFINEDAREA)eamField.get(eamObject);
                this.tools.getCustomFieldsTools().updateEAMCustomFields(userdefinedarea, customFields);
            } else if ("UserDefinedFields".equals(wshubField.getAnnotation(EAMField.class).xpath()[0]) || "StandardUserDefinedFields".equals(wshubField.getAnnotation(EAMField.class).xpath()[0])) {
                UserDefinedFields userDefinedFieldsValue = (UserDefinedFields)wshubFieldValue;
                if (eamField.get(eamObject) == null) {
                    eamField.set(eamObject, eamField.getType().newInstance());
                }
                eamField.set(eamObject, this.transformWSHubObject(eamField.get(eamObject), userDefinedFieldsValue, context));
            } else {
                eamField.set(eamObject, wshubFieldValue);
            }
            this.setOrganizationField(eamObject, context);
        }
        catch (EAMException exception) {
            throw exception;
        }
        catch (Exception exception) {
            System.out.println("Error in setSingleField: " + exception.getMessage());
        }
    }

    private void setEAMFieldByPath(Object eamObject, List<String> path, Object wshubFieldValue, Field wshubField, EAMContext context) throws EAMException {
        try {
            String fieldName = path.get(0);
            Field eamField = eamObject.getClass().getDeclaredField(fieldName);
            eamField.setAccessible(true);
            if (wshubFieldValue == null) {
                return;
            }
            if (path.size() == 1) {
                this.setSingleField(eamObject, fieldName, wshubFieldValue, wshubField, context);
                return;
            }
            if (wshubFieldValue.equals("")) {
                if (path.size() == wshubField.getAnnotation(EAMField.class).nullifyParentLevel() + 1) {
                    eamField.set(eamObject, null);
                }
                if (eamField.get(eamObject) == null) {
                    return;
                }
            }
            if (eamField.get(eamObject) == null) {
                eamField.set(eamObject, eamField.getType().newInstance());
            }
            this.setOrganizationField(eamObject, context);
            this.setEAMFieldByPath(eamField.get(eamObject), path.subList(1, path.size()), wshubFieldValue, wshubField, context);
        }
        catch (EAMException exception) {
            throw exception;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

