/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.annotations.GridField;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestCell;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.Tools;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GridTools {
    private Tools tools;

    public GridTools(Tools tools) {
        this.tools = tools;
    }

    public static List<Map<String, String>> convertGridResultToMapList(GridRequestResult gridRequestResult) {
        return GridTools.convertGridResultToMapList(gridRequestResult, null);
    }

    public static List<Map<String, String>> convertGridResultToMapList(GridRequestResult gridRequestResult, List<String> allowedColumns) {
        return GridTools.convertGridResultToMapList(gridRequestResult, allowedColumns, true);
    }

    public static List<Map<String, String>> convertGridResultToMapList(GridRequestResult gridRequestResult, List<String> allowedColumns, boolean onlyDataspyFields) {
        Function<GridRequestRow, LinkedHashMap> mapper = row -> GridTools.gridRequestRowMapper(row, allowedColumns, onlyDataspyFields);
        return Arrays.stream(gridRequestResult.getRows()).map(mapper).collect(Collectors.toCollection(LinkedList::new));
    }

    public static LinkedHashMap<String, String> gridRequestRowMapper(GridRequestRow row, List<String> allowedColumns, boolean onlyDataspyFields) {
        return Arrays.stream(row.getCell()).filter(cell -> !(onlyDataspyFields && cell.getOrder() < 0 || allowedColumns != null && !allowedColumns.contains(cell.getCol()) && !allowedColumns.contains(cell.getTag()))).sorted(Comparator.comparing(GridRequestCell::getOrder)).collect(LinkedHashMap::new, (m, v) -> m.put(v.getTag(), v.getContent()), HashMap::putAll);
    }

    public static <T> Map<String, T> convertGridResultToMap(Class<T> clazz, String key, Map<String, String> columns, GridRequestResult gridRequestResult) {
        HashMap<String, T> result = new HashMap<String, T>();
        if (gridRequestResult == null || gridRequestResult.getRows() == null) {
            return result;
        }
        for (GridRequestRow gridRequestRow : gridRequestResult.getRows()) {
            result.put(GridTools.getCellContent(key, gridRequestRow), GridTools.convertCellListToObject(clazz, columns, Arrays.asList(gridRequestRow.getCell())));
        }
        return result;
    }

    public static Map<String, String> convertGridResultToMap(String key, String value, GridRequestResult gridRequestResult) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (gridRequestResult == null || gridRequestResult.getRows() == null) {
            return result;
        }
        for (GridRequestRow gridRequestRow : gridRequestResult.getRows()) {
            result.put(GridTools.getCellContent(key, gridRequestRow), GridTools.getCellContent(value, gridRequestRow));
        }
        return result;
    }

    public static <T> List<T> convertGridResultToObject(Class<T> clazz, Map<String, String> columns, GridRequestResult gridRequestResult) {
        LinkedList<T> result = new LinkedList<T>();
        if (gridRequestResult == null || gridRequestResult.getRows() == null) {
            return result;
        }
        for (GridRequestRow gridRequestRow : gridRequestResult.getRows()) {
            result.add(GridTools.convertCellListToObject(clazz, columns, Arrays.asList(gridRequestRow.getCell())));
        }
        return result;
    }

    private static <T> T convertCellListToObject(Class<T> clazz, Map<String, String> columns, List<GridRequestCell> gridRequestCellList) {
        if (columns == null) {
            return GridTools.convertCellListToObjectAnnotation(clazz, gridRequestCellList);
        }
        return GridTools.convertCellListToObjectMap(clazz, columns, gridRequestCellList);
    }

    private static <T> T convertCellListToObjectMap(Class<T> clazz, Map<String, String> columns, List<GridRequestCell> gridRequestCellList) {
        try {
            T object = clazz.newInstance();
            for (String column : columns.keySet()) {
                Field field = object.getClass().getDeclaredField(columns.get(column));
                GridTools.setValue(object, field, column, new String[0], gridRequestCellList);
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> T convertCellListToObjectAnnotation(Class<T> clazz, List<GridRequestCell> gridRequestCellList) {
        try {
            T object = clazz.newInstance();
            for (Field field : object.getClass().getDeclaredFields()) {
                GridField gridFieldAnnotation = field.getAnnotation(GridField.class);
                if (gridFieldAnnotation == null) continue;
                GridTools.setValue(object, field, gridFieldAnnotation.name(), gridFieldAnnotation.alternativeNames(), gridRequestCellList);
            }
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error: " + exception.getMessage());
            return null;
        }
    }

    private static <T> void setValue(T object, Field field, String column, String[] alternativeColumns, List<GridRequestCell> gridRequestCellList) throws Exception {
        if (UserDefinedFields.class.equals(field.getType())) {
            field.setAccessible(true);
            field.set(object, GridTools.convertCellListToObjectAnnotation(UserDefinedFields.class, gridRequestCellList));
            return;
        }
        String value = gridRequestCellList.stream().filter(cell -> cell.getCol().equals(column) || cell.getTag().equals(column) || Arrays.stream(alternativeColumns).anyMatch(altColumn -> cell.getCol().equals(altColumn)) || Arrays.stream(alternativeColumns).anyMatch(altColumn -> cell.getTag().equals(altColumn))).filter(cell -> cell.getContent() != null).map(GridRequestCell::getContent).findFirst().orElse(null);
        if (value == null) {
            return;
        }
        field.setAccessible(true);
        if (field.getType() == Date.class) {
            field.set(object, DataTypeTools.convertStringToDate(value));
        } else if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set(object, "true".equals(value));
        } else if (field.getType().equals(BigInteger.class)) {
            field.set(object, DataTypeTools.encodeBigInteger(value, column));
        } else if (field.getType().equals(BigDecimal.class)) {
            field.set(object, DataTypeTools.encodeBigDecimal(value, column));
        } else {
            field.set(object, value);
        }
    }

    public static String getCellContent(String cellid, GridRequestRow gridRequestRow) {
        if (gridRequestRow == null || gridRequestRow.getCell() == null) {
            return null;
        }
        return Arrays.stream(gridRequestRow.getCell()).filter(cell -> cell.getTag().equalsIgnoreCase(cellid) || cell.getCol().equalsIgnoreCase(cellid)).filter(cell -> cell.getContent() != null).map(GridRequestCell::getContent).findFirst().orElse(null);
    }

    public static String extractSingleResult(GridRequestResult gridRequestResult, String columnName) {
        if (gridRequestResult == null || gridRequestResult.getRows() == null || gridRequestResult.getRows().length != 1) {
            return null;
        }
        return GridTools.getCellContent(columnName, gridRequestResult.getRows()[0]);
    }

    public static boolean isEmpty(GridRequestResult gridRequestResult) {
        return gridRequestResult.getRows().length == 0;
    }

    public static boolean isNotEmpty(GridRequestResult gridRequestResult) {
        return !GridTools.isEmpty(gridRequestResult);
    }
}

