/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.administration.UserSetupService;
import ch.cern.eam.wshub.core.services.administration.entities.EAMUser;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.entities.Department;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.Tools;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.usersetup_001.UserSetup;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.SessionType;
import net.datastream.schemas.mp_functions.mp0601_001.MP0601_GetUserSetup_001;
import net.datastream.schemas.mp_functions.mp0602_001.MP0602_AddUserSetup_001;
import net.datastream.schemas.mp_functions.mp0603_001.MP0603_SyncUserSetup_001;
import net.datastream.schemas.mp_functions.mp0604_001.MP0604_DeleteUserSetup_001;
import net.datastream.schemas.mp_functions.mp9532_001.MP9532_RunEmptyOp_001;
import net.datastream.schemas.mp_results.mp0601_001.MP0601_GetUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp0602_001.MP0602_AddUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp0603_001.MP0603_SyncUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp9532_001.MP9532_RunEmptyOp_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class UserSetupServiceImpl
implements UserSetupService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public UserSetupServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public String login(EAMContext context, String userCode) throws EAMException {
        return UserSetupServiceImpl.login(context, userCode, this.tools, this.eamws);
    }

    public static String login(EAMContext context, String userCode, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) throws EAMException {
        MP9532_RunEmptyOp_001 runEmptyOp = new MP9532_RunEmptyOp_001();
        if (context != null && context.getCredentials() != null) {
            String sessionTerminationScenario = "terminate";
            if (context.getKeepSession() != null && context.getKeepSession().booleanValue()) {
                sessionTerminationScenario = null;
            }
            Holder sessionTypeHolder = new Holder();
            MP9532_RunEmptyOp_001_Result result = eamWebServicesToolkitClient.runEmptyOpOp(runEmptyOp, tools.getOrganizationCode(context), tools.createSecurityHeader(context), sessionTerminationScenario, sessionTypeHolder, null, tools.getTenant(context));
            if (sessionTypeHolder.value != null && ((SessionType)sessionTypeHolder.value).getSessionId() != null) {
                return ((SessionType)sessionTypeHolder.value).getSessionId();
            }
            return "SUCCESS";
        }
        throw Tools.generateFault("Please supply valid credentials");
    }

    @Override
    public EAMUser readUserSetup(EAMContext context, String userCode) throws EAMException {
        MP0601_GetUserSetup_001 getUserSetup = new MP0601_GetUserSetup_001();
        getUserSetup.setUSERID(new USERID_Type());
        getUserSetup.getUSERID().setUSERCODE(userCode);
        MP0601_GetUserSetup_001_Result getUserSetupResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getUserSetup);
        UserSetup userEAM = getUserSetupResult.getResultData().getUserSetup();
        EAMUser user = this.tools.getEAMFieldTools().transformEAMObject(new EAMUser(), userEAM, context);
        GridRequest employeeGridRequest = new GridRequest("WSEMPS", GridRequest.GRIDTYPE.LIST);
        employeeGridRequest.setUserFunctionName("WSEMPS");
        employeeGridRequest.setUseNative(false);
        employeeGridRequest.addFilter("associateduser", userCode, "=");
        GridRequestResult employeeGridResult = this.gridsService.executeQuery(context, employeeGridRequest);
        user.setEmployeeCode(GridTools.extractSingleResult(employeeGridResult, "employee"));
        user.setEmployeeDesc(GridTools.extractSingleResult(employeeGridResult, "employeedescription"));
        GridRequest departmentsGridRequest = new GridRequest("BSUSER_DSE", GridRequest.GRIDTYPE.LIST, 1000);
        departmentsGridRequest.setUseNative(false);
        departmentsGridRequest.addParam("param.usercode", userCode);
        user.setDepartmentalSecurity(GridTools.convertGridResultToMap(Department.class, "departmentcode", null, this.gridsService.executeQuery(context, departmentsGridRequest)));
        return user;
    }

    @Override
    public String createUserSetup(EAMContext context, EAMUser userParam) throws EAMException {
        UserSetup userEAM = new UserSetup();
        userEAM.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(userEAM.getCLASSID()), userEAM.getUSERDEFINEDAREA(), userParam.getClassCode(), "USER"));
        this.tools.getEAMFieldTools().transformWSHubObject(userEAM, userParam, context);
        userEAM.setLANGUAGE("EN");
        this.tools.getDataTypeTools();
        userEAM.setMSGTIMEOUT(DataTypeTools.encodeAmount(BigDecimal.TEN, "Success Msg. Timeout"));
        userEAM.setISCONNECTOR("+");
        MP0602_AddUserSetup_001 addUser = new MP0602_AddUserSetup_001();
        addUser.setUserSetup(userEAM);
        MP0602_AddUserSetup_001_Result result = null;
        result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addUser);
        return result.getUSERID().getUSERCODE();
    }

    @Override
    public String updateUserSetup(EAMContext context, EAMUser userParam) throws EAMException {
        MP0601_GetUserSetup_001_Result getUserSetupResult = null;
        MP0601_GetUserSetup_001 getUserSetup = new MP0601_GetUserSetup_001();
        getUserSetup.setUSERID(new USERID_Type());
        getUserSetup.getUSERID().setUSERCODE(userParam.getUserCode());
        getUserSetupResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getUserSetup);
        UserSetup userEAM = getUserSetupResult.getResultData().getUserSetup();
        userEAM.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(userEAM.getCLASSID()), userEAM.getUSERDEFINEDAREA(), userParam.getClassCode(), "USER"));
        this.tools.getEAMFieldTools().transformWSHubObject(userEAM, userParam, context);
        MP0603_SyncUserSetup_001 syncUser = new MP0603_SyncUserSetup_001();
        syncUser.setUserSetup(userEAM);
        MP0603_SyncUserSetup_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncUser);
        return result.getUSERID().getUSERCODE();
    }

    @Override
    public BatchResponse<String> updateUserSetupBatch(EAMContext context, List<EAMUser> eamUsers) throws EAMException {
        List callableList = eamUsers.stream().map(eamUser -> () -> this.updateUserSetup(context, (EAMUser)eamUser)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public String deleteUserSetup(EAMContext context, String userCode) throws EAMException {
        MP0604_DeleteUserSetup_001 deleteUser = new MP0604_DeleteUserSetup_001();
        deleteUser.setUSERID(new USERID_Type());
        deleteUser.getUSERID().setUSERCODE(userCode);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteUser);
        return "success";
    }
}

