/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.customfields;

import ch.cern.eam.wshub.core.services.grids.customfields.DataspyCustomField;
import ch.cern.eam.wshub.core.services.grids.entities.DataspyField;
import ch.cern.eam.wshub.core.services.grids.entities.GridField;
import ch.cern.eam.wshub.core.services.grids.impl.DataField;
import ch.cern.eam.wshub.core.services.grids.impl.DataType;
import ch.cern.eam.wshub.core.tools.Tools;
import jakarta.persistence.EntityManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GridCustomFieldHandler
implements Serializable {
    private Tools tools;
    public static String NUMERICAL_VALUE = "PRV_NVALUE";
    public static String DATE_VALUE = "PRV_DVALUE";
    public static String VARCHAR_VALUE = "PRV_VALUE";
    private String dataspyID;
    private List<DataspyCustomField> customFields;

    public GridCustomFieldHandler(Tools tools) {
        this.tools = tools;
    }

    public void initializeForDataspy(String dataspyID) {
        this.dataspyID = dataspyID;
        this.fetchCustomFields(dataspyID);
        for (DataspyCustomField dataspyCustomField : this.customFields) {
            dataspyCustomField.setPropertyName(dataspyCustomField.getTagName().split("_")[1].toUpperCase());
            dataspyCustomField.setRentity(dataspyCustomField.getTagName().split("_")[2].toUpperCase());
        }
    }

    private void fetchCustomFields(String dataspyID) {
        EntityManager em = this.tools.getEntityManager();
        List results = em.createNamedQuery("DataspyCustomField.GET_CUSTOM_FIELDS_FOR_DATASPY").setParameter("dataspyID", (Object)dataspyID).getResultList();
        this.customFields = this.parseResults(results);
    }

    private List<DataspyCustomField> parseResults(List<Object[]> results) {
        return results.stream().map(result -> {
            DataspyCustomField dataspyCustomField = new DataspyCustomField();
            dataspyCustomField.setDataspyID(String.valueOf(result[0]));
            dataspyCustomField.setTagName(String.valueOf(result[1]));
            dataspyCustomField.setWidth(String.valueOf(result[2]));
            dataspyCustomField.setOrder(String.valueOf(result[3]));
            dataspyCustomField.setViewType(String.valueOf(result[4]));
            dataspyCustomField.setDescription(String.valueOf(result[5]));
            dataspyCustomField.setPropertyType(String.valueOf(result[6]));
            return dataspyCustomField;
        }).collect(Collectors.toList());
    }

    public List<DataspyField> getCustomFieldsAsDataspyFields() {
        return this.customFields.stream().map(dataspyCustomField -> {
            DataspyField dataspyField = new DataspyField();
            dataspyField.setId(String.valueOf(-Integer.valueOf(dataspyCustomField.getOrder()).intValue()));
            dataspyField.setDataspy(this.getDataspyID());
            dataspyField.setOrder(Integer.valueOf(dataspyCustomField.getOrder()));
            dataspyField.setDataType("VARCHAR");
            dataspyField.setTagName(dataspyCustomField.getTagName());
            return dataspyField;
        }).sorted(Comparator.comparingInt(dataspyCustomField -> dataspyCustomField.getOrder())).collect(Collectors.toList());
    }

    public List<String> attachCustomFields(List<String> sqlStatements) {
        ArrayList<String> newSqlStatements = new ArrayList<String>(sqlStatements);
        int[] index = new int[]{0};
        this.customFields = this.customFields.stream().sorted(Comparator.comparingInt(c -> Integer.valueOf(c.getOrder()))).collect(Collectors.toList());
        newSqlStatements.addAll(this.customFields.stream().map(customField -> {
            int n = index[0];
            index[0] = n + 1;
            return this.getSourceName(customField.getRentity(), this.getJoinName(customField.getPropertyName()), this.getField(customField.getPropertyType())) + " AS C" + n;
        }).collect(Collectors.toList()));
        return newSqlStatements;
    }

    public String addCustomFieldsJoinClause(String sqlStatementFrom) {
        String joinClause = this.customFields.stream().map(customField -> {
            String primaryKey = null;
            String organizationSuffix = "";
            if (customField.getRentity().equals("OBJ")) {
                primaryKey = "OBJ_CODE";
                organizationSuffix = "|| '#*'";
            }
            if (customField.getRentity().equals("EVNT")) {
                primaryKey = "EVT_CODE";
            }
            if (customField.getRentity().equals("PART")) {
                primaryKey = "PAR_CODE";
                organizationSuffix = "|| '#*'";
            }
            String joinClausePart = null;
            if (!customField.getRentity().equals("PART")) {
                joinClausePart = "LEFT OUTER JOIN R5PROPERTYVALUES " + this.getJoinName(customField.getPropertyName()) + " ON " + primaryKey + organizationSuffix + "=" + this.getJoinName(customField.getPropertyName()) + ".PRV_CODE AND " + this.getJoinName(customField.getPropertyName()) + ".PRV_RENTITY='" + customField.getRentity() + "' AND " + this.getJoinName(customField.getPropertyName()) + ".PRV_PROPERTY='" + customField.getPropertyName() + "' ";
                if (customField.getRentity().equals("OBJ")) {
                    joinClausePart = (String)joinClausePart + "LEFT OUTER JOIN R5PROPERTYVALUES " + this.getJoinName(customField.getPropertyName()) + "2 ON OBJ_CATEGORY=" + this.getJoinName(customField.getPropertyName()) + "2.PRV_CODE AND " + this.getJoinName(customField.getPropertyName()) + "2.PRV_RENTITY='" + customField.getRentity() + "' AND " + this.getJoinName(customField.getPropertyName()) + "2.PRV_PROPERTY='" + customField.getPropertyName() + "' ";
                }
            }
            if (customField.getRentity().equals("PART")) {
                joinClausePart = ", R5PROPERTYVALUES " + this.getJoinName(customField.getPropertyName()) + " ";
            }
            return joinClausePart;
        }).collect(Collectors.joining(" "));
        return sqlStatementFrom + joinClause;
    }

    public GridField[] getCustomFieldsAsGridFields(String dataspyID) {
        if (this.dataspyID == null || !this.getDataspyID().equals(dataspyID)) {
            this.fetchCustomFields(dataspyID);
        }
        return this.mapCustomFieldsToGridFields(this.customFields);
    }

    private GridField[] mapCustomFieldsToGridFields(List<DataspyCustomField> customFields) {
        return customFields.stream().map(customField -> {
            GridField gridField = new GridField();
            gridField.setId(String.valueOf(-Integer.valueOf(customField.getOrder()).intValue()));
            gridField.setName(customField.getTagName());
            gridField.setLabel(customField.getDescription());
            gridField.setWidth(customField.getWidth());
            gridField.setDataType("VARCHAR");
            gridField.setDdSpyId(customField.getDataspyID());
            gridField.setOrder(Integer.parseInt(customField.getOrder()));
            return gridField;
        }).collect(Collectors.toList()).toArray(new GridField[customFields.size()]);
    }

    public Map<String, DataField> getCustomFieldsForGrid(String gridID) {
        EntityManager em = this.tools.getEntityManager();
        String queryString = "SELECT DISTINCT   DCF_TAGNAME,   PRO_TYPE FROM R5DDCUSTOMFIELDS JOIN R5DDDATASPY ON DCF_DDSPYID = DDS_DDSPYID JOIN R5PROPERTIES ON UPPER(SUBSTR(DCF_TAGNAME, 3, INSTR(DCF_TAGNAME, '_', 1, 2) - 3)) = PRO_CODE WHERE DDS_GRIDID = :gridID";
        List results = em.createNativeQuery(queryString).setParameter("gridID", (Object)gridID).getResultList();
        return results.stream().map(result -> {
            String tagName = String.valueOf(result[0]);
            String propertyName = tagName.split("_")[1].toUpperCase();
            String rentity = String.valueOf(tagName.split("_")[tagName.split("_").length - 1]).toUpperCase();
            String dataTypeString = String.valueOf(result[1]);
            DataType dataType = this.inferDataTypeFromPropertyType(dataTypeString);
            return new DataField(String.valueOf(result[0]), this.getSourceName(rentity, this.getJoinName(propertyName), this.getField(dataTypeString)), dataType, false);
        }).collect(Collectors.toMap(dataField -> dataField.getTagName(), dataField -> dataField));
    }

    private DataType inferDataTypeFromPropertyType(String dataTypeString) {
        switch (dataTypeString) {
            case "CHAR": {
                return DataType.VARCHAR;
            }
            case "NUM": {
                return DataType.NUMBER;
            }
            case "CODE": {
                return DataType.VARCHAR;
            }
            case "DATE": {
                return DataType.DATE;
            }
            case "DATI": {
                return DataType.DATETIME;
            }
        }
        return DataType.VARCHAR;
    }

    public String getCustomFieldJoinConditions() {
        return this.customFields.stream().filter(customField -> customField.getRentity().equals("PART")).map(customField -> "AND PAR_CODE || '#*' = " + this.getJoinName(customField.getPropertyName()) + ".PRV_CODE(+) AND (" + this.getJoinName(customField.getPropertyName()) + ".PRV_RENTITY = 'PART' OR " + this.getJoinName(customField.getPropertyName()) + ".PRV_RENTITY IS NULL)  AND (" + this.getJoinName(customField.getPropertyName()) + ".PRV_PROPERTY = '" + customField.getPropertyName() + "' OR " + this.getJoinName(customField.getPropertyName()) + ".PRV_PROPERTY IS NULL) ").collect(Collectors.joining(" "));
    }

    private String getSourceName(String rentity, String joinName, String field) {
        if (rentity.equals("OBJ")) {
            return "NVL(" + joinName + "." + field + ", " + joinName + "2." + field + ")";
        }
        return joinName + "." + field;
    }

    private String getJoinName(String property) {
        return "PROP_" + property + "_JOIN";
    }

    private String getField(String propertyType) {
        if (propertyType.equals("NUM")) {
            return NUMERICAL_VALUE;
        }
        if (propertyType.equals("DATE") || propertyType.equals("DATI")) {
            return DATE_VALUE;
        }
        return VARCHAR_VALUE;
    }

    public String getDataspyID() {
        return this.dataspyID;
    }
}

