/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.material.PhysicalInventoryService;
import ch.cern.eam.wshub.core.services.material.entities.PhysicalInventory;
import ch.cern.eam.wshub.core.services.material.entities.PhysicalInventoryRow;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigInteger;
import net.datastream.schemas.mp_entities.inventorytransaction_001.InventoryTransaction;
import net.datastream.schemas.mp_entities.inventorytransactiondefault_001.InventoryTransactionDefault;
import net.datastream.schemas.mp_entities.physicalinventoryline_001.PhysicalInventoryLine;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.TRANSACTIONID_Type;
import net.datastream.schemas.mp_fields.TRANSACTIONLINEID;
import net.datastream.schemas.mp_functions.mp1217_001.MP1217_AddInventoryTransaction_001;
import net.datastream.schemas.mp_functions.mp1218_001.MP1218_SyncInventoryTransaction_001;
import net.datastream.schemas.mp_functions.mp1219_001.MP1219_GetInventoryTransactionDefault_001;
import net.datastream.schemas.mp_functions.mp1220_001.MP1220_GetInventoryTransaction_001;
import net.datastream.schemas.mp_functions.mp1294_001.MP1294_SyncPhysicalInventoryLine_001;
import net.datastream.schemas.mp_functions.mp2244_001.MP2244_GetPhysicalInventoryLine_001;
import net.datastream.schemas.mp_results.mp1217_001.MP1217_AddInventoryTransaction_001_Result;
import net.datastream.schemas.mp_results.mp1220_001.ResultData;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class PhysicalInventoryServiceImpl
implements PhysicalInventoryService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public PhysicalInventoryServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public PhysicalInventory createPhysicalInventory(EAMContext context, PhysicalInventory physicalInventory) throws EAMException {
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTRANSACTIONID(new TRANSACTIONID_Type());
        inventoryTransaction.getTRANSACTIONID().setTRANSACTIONCODE("0");
        this.tools.getEAMFieldTools().transformWSHubObject(inventoryTransaction, physicalInventory, context);
        MP1217_AddInventoryTransaction_001 addInventoryTransaction = new MP1217_AddInventoryTransaction_001();
        addInventoryTransaction.setInventoryTransaction(inventoryTransaction);
        MP1217_AddInventoryTransaction_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addInventoryTransactionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addInventoryTransaction);
        return this.tools.getEAMFieldTools().transformEAMObject(new PhysicalInventory(), result.getResultData().getInventoryTransaction(), context);
    }

    @Override
    public PhysicalInventory readPhysicalInventory(EAMContext context, String code) throws EAMException {
        ResultData resultData = this.getInventoryResultData(context, code);
        PhysicalInventory physicalInventory = this.tools.getEAMFieldTools().transformEAMObject(new PhysicalInventory(), resultData.getInventoryTransaction(), context);
        if (resultData.getCREATEDBY() != null) {
            physicalInventory.setCreatedBy(resultData.getCREATEDBY().getUSERCODE());
        }
        if (resultData.getCREATEDDATE() != null) {
            this.tools.getDataTypeTools();
            physicalInventory.setCreatedDate(DataTypeTools.decodeEAMDate(resultData.getCREATEDDATE()));
        }
        return physicalInventory;
    }

    @Override
    public PhysicalInventory updatePhysicalInventory(EAMContext context, PhysicalInventory physicalInventory) throws EAMException {
        InventoryTransaction inventoryTransaction = this.getInventoryResultData(context, physicalInventory.getCode()).getInventoryTransaction();
        this.tools.getEAMFieldTools().transformWSHubObject(inventoryTransaction, physicalInventory, context);
        MP1218_SyncInventoryTransaction_001 syncInventoryTransaction = new MP1218_SyncInventoryTransaction_001();
        syncInventoryTransaction.setInventoryTransaction(inventoryTransaction);
        InventoryTransaction result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncInventoryTransactionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncInventoryTransaction).getResultData().getInventoryTransaction();
        return this.tools.getEAMFieldTools().transformEAMObject(new PhysicalInventory(), result, context);
    }

    private ResultData getInventoryResultData(EAMContext context, String code) throws EAMException {
        MP1220_GetInventoryTransaction_001 getInventoryTransaction = new MP1220_GetInventoryTransaction_001();
        getInventoryTransaction.setTRANSACTIONID(new TRANSACTIONID_Type());
        getInventoryTransaction.getTRANSACTIONID().setTRANSACTIONCODE(code);
        getInventoryTransaction.getTRANSACTIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        return this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getInventoryTransactionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getInventoryTransaction).getResultData();
    }

    @Override
    public PhysicalInventoryRow readPhysicalInventoryLine(EAMContext context, PhysicalInventoryRow row) throws EAMException {
        return this.tools.getEAMFieldTools().transformEAMObject(new PhysicalInventoryRow(), this.getLine(context, row.getPhysicalInventoryCode(), row.getLineNumber()), context);
    }

    @Override
    public PhysicalInventoryRow updatePhysicalInventoryLine(EAMContext context, PhysicalInventoryRow row) throws EAMException {
        PhysicalInventoryLine physicalInventoryLine = this.getLine(context, row.getPhysicalInventoryCode(), row.getLineNumber());
        this.tools.getEAMFieldTools().transformWSHubObject(physicalInventoryLine, row, context);
        this.tools.getDataTypeTools();
        physicalInventoryLine.setPHYSICALQUANTITY(DataTypeTools.encodeQuantity(row.getPhysicalQuantity(), "Physical Quantity"));
        MP1294_SyncPhysicalInventoryLine_001 syncPhysicalInventoryLine = new MP1294_SyncPhysicalInventoryLine_001();
        syncPhysicalInventoryLine.setPhysicalInventoryLine(physicalInventoryLine);
        PhysicalInventoryLine result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncPhysicalInventoryLineOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPhysicalInventoryLine).getResultData().getPhysicalInventoryLine();
        return this.tools.getEAMFieldTools().transformEAMObject(new PhysicalInventoryRow(), result, context);
    }

    private PhysicalInventoryLine getLine(EAMContext context, String code, BigInteger lineNumber) throws EAMException {
        TRANSACTIONLINEID transactionLineId = new TRANSACTIONLINEID();
        transactionLineId.setTRANSACTIONID(new TRANSACTIONID_Type());
        transactionLineId.getTRANSACTIONID().setTRANSACTIONCODE(code);
        transactionLineId.getTRANSACTIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        this.tools.getDataTypeTools();
        transactionLineId.setTRANSACTIONLINENUM(DataTypeTools.convertBigIntegerToLong(lineNumber));
        MP2244_GetPhysicalInventoryLine_001 getPhysicalInventoryLine = new MP2244_GetPhysicalInventoryLine_001();
        getPhysicalInventoryLine.setTRANSACTIONLINEID(transactionLineId);
        return this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getPhysicalInventoryLineOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPhysicalInventoryLine).getResultData().getPhysicalInventoryLine();
    }

    @Override
    public PhysicalInventory readDefaultPhysicalInventory(EAMContext context, String storeCode) throws EAMException {
        MP1219_GetInventoryTransactionDefault_001 getInventoryTransactionDefault = new MP1219_GetInventoryTransactionDefault_001();
        getInventoryTransactionDefault.setSTOREID(new STOREID_Type());
        getInventoryTransactionDefault.getSTOREID().setSTORECODE(storeCode);
        getInventoryTransactionDefault.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        InventoryTransactionDefault inventoryTransactionDefault = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getInventoryTransactionDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getInventoryTransactionDefault).getResultData().getInventoryTransactionDefault();
        return this.tools.getEAMFieldTools().transformEAMObject(new PhysicalInventory(), inventoryTransactionDefault, context);
    }
}

