/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.casemanagement.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.casemanagement.CaseManagementService;
import ch.cern.eam.wshub.core.services.casemanagement.entities.EAMCaseManagement;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.casemanagement_001.CaseManagement;
import net.datastream.schemas.mp_fields.CASEID_Type;
import net.datastream.schemas.mp_functions.mp3640_001.MP3640_AddCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3641_001.MP3641_SyncCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3642_001.MP3642_DeleteCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3643_001.MP3643_GetCaseManagement_001;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class CaseManagementServiceImpl
implements CaseManagementService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public CaseManagementServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public EAMCaseManagement readCase(EAMContext context, String caseCode) throws EAMException {
        CaseManagement caseManagement = this.readCaseEAM(context, caseCode);
        EAMCaseManagement eamCaseManagement = this.tools.getEAMFieldTools().transformEAMObject(new EAMCaseManagement(), caseManagement, context);
        CustomField[] customFields = eamCaseManagement.getCustomFields();
        if (customFields != null) {
            Map<String, String> collect = Arrays.stream(customFields).collect(Collectors.toMap(CustomField::getCode, s -> s.getValue() != null ? s.getValue() : ""));
            eamCaseManagement.setCustomFieldMap(collect);
        }
        return eamCaseManagement;
    }

    private CaseManagement readCaseEAM(EAMContext context, String caseCode) throws EAMException {
        MP3643_GetCaseManagement_001 getCase = new MP3643_GetCaseManagement_001();
        getCase.setCASEID(new CASEID_Type());
        getCase.getCASEID().setCASECODE(caseCode);
        getCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        CaseManagement caseManagement = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getCase).getResultData().getCaseManagement();
        return caseManagement;
    }

    private CaseManagement syncCase(EAMContext context, EAMCaseManagement eamCaseManagement, CaseManagement caseManagement) throws EAMException {
        Map<String, String> customFieldMap = eamCaseManagement.getCustomFieldMap();
        if (customFieldMap != null) {
            CustomField[] customFields = (CustomField[])customFieldMap.entrySet().stream().map(s -> new CustomField((String)s.getKey(), (String)s.getValue())).toArray(CustomField[]::new);
            eamCaseManagement.setCustomFields(customFields);
        }
        caseManagement.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, null, caseManagement.getUSERDEFINEDAREA(), eamCaseManagement.getClassCode(), "CASE"));
        eamCaseManagement.setSystemStatusCode("O");
        CaseManagement caseManagement1 = this.tools.getEAMFieldTools().transformWSHubObject(caseManagement, eamCaseManagement, context);
        return caseManagement1;
    }

    @Override
    public String createCase(EAMContext context, EAMCaseManagement eamCaseManagement) throws EAMException {
        eamCaseManagement.setCaseCode("0");
        CaseManagement caseManagement = this.syncCase(context, eamCaseManagement, new CaseManagement());
        MP3640_AddCaseManagement_001 mp3640_AddCaseManagement_001 = new MP3640_AddCaseManagement_001();
        mp3640_AddCaseManagement_001.setCaseManagement(caseManagement);
        String caseCode = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), mp3640_AddCaseManagement_001).getResultData().getCASEID().getCASECODE();
        return caseCode;
    }

    @Override
    public String deleteCase(EAMContext context, String caseCode) throws EAMException {
        MP3642_DeleteCaseManagement_001 deleteCase = new MP3642_DeleteCaseManagement_001();
        deleteCase.setCASEID(new CASEID_Type());
        deleteCase.getCASEID().setCASECODE(caseCode);
        deleteCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteCase);
        return caseCode;
    }

    @Override
    public synchronized String updateCase(EAMContext context, EAMCaseManagement eamCaseManagement) throws EAMException {
        CaseManagement caseManagement = this.readCaseEAM(context, eamCaseManagement.getCaseCode());
        CaseManagement caseManagement1 = this.syncCase(context, eamCaseManagement, caseManagement);
        MP3641_SyncCaseManagement_001 mp3641_SyncCaseManagement_001 = new MP3641_SyncCaseManagement_001();
        mp3641_SyncCaseManagement_001.setCaseManagement(caseManagement1);
        String caseCode = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), mp3641_SyncCaseManagement_001).getResultData().getCASEID().getCASECODE();
        return caseCode;
    }
}

