/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.equipment.LinearReferenceService;
import ch.cern.eam.wshub.core.services.equipment.entities.LinearReference;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.equiplinearref_001.EquipLinearRef;
import net.datastream.schemas.mp_entities.equiplinearref_001.OverviewDetails;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp3023_001.MP3023_GetEquipLinearRef_001;
import net.datastream.schemas.mp_functions.mp3024_001.MP3024_AddEquipLinearRef_001;
import net.datastream.schemas.mp_functions.mp3025_001.MP3025_DeleteEquipLinearRef_001;
import net.datastream.schemas.mp_functions.mp3026_001.MP3026_SyncEquipLinearRef_001;
import net.datastream.schemas.mp_results.mp3023_001.MP3023_GetEquipLinearRef_001_Result;
import net.datastream.schemas.mp_results.mp3024_001.MP3024_AddEquipLinearRef_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class LinearReferenceServiceImpl
implements LinearReferenceService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public LinearReferenceServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public String updateEquipmentLinearReference(EAMContext context, LinearReference linearReference) throws EAMException {
        block13: {
            if (linearReference.getID() == null) {
                throw Tools.generateFault("Linear Reference ID must be present.");
            }
            MP3023_GetEquipLinearRef_001 getLinRef = new MP3023_GetEquipLinearRef_001();
            getLinRef.setLRFID(this.tools.getDataTypeTools().encodeLong(linearReference.getID(), "Linear Reference ID"));
            MP3023_GetEquipLinearRef_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getEquipLinearRefOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLinRef);
            EquipLinearRef linearReferenceEAM = result.getResultData().getEquipLinearRef();
            if (linearReference.getRelatedEquipmentCode() != null && !linearReference.getRelatedEquipmentCode().trim().equals("")) {
                linearReferenceEAM.setLRFRELATEDEQUIPMENTID(new EQUIPMENTID_Type());
                linearReferenceEAM.getLRFRELATEDEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                linearReferenceEAM.getLRFRELATEDEQUIPMENTID().setEQUIPMENTCODE(linearReference.getRelatedEquipmentCode());
            }
            if (linearReference.getUpdateCount() != null && !linearReference.getUpdateCount().trim().equals("")) {
                linearReferenceEAM.setRecordid(Long.valueOf(this.tools.getDataTypeTools().encodeLong(linearReference.getUpdateCount(), "Update Count")));
            }
            if (linearReference.getTypeCode() != null && !linearReference.getTypeCode().trim().equals("")) {
                linearReferenceEAM.setLRFTYPE(new TYPE_Type());
                linearReferenceEAM.getLRFTYPE().setTYPECODE(linearReference.getTypeCode());
            }
            if (linearReference.getEquipmentCode() != null && !linearReference.getEquipmentCode().trim().equals("")) {
                linearReferenceEAM.setEQUIPMENTID(new EQUIPMENTID_Type());
                linearReferenceEAM.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                linearReferenceEAM.getEQUIPMENTID().setEQUIPMENTCODE(linearReference.getEquipmentCode().toUpperCase());
            }
            if (linearReference.getDescription() != null && !linearReference.getDescription().trim().equals("")) {
                linearReferenceEAM.setLRFDESC(linearReference.getDescription());
            }
            if (linearReference.getFromPoint() != null) {
                this.tools.getDataTypeTools();
                linearReferenceEAM.setLRFFROMPOINT(DataTypeTools.encodeQuantity(linearReference.getFromPoint(), "From Point"));
            }
            if (linearReference.getToPoint() != null) {
                this.tools.getDataTypeTools();
                linearReferenceEAM.setLRFTOPOINT(DataTypeTools.encodeQuantity(linearReference.getToPoint(), "To Point"));
            }
            if (linearReference.getGeographicalReference() != null && !linearReference.getGeographicalReference().trim().equals("")) {
                linearReferenceEAM.setLRFGEOREF(linearReference.getGeographicalReference());
            }
            if (linearReference.getDisplayOnOverview() != null || linearReference.getColorCode() != null || linearReference.getIconCode() != null || linearReference.getIconPath() != null) {
                linearReferenceEAM.setOverviewDetails(new OverviewDetails());
                linearReferenceEAM.getOverviewDetails().setCOLOR(linearReference.getColorCode());
                linearReferenceEAM.getOverviewDetails().setDISPLAYONOVERVIEW(linearReference.getDisplayOnOverview());
                linearReferenceEAM.getOverviewDetails().setICONCODE(linearReference.getIconCode());
                linearReferenceEAM.getOverviewDetails().setICONPATH(linearReference.getIconPath());
            }
            if (linearReference.getClassCode() != null) {
                linearReferenceEAM.setCLASSID(new CLASSID_Type());
                linearReferenceEAM.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
                linearReferenceEAM.getCLASSID().setCLASSCODE(linearReference.getClassCode().toUpperCase());
            }
            MP3026_SyncEquipLinearRef_001 syncEquipLienarRef = new MP3026_SyncEquipLinearRef_001();
            syncEquipLienarRef.setEquipLinearRef(linearReferenceEAM);
            try {
                this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncEquipLinearRefOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncEquipLienarRef);
            }
            catch (Exception e) {
                if (e.getMessage().contains("EquipLinearRef has been Synchronized.")) break block13;
                throw e;
            }
        }
        return linearReference.getID();
    }

    @Override
    public String deleteEquipmentLinearReference(EAMContext context, String linearReferenceID) throws EAMException {
        MP3025_DeleteEquipLinearRef_001 deleteEquipLinearRef = new MP3025_DeleteEquipLinearRef_001();
        deleteEquipLinearRef.setLRFID(this.tools.getDataTypeTools().encodeLong(linearReferenceID, "Linear Ref. ID"));
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteEquipLinearRefOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteEquipLinearRef);
        return linearReferenceID;
    }

    @Override
    public String createEquipmentLinearReference(EAMContext context, LinearReference linearReference) throws EAMException {
        EquipLinearRef linearReferenceEAM = new EquipLinearRef();
        if (linearReference.getRelatedEquipmentCode() != null && !linearReference.getRelatedEquipmentCode().trim().equals("")) {
            linearReferenceEAM.setLRFRELATEDEQUIPMENTID(new EQUIPMENTID_Type());
            linearReferenceEAM.getLRFRELATEDEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            linearReferenceEAM.getLRFRELATEDEQUIPMENTID().setEQUIPMENTCODE(linearReference.getRelatedEquipmentCode());
        }
        if (linearReference.getTypeCode() != null && !linearReference.getTypeCode().trim().equals("")) {
            linearReferenceEAM.setLRFTYPE(new TYPE_Type());
            linearReferenceEAM.getLRFTYPE().setTYPECODE(linearReference.getTypeCode());
        }
        if (linearReference.getEquipmentCode() != null && !linearReference.getEquipmentCode().trim().equals("")) {
            linearReferenceEAM.setEQUIPMENTID(new EQUIPMENTID_Type());
            linearReferenceEAM.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            linearReferenceEAM.getEQUIPMENTID().setEQUIPMENTCODE(linearReference.getEquipmentCode().toUpperCase());
        }
        if (linearReference.getDescription() != null && !linearReference.getDescription().trim().equals("")) {
            linearReferenceEAM.setLRFDESC(linearReference.getDescription());
        }
        if (linearReference.getFromPoint() != null) {
            this.tools.getDataTypeTools();
            linearReferenceEAM.setLRFFROMPOINT(DataTypeTools.encodeQuantity(linearReference.getFromPoint(), "From Point"));
        }
        if (linearReference.getToPoint() != null) {
            this.tools.getDataTypeTools();
            linearReferenceEAM.setLRFTOPOINT(DataTypeTools.encodeQuantity(linearReference.getToPoint(), "To Point"));
        }
        if (linearReference.getGeographicalReference() != null && !linearReference.getGeographicalReference().trim().equals("")) {
            linearReferenceEAM.setLRFGEOREF(linearReference.getGeographicalReference());
        }
        if (linearReference.getDisplayOnOverview() != null || linearReference.getColorCode() != null || linearReference.getIconCode() != null || linearReference.getIconPath() != null) {
            linearReferenceEAM.setOverviewDetails(new OverviewDetails());
            linearReferenceEAM.getOverviewDetails().setCOLOR(linearReference.getColorCode());
            linearReferenceEAM.getOverviewDetails().setDISPLAYONOVERVIEW(linearReference.getDisplayOnOverview());
            linearReferenceEAM.getOverviewDetails().setICONCODE(linearReference.getIconCode());
            linearReferenceEAM.getOverviewDetails().setICONPATH(linearReference.getIconPath());
        }
        if (linearReference.getClassCode() != null) {
            linearReferenceEAM.setCLASSID(new CLASSID_Type());
            linearReferenceEAM.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            linearReferenceEAM.getCLASSID().setCLASSCODE(linearReference.getClassCode());
        }
        MP3024_AddEquipLinearRef_001 addEquipLinearRef = new MP3024_AddEquipLinearRef_001();
        addEquipLinearRef.setEquipLinearRef(linearReferenceEAM);
        MP3024_AddEquipLinearRef_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addEquipLinearRefOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addEquipLinearRef);
        return String.valueOf(result.getResultData().getLRFID());
    }
}

