/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.grids.entities.GridDataspy;
import ch.cern.eam.wshub.core.services.grids.entities.GridField;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestCell;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestSort;
import ch.cern.eam.wshub.core.services.grids.impl.Operator;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_functions.gridrequest.ADDON_SORT;
import net.datastream.schemas.mp_functions.gridrequest.DATASPY;
import net.datastream.schemas.mp_functions.gridrequest.GRID;
import net.datastream.schemas.mp_functions.gridrequest.GRID_TYPE;
import net.datastream.schemas.mp_functions.gridrequest.GRID_TYPE_Type;
import net.datastream.schemas.mp_functions.gridrequest.LOV;
import net.datastream.schemas.mp_functions.gridrequest.MULTIADDON_FILTERS;
import net.datastream.schemas.mp_functions.gridrequest.SORT_TYPE;
import net.datastream.schemas.mp_functions.mp0116_getgriddataonly_001.FUNCTION_REQUEST_INFO;
import net.datastream.schemas.mp_functions.mp0116_getgriddataonly_001.FUNCTION_REQUEST_TYPE;
import net.datastream.schemas.mp_functions.mp0116_getgriddataonly_001.MP0116_GetGridDataOnly_001;
import net.datastream.schemas.mp_functions.mp0116_getgriddataonly_001_result.DATA;
import net.datastream.schemas.mp_functions.mp0116_getgriddataonly_001_result.MP0116_GetGridDataOnly_001_Result;
import net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001.MP0118_GetGridHeaderData_001;
import net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001_result.DATA;
import net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001_result.FIELD;
import net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001_result.MP0118_GetGridHeaderData_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class EAMGrids
implements Serializable {
    private static final long serialVersionUID = 5957161022766799698L;
    private ApplicationData applicationData;
    private Tools tools;
    private EAMWebServicesPT eamws;
    public static final Map<String, Map<BigInteger, GridField>> gridFieldCache = new ConcurrentHashMap<String, Map<BigInteger, GridField>>();

    public EAMGrids(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    public GridRequestResult executeQuery(EAMContext context, GridRequest gridRequest) throws EAMException {
        if (gridRequest.getIncludeMetadata().booleanValue() || !gridFieldCache.containsKey(gridRequest.getRequestKey())) {
            return this.executeQueryHeaderData(context, gridRequest);
        }
        return this.executeQueryDataOnly(context, gridRequest);
    }

    public GridRequestResult executeQueryDataOnly(EAMContext context, GridRequest gridRequest) throws EAMException {
        FUNCTION_REQUEST_INFO funRequest = new FUNCTION_REQUEST_INFO();
        funRequest.setGRID(this.createGrid(gridRequest));
        if (gridRequest.getDataspyID() != null) {
            funRequest.setDATASPY(new DATASPY());
            funRequest.getDATASPY().setDATASPY_ID(new BigInteger(gridRequest.getDataspyID()));
        }
        funRequest.setREQUEST_TYPE(FUNCTION_REQUEST_TYPE.LIST___DATA___ONLY___STORED);
        funRequest.setGRID_TYPE(this.createGridType(gridRequest));
        funRequest.setMULTIADDON_FILTERS(this.createGridFilters(gridRequest));
        funRequest.setADDON_SORT(this.createSort(gridRequest));
        funRequest.setLOV(this.createLovParams(gridRequest));
        MP0116_GetGridDataOnly_001 getgridd = new MP0116_GetGridDataOnly_001();
        getgridd.setFUNCTION_REQUEST_INFO(funRequest);
        getgridd.getFUNCTION_REQUEST_INFO().getGRID().setLOCALIZE_RESULT(DataTypeTools.encodeBoolean(context.getLocalizeResults(), BooleanType.TRUE_FALSE));
        MP0116_GetGridDataOnly_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getGridDataOnlyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getgridd);
        GridRequestResult grr = new GridRequestResult();
        grr.setGridCode(result.getGRIDRESULT().getGRID().getMETADATA().getGRIDID().toString());
        grr.setGridName(result.getGRIDRESULT().getGRID().getMETADATA().getGRIDNAME());
        grr.setDataSpyId(result.getGRIDRESULT().getDATASPY().getId());
        grr.setRecords(result.getGRIDRESULT().getGRID().getMETADATA().getRECORDS());
        grr.setCursorPosition(result.getGRIDRESULT().getGRID().getMETADATA().getCURRENTCURSORPOSITION().intValue());
        if (result.getGRIDRESULT().getGRID().getMETADATA().getMORERECORDPRESENT().equals("+")) {
            grr.setMoreRowsPresent("TRUE");
        } else {
            grr.setMoreRowsPresent("FALSE");
        }
        if (result.getGRIDRESULT().getGRID().getDATA() != null && result.getGRIDRESULT().getGRID().getDATA().getROW() != null && result.getGRIDRESULT().getGRID().getDATA().getROW().size() > 0) {
            LinkedList<GridRequestRow> rows = new LinkedList<GridRequestRow>();
            for (DATA.ROW eamRow : result.getGRIDRESULT().getGRID().getDATA().getROW()) {
                List<GridRequestCell> cells = eamRow.getD().stream().map(eamCell -> {
                    if (gridFieldCache.get(gridRequest.getRequestKey()) == null || gridFieldCache.get(gridRequest.getRequestKey()).get(eamCell.getN()) == null) {
                        return new GridRequestCell(eamCell.getN().toString(), eamCell.getContent(), -99999, "UNKNOWN_TAGNAME");
                    }
                    GridField gridField = gridFieldCache.get(gridRequest.getRequestKey()).get(eamCell.getN());
                    return new GridRequestCell(eamCell.getN().toString(), this.decodeCellContent(gridField, eamCell.getContent()), gridField.getOrder(), gridField.getName());
                }).collect(Collectors.toList());
                cells = cells.stream().sorted(Comparator.comparing(GridRequestCell::getOrder)).collect(Collectors.toList());
                GridRequestRow row = new GridRequestRow();
                row.setId(eamRow.getId().toString());
                row.setCells(cells.toArray(new GridRequestCell[0]));
                rows.add(row);
            }
            grr.setRows(rows.toArray(new GridRequestRow[0]));
        } else {
            grr.setRows(new GridRequestRow[0]);
        }
        return grr;
    }

    public GridRequestResult executeQueryHeaderData(EAMContext context, GridRequest gridRequest) throws EAMException {
        net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001.FUNCTION_REQUEST_INFO funRequest = new net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001.FUNCTION_REQUEST_INFO();
        funRequest.setGRID(this.createGrid(gridRequest));
        if (gridRequest.getDataspyID() != null) {
            funRequest.setDATASPY(new DATASPY());
            funRequest.getDATASPY().setDATASPY_ID(new BigInteger(gridRequest.getDataspyID()));
        }
        if (gridRequest.getRowCount() != null && gridRequest.getRowCount() == 0) {
            funRequest.setREQUEST_TYPE(net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001.FUNCTION_REQUEST_TYPE.LIST___HEAD___ONLY___STORED);
        } else {
            funRequest.setREQUEST_TYPE(net.datastream.schemas.mp_functions.mp0118_getgridheaderdata_001.FUNCTION_REQUEST_TYPE.LIST___HEAD___DATA___STORED);
        }
        funRequest.setGRID_TYPE(this.createGridType(gridRequest));
        funRequest.setMULTIADDON_FILTERS(this.createGridFilters(gridRequest));
        funRequest.setADDON_SORT(this.createSort(gridRequest));
        funRequest.setLOV(this.createLovParams(gridRequest));
        MP0118_GetGridHeaderData_001 getgridd = new MP0118_GetGridHeaderData_001();
        getgridd.setFUNCTION_REQUEST_INFO(funRequest);
        getgridd.getFUNCTION_REQUEST_INFO().getGRID().setLOCALIZE_RESULT(DataTypeTools.encodeBoolean(context.getLocalizeResults(), BooleanType.TRUE_FALSE));
        MP0118_GetGridHeaderData_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getGridHeaderDataOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getgridd);
        GridRequestResult grr = new GridRequestResult();
        gridFieldCache.put(gridRequest.getRequestKey(), new ConcurrentHashMap());
        for (FIELD field2 : result.getGRIDRESULT().getGRID().getFIELDS().getFIELD()) {
            gridFieldCache.get(gridRequest.getRequestKey()).put(field2.getAliasnum(), this.decodeEAMGridField(field2));
        }
        grr.setGridCode(result.getGRIDRESULT().getGRID().getMETADATA().getGRIDID().toString());
        grr.setGridName(result.getGRIDRESULT().getGRID().getMETADATA().getGRIDNAME());
        grr.setDataSpyId(result.getGRIDRESULT().getDATASPY().getId());
        grr.setRecords(result.getGRIDRESULT().getGRID().getMETADATA().getRECORDS());
        grr.setCursorPosition(result.getGRIDRESULT().getGRID().getMETADATA().getCURRENTCURSORPOSITION().intValue());
        if (result.getGRIDRESULT().getGRID().getMETADATA().getMORERECORDPRESENT().equals("+")) {
            grr.setMoreRowsPresent("TRUE");
        } else {
            grr.setMoreRowsPresent("FALSE");
        }
        grr.setGridDataspies(result.getGRIDRESULT().getTOOLBAR().getFIELDVALUES().getROW().getDataspylist_Options().getOption().stream().map(option -> new GridDataspy((String)option.getValue().get(0), ((String)option.getValue().get(0)).equals(result.getGRIDRESULT().getDATASPY().getId()) ? result.getGRIDRESULT().getDATASPY().getLabel() : (String)option.getDisplay().get(0))).collect(Collectors.toList()));
        grr.setGridFields(result.getGRIDRESULT().getGRID().getFIELDS().getFIELD().stream().filter(field -> Integer.parseInt(field.getOrder()) >= 0).map(field -> this.decodeEAMGridField((FIELD)field)).collect(Collectors.toList()));
        if (result.getGRIDRESULT().getGRID().getDATA() != null && result.getGRIDRESULT().getGRID().getDATA().getROW() != null && result.getGRIDRESULT().getGRID().getDATA().getROW().size() > 0) {
            LinkedList<GridRequestRow> rows = new LinkedList<GridRequestRow>();
            for (DATA.ROW eamRow : result.getGRIDRESULT().getGRID().getDATA().getROW()) {
                List<GridRequestCell> cells = eamRow.getD().stream().map(eamCell -> new GridRequestCell(eamCell.getN().toString(), this.decodeCellContent(gridFieldCache.get(gridRequest.getRequestKey()).get(eamCell.getN()), eamCell.getContent()), gridFieldCache.get(gridRequest.getRequestKey()).get(eamCell.getN()).getOrder(), gridFieldCache.get(gridRequest.getRequestKey()).get(eamCell.getN()).getName())).collect(Collectors.toList());
                cells = cells.stream().sorted(Comparator.comparing(GridRequestCell::getOrder)).collect(Collectors.toList());
                GridRequestRow row = new GridRequestRow();
                row.setId(eamRow.getId().toString());
                row.setCells(cells.toArray(new GridRequestCell[0]));
                rows.add(row);
            }
            grr.setRows(rows.toArray(new GridRequestRow[0]));
        } else {
            grr.setRows(new GridRequestRow[0]);
        }
        return grr;
    }

    private GRID createGrid(GridRequest gridRequest) throws EAMException {
        GRID grid = new GRID();
        if (gridRequest.getCursorPosition() != null) {
            grid.setCURSOR_POSITION(BigInteger.valueOf(gridRequest.getCursorPosition().intValue()));
        } else {
            grid.setCURSOR_POSITION(BigInteger.valueOf(1L));
        }
        if (gridRequest.getGridName() == null) {
            throw Tools.generateFault("Please supply grid name.");
        }
        grid.setGRID_NAME(gridRequest.getGridName());
        if (gridRequest.getGridID() != null) {
            grid.setGRID_ID(new BigInteger(gridRequest.getGridID()));
        }
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(gridRequest.getUserFunctionName())) {
            grid.setUSER_FUNCTION_NAME(gridRequest.getUserFunctionName());
        }
        if (gridRequest.getRowCount() != null) {
            grid.setNUMBER_OF_ROWS_FIRST_RETURNED(BigInteger.valueOf(gridRequest.getRowCount().intValue()));
        } else {
            grid.setNUMBER_OF_ROWS_FIRST_RETURNED(BigInteger.valueOf(100L));
        }
        grid.setTERSERESPONSE("false");
        return grid;
    }

    private MULTIADDON_FILTERS createGridFilters(GridRequest gridRequest) {
        MULTIADDON_FILTERS multiaddon_filters = new MULTIADDON_FILTERS();
        if (gridRequest.getGridRequestFilters() != null && !gridRequest.getGridRequestFilters().isEmpty()) {
            int counter = 0;
            block18: for (GridRequestFilter filter : gridRequest.getGridRequestFilters()) {
                if ("IN".equals(filter.getOperator())) {
                    counter = this.createInGridFilter(multiaddon_filters, filter, counter);
                    continue;
                }
                MULTIADDON_FILTERS.MADDON_FILTER eamFilter = new MULTIADDON_FILTERS.MADDON_FILTER();
                eamFilter.setSEQNUM(BigInteger.valueOf(counter++));
                if (filter.getJoiner() != null) {
                    eamFilter.setJOINER(filter.getJoiner().getEamValue());
                }
                eamFilter.setOPERATOR(filter.getOperator());
                eamFilter.setALIAS_NAME(filter.getFieldName());
                this.getFilterValue(filter).ifPresent(arg_0 -> ((MULTIADDON_FILTERS.MADDON_FILTER)eamFilter).setVALUE(arg_0));
                eamFilter.setLPAREN(this.tools.getDataTypeTools().decodeBoolean(filter.getLeftParenthesis()));
                eamFilter.setRPAREN(this.tools.getDataTypeTools().decodeBoolean(filter.getRightParenthesis()));
                switch (eamFilter.getOPERATOR()) {
                    case "EQUALS": {
                        eamFilter.setOPERATOR("=");
                        break;
                    }
                    case "LESS_THAN": {
                        eamFilter.setOPERATOR("<");
                        break;
                    }
                    case "GREATER_THAN": {
                        eamFilter.setOPERATOR(">");
                        break;
                    }
                    case "LESS_THAN_EQUALS": {
                        eamFilter.setOPERATOR("<=");
                        break;
                    }
                    case "SELECTED": {
                        eamFilter.setOPERATOR("=");
                        eamFilter.setVALUE("-1");
                        break;
                    }
                    case "NOT_SELECTED": {
                        eamFilter.setOPERATOR("=");
                        eamFilter.setVALUE("0");
                        break;
                    }
                    case "": {
                        continue block18;
                    }
                }
                multiaddon_filters.getMADDON_FILTER().add(eamFilter);
            }
        }
        return multiaddon_filters;
    }

    private LOV createLovParams(GridRequest gridRequest) {
        LOV lov = new LOV();
        lov.setLOV_PARAMETERS(new LOV.LOV_PARAMETERS());
        gridRequest.getParams().forEach((paramName, paramValue) -> {
            LOV.LOV_PARAMETERS.LOV_PARAMETER lovParameter = new LOV.LOV_PARAMETERS.LOV_PARAMETER();
            lovParameter.setTYPE("VARCHAR");
            lovParameter.setALIAS_NAME(paramName);
            if (paramValue != null) {
                lovParameter.setVALUE(paramValue);
            }
            lov.getLOV_PARAMETERS().getLOV_PARAMETER().add(lovParameter);
        });
        return lov;
    }

    private ADDON_SORT createSort(GridRequest gridRequest) {
        if (gridRequest.getGridRequestSorts() != null && gridRequest.getGridRequestSorts().length > 0) {
            ADDON_SORT addon_sort = new ADDON_SORT();
            GridRequestSort sort = gridRequest.getGridRequestSorts()[0];
            SORT_TYPE sortType = "DESC".equalsIgnoreCase(sort.getSortType()) ? SORT_TYPE.DESC : SORT_TYPE.ASC;
            addon_sort.setTYPE(sortType);
            addon_sort.setALIAS_NAME(sort.getSortBy());
            return addon_sort;
        }
        return null;
    }

    private GRID_TYPE createGridType(GridRequest gridRequest) {
        GRID_TYPE grid_type = new GRID_TYPE();
        if (gridRequest.getGridType() == null || gridRequest.getGridType() == GridRequest.GRIDTYPE.LIST) {
            grid_type.setTYPE(GRID_TYPE_Type.LIST);
        } else {
            grid_type.setTYPE(GRID_TYPE_Type.LOV);
        }
        return grid_type;
    }

    private String decodeCellContent(GridField gridField, String content) {
        switch (gridField.getDataType()) {
            case "CHKBOOLEAN": {
                if ("true".equalsIgnoreCase(content) || "+".equalsIgnoreCase(content) || "Yes".equalsIgnoreCase(content) || "-1".equalsIgnoreCase(content)) {
                    return "true";
                }
                return "false";
            }
        }
        return content;
    }

    private int createInGridFilter(MULTIADDON_FILTERS multiaddon_filters, GridRequestFilter gridRequestFilter, int counter) {
        if (gridRequestFilter.getLeftParenthesis().booleanValue()) {
            counter = this.addDumbParenthesisFilter(multiaddon_filters, counter, gridRequestFilter, true);
        }
        AtomicInteger counterWrapper = new AtomicInteger(counter);
        this.getFilterValue(gridRequestFilter).ifPresent(values -> {
            String[] splitValues = values.split(",");
            for (int i = 0; i < splitValues.length; ++i) {
                boolean isFirst = i == 0;
                boolean isLast = i == splitValues.length - 1;
                MULTIADDON_FILTERS.MADDON_FILTER filter = new MULTIADDON_FILTERS.MADDON_FILTER();
                filter.setSEQNUM(BigInteger.valueOf(counterWrapper.getAndIncrement()));
                filter.setOPERATOR(Operator.EQUALS.getValue());
                filter.setALIAS_NAME(gridRequestFilter.getFieldName());
                filter.setVALUE(splitValues[i]);
                Optional.ofNullable(isLast ? gridRequestFilter.getJoiner() : GridRequestFilter.JOINER.OR).ifPresent(joiner -> filter.setJOINER(joiner.getEamValue()));
                if (isFirst) {
                    filter.setLPAREN(this.tools.getDataTypeTools().decodeBoolean(Boolean.TRUE));
                }
                if (isLast) {
                    filter.setRPAREN(this.tools.getDataTypeTools().decodeBoolean(Boolean.TRUE));
                }
                multiaddon_filters.getMADDON_FILTER().add(filter);
            }
        });
        counter = counterWrapper.get();
        if (gridRequestFilter.getRightParenthesis().booleanValue()) {
            counter = this.addDumbParenthesisFilter(multiaddon_filters, counter, gridRequestFilter, false);
        }
        return counter;
    }

    private int addDumbParenthesisFilter(MULTIADDON_FILTERS multiaddon_filters, int counter, GridRequestFilter gridRequestFilter, boolean isLeft) {
        MULTIADDON_FILTERS.MADDON_FILTER parenthesisFilter = new MULTIADDON_FILTERS.MADDON_FILTER();
        parenthesisFilter.setSEQNUM(BigInteger.valueOf(counter++));
        Optional.ofNullable(isLeft ? GridRequestFilter.JOINER.AND : gridRequestFilter.getJoiner()).ifPresent(joiner -> parenthesisFilter.setJOINER(joiner.getEamValue()));
        parenthesisFilter.setOPERATOR(Operator.NOT_EMPTY.getValue());
        parenthesisFilter.setALIAS_NAME(gridRequestFilter.getFieldName());
        if (isLeft) {
            parenthesisFilter.setLPAREN(this.tools.getDataTypeTools().decodeBoolean(Boolean.TRUE));
        } else {
            parenthesisFilter.setRPAREN(this.tools.getDataTypeTools().decodeBoolean(Boolean.TRUE));
        }
        multiaddon_filters.getMADDON_FILTER().add(parenthesisFilter);
        return counter;
    }

    private Optional<String> getFilterValue(GridRequestFilter filter) {
        Optional<String> filterValue = Optional.empty();
        try {
            filterValue = Optional.ofNullable(this.applicationData.isEncodeGridFilter() && filter.getFieldValue() != null ? URLEncoder.encode(filter.getFieldValue(), "UTF-8") : filter.getFieldValue());
        }
        catch (UnsupportedEncodingException e) {
            this.tools.log(Level.WARNING, e.getMessage());
        }
        return filterValue;
    }

    private GridField decodeEAMGridField(FIELD field) {
        GridField gridField = new GridField();
        if (field.getType() != null) {
            gridField.setDataType(field.getType().value());
        }
        gridField.setId(field.getAliasnum().toString());
        gridField.setName(field.getName());
        gridField.setOrder(Integer.parseInt(field.getOrder()));
        gridField.setWidth(field.getWidth());
        gridField.setLabel(field.getLabel());
        gridField.setVisible(DataTypeTools.decodeBoolean(field.getVisible()));
        return gridField;
    }
}

