/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.entities;

import ch.cern.eam.wshub.core.adapters.BigDecimalAdapter;
import ch.cern.eam.wshub.core.adapters.BooleanAdapter;
import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.annotations.EAMField;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListHelpable;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

@Entity
@Table(name="R5PARTS")
public class Part
implements Serializable,
UserDefinedListHelpable {
    private static final long serialVersionUID = 7865040704362527306L;
    @Id
    @Column(name="PAR_CODE")
    @EAMField(xpath={"PARTID/PARTCODE"})
    private String code;
    @Transient
    private String newCode;
    @Column(name="PAR_DESC")
    @EAMField(xpath={"PARTID/DESCRIPTION"})
    private String description;
    @Column(name="PAR_ORG")
    @EAMField(xpath={"PARTID/ORGANIZATIONID/ORGANIZATIONCODE"})
    private String organization;
    @Column(name="PAR_UOM")
    @EAMField(xpath={"UOMID/UOMCODE"})
    private String UOM;
    @Transient
    @EAMField(xpath={"UOMID/DESCRIPTION"}, readOnly=true)
    private String UOMDesc;
    @Column(name="PAR_CLASS")
    @EAMField(xpath={"CLASSID/CLASSCODE"})
    private String classCode;
    @Transient
    @EAMField(xpath={"CLASSID/DESCRIPTION"}, readOnly=true)
    private String classDesc;
    @Transient
    @EAMField(xpath={"CATEGORYID/CATEGORYCODE"})
    private String categoryCode;
    @Transient
    @EAMField(xpath={"CATEGORYID/DESCRIPTION"}, readOnly=true)
    private String categoryDesc;
    @Transient
    @EAMField(xpath={"PRIMARYCOMMODITY/COMMODITYCODE"})
    private String commodityCode;
    @Transient
    @EAMField(xpath={"PRIMARYCOMMODITY/DESCRIPTION"}, readOnly=true)
    private String commodityDesc;
    @Transient
    @EAMField(xpath={"TRACKMETHOD/TYPECODE"})
    private String trackingMethod;
    @Transient
    @EAMField(xpath={"PRICETYPE/TYPECODE"})
    private String priceType;
    @Transient
    @EAMField(xpath={"BASEPRICE"})
    private BigDecimal basePrice;
    @Transient
    @EAMField(xpath={"AVERAGEPRICE"})
    private BigDecimal averagePrice;
    @Transient
    @EAMField(xpath={"STANDARDPRICE"})
    private BigDecimal standardPrice;
    @Transient
    @EAMField(xpath={"LASTPRICE"})
    private BigDecimal lastPrice;
    @Transient
    @EAMField(xpath={"BYASSET"}, booleanType=BooleanType.PLUS_MINUS)
    private Boolean trackByAsset;
    @Transient
    @EAMField(xpath={"KIT"})
    private Boolean trackAsKit;
    @Transient
    @EAMField(xpath={"REPAIRABLE"})
    private Boolean trackCores;
    @Transient
    @EAMField(xpath={"OUTOFSERVICE"})
    private Boolean outOfService;
    @Transient
    @EAMField(xpath={"BYLOT"}, booleanType=BooleanType.PLUS_MINUS)
    private Boolean trackByLot;
    @Transient
    @EAMField(xpath={"PREVENTREORDERS"})
    private Boolean preventReorders;
    @Transient
    @EAMField(xpath={"BUYER/USERCODE"})
    private String buyerCode;
    @Transient
    @EAMField(xpath={"PREFERREDSUPPLIER/SUPPLIERCODE"})
    private String preferredSupplier;
    @Transient
    @EAMField(xpath={"LONGDESCRIPTION"})
    private String longDescription;
    @Transient
    @EAMField(xpath={"USERDEFINEDAREA"})
    private CustomField[] customFields;
    @Transient
    @EAMField(xpath={"UserDefinedFields"})
    private UserDefinedFields userDefinedFields;
    @Transient
    private String copyFrom;
    @Transient
    private HashMap<String, ArrayList<UDLValue>> userDefinedList;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUOM() {
        return this.UOM;
    }

    public void setUOM(String uOM) {
        this.UOM = uOM;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = classCode;
    }

    @JsonProperty(value="customField")
    @XmlElementWrapper(name="customFields")
    @XmlElement(name="customField")
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getTrackingMethod() {
        return this.trackingMethod;
    }

    public void setTrackingMethod(String trackingMethod) {
        this.trackingMethod = trackingMethod;
    }

    public String getPriceType() {
        return this.priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getBasePrice() {
        return this.basePrice;
    }

    public void setBasePrice(BigDecimal basePrice) {
        this.basePrice = basePrice;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(BigDecimal averagePrice) {
        this.averagePrice = averagePrice;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getStandardPrice() {
        return this.standardPrice;
    }

    public void setStandardPrice(BigDecimal standardPrice) {
        this.standardPrice = standardPrice;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getLastPrice() {
        return this.lastPrice;
    }

    public void setLastPrice(BigDecimal lastPrice) {
        this.lastPrice = lastPrice;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getTrackByAsset() {
        return this.trackByAsset;
    }

    public void setTrackByAsset(Boolean trackByAsset) {
        this.trackByAsset = trackByAsset;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getTrackAsKit() {
        return this.trackAsKit;
    }

    public void setTrackAsKit(Boolean trackAsKit) {
        this.trackAsKit = trackAsKit;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getTrackCores() {
        return this.trackCores;
    }

    public void setTrackCores(Boolean trackCores) {
        this.trackCores = trackCores;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getOutOfService() {
        return this.outOfService;
    }

    public void setOutOfService(Boolean outOfService) {
        this.outOfService = outOfService;
    }

    public String getBuyerCode() {
        return this.buyerCode;
    }

    public void setBuyerCode(String buyerCode) {
        this.buyerCode = buyerCode;
    }

    public String getPreferredSupplier() {
        return this.preferredSupplier;
    }

    public void setPreferredSupplier(String preferredSupplier) {
        this.preferredSupplier = preferredSupplier;
    }

    public UserDefinedFields getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public void setUserDefinedFields(UserDefinedFields userDefinedFields) {
        this.userDefinedFields = userDefinedFields;
    }

    public String getNewCode() {
        return this.newCode;
    }

    public void setNewCode(String newCode) {
        this.newCode = newCode;
    }

    public String getUOMDesc() {
        return this.UOMDesc;
    }

    public void setUOMDesc(String uOMDesc) {
        this.UOMDesc = uOMDesc;
    }

    public String getClassDesc() {
        return this.classDesc;
    }

    public void setClassDesc(String classDesc) {
        this.classDesc = classDesc;
    }

    public String getCategoryDesc() {
        return this.categoryDesc;
    }

    public void setCategoryDesc(String categoryDesc) {
        this.categoryDesc = categoryDesc;
    }

    public String getCommodityCode() {
        return this.commodityCode;
    }

    public void setCommodityCode(String commodityCode) {
        this.commodityCode = commodityCode;
    }

    public String getCommodityDesc() {
        return this.commodityDesc;
    }

    public void setCommodityDesc(String commodityDesc) {
        this.commodityDesc = commodityDesc;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public Boolean getTrackByLot() {
        return this.trackByLot;
    }

    public void setTrackByLot(Boolean trackByLot) {
        this.trackByLot = trackByLot;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getPreventReorders() {
        return this.preventReorders;
    }

    public void setPreventReorders(Boolean preventReorders) {
        this.preventReorders = preventReorders;
    }

    @Override
    public String getCopyFrom() {
        return this.copyFrom;
    }

    public void setCopyFrom(String copyFrom) {
        this.copyFrom = copyFrom;
    }

    @Override
    public HashMap<String, ArrayList<UDLValue>> getUserDefinedList() {
        return this.userDefinedList;
    }

    @Override
    public void setUserDefinedList(HashMap<String, ArrayList<UDLValue>> userDefinedList) {
        this.userDefinedList = userDefinedList;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String toString() {
        return "Part{code='" + this.code + "', newCode='" + this.newCode + "', description='" + this.description + "', UOM='" + this.UOM + "', UOMDesc='" + this.UOMDesc + "', classCode='" + this.classCode + "', classDesc='" + this.classDesc + "', categoryCode='" + this.categoryCode + "', categoryDesc='" + this.categoryDesc + "', commodityCode='" + this.commodityCode + "', commodityDesc='" + this.commodityDesc + "', trackingMethod='" + this.trackingMethod + "', priceType='" + this.priceType + "', basePrice='" + String.valueOf(this.basePrice) + "', averagePrice='" + String.valueOf(this.averagePrice) + "', standardPrice='" + String.valueOf(this.standardPrice) + "', lastPrice='" + String.valueOf(this.lastPrice) + "', trackByAsset='" + this.trackByAsset + "', trackAsKit='" + this.trackAsKit + "', trackCores='" + this.trackCores + "', outOfService='" + this.outOfService + "', trackByLot='" + this.trackByLot + "', preventReorders='" + this.preventReorders + "', buyerCode='" + this.buyerCode + "', preferredSupplier='" + this.preferredSupplier + "', longDescription='" + this.longDescription + "', customFields=" + Arrays.toString(this.customFields) + ", userDefinedFields=" + String.valueOf(this.userDefinedFields) + ", copyFrom='" + this.copyFrom + "', userDefinedList='" + String.valueOf(this.userDefinedList) + "'}";
    }
}

