/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens;

import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedTableValidator;
import ch.cern.eam.wshub.core.tools.EAMException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UserDefinedTableQueries {
    private static final Map<String, Class<?>> DATA_TYPE_CLASS_MAP = new HashMap();
    private static final String GET_TABLE_TYPES = "SELECT column_name, DECODE(data_type, 'NUMBER', CASE WHEN DATA_SCALE = 0 THEN 'NUMBER' ELSE 'DECIMAL' END, data_type) AS datatype FROM user_tab_columns WHERE table_name = UPPER(:tableName)";

    public static <T> void executeInsertQuery(String tableName, Map<String, T> map, EntityManager em) throws EAMException {
        String query = UserDefinedTableQueries.getInsertQuery(tableName, map);
        try {
            Query nativeQuery = em.createNativeQuery(query);
            map.keySet().stream().filter(s -> map.get(s) != null).forEach(column -> nativeQuery.setParameter(column, map.get(column)));
            nativeQuery.executeUpdate();
        }
        catch (PersistenceException e) {
            throw UserDefinedTableValidator.generateEAMException("", e.getMessage());
        }
    }

    private static <T> String getInsertQuery(String tableName, Map<String, T> map) {
        ArrayList<String> orderedColumnNames = new ArrayList<String>(map.keySet());
        String columnNames = UserDefinedTableQueries.getColumnNames(orderedColumnNames);
        String sbArguments = orderedColumnNames.stream().collect(StringBuilder::new, (builder, n) -> builder.append(", ").append((String)(map.get(n) == null ? "NULL" : ":" + n)), StringBuilder::append).substring(2);
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append(tableName);
        query.append(" (").append(columnNames).append(")");
        query.append(" VALUES (");
        query.append(sbArguments);
        query.append(")");
        return query.toString();
    }

    public static <T> List<Map<String, Object>> executeReadQuery(String tableName, Map<String, T> whereFiltersMap, List<String> fieldsToRead, Long maxRows, EntityManager em) throws EAMException {
        String query = UserDefinedTableQueries.getReadQuery(tableName, whereFiltersMap, fieldsToRead, maxRows);
        try {
            Query nativeQuery = UserDefinedTableQueries.createQuery(query, new HashMap(), whereFiltersMap, em);
            List resultList = nativeQuery.getResultList();
            List collect = resultList.stream().map(s -> {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (int i = 0; i < fieldsToRead.size(); ++i) {
                    map.put(((String)fieldsToRead.get(i)).toUpperCase(), s[i]);
                }
                return map;
            }).collect(Collectors.toList());
            Map<String, Class<?>> columnTypes = UserDefinedTableQueries.getColumnTypes(tableName, em);
            ArrayList<Map<String, Object>> lista = new ArrayList<Map<String, Object>>();
            for (Map s2 : collect) {
                Map<String, Object> stringObjectMap = UserDefinedTableQueries.castObjects(s2, columnTypes);
                lista.add(stringObjectMap);
            }
            return lista;
        }
        catch (PersistenceException e) {
            throw UserDefinedTableValidator.generateEAMException("", e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static <T, U> U castType(T entity, Class<U> clazz) throws EAMException {
        try {
            if (entity instanceof Clob) {
                int ch;
                Reader r = ((Clob)entity).getCharacterStream();
                StringBuffer buffer = new StringBuffer();
                while ((ch = r.read()) != -1) {
                    buffer.append("" + (char)ch);
                }
                return (U)buffer.toString();
            }
            if (entity instanceof Timestamp) {
                return (U)new Date(((Timestamp)entity).getTime());
            }
            if (entity instanceof BigDecimal && clazz.equals(BigInteger.class)) {
                return (U)new BigInteger(String.valueOf(entity));
            }
            return (U)entity;
        }
        catch (Exception e) {
            throw UserDefinedTableValidator.generateEAMException("", "Cannot cast " + String.valueOf(entity) + " to " + clazz.getName());
        }
    }

    public static Map<String, Class<?>> getColumnTypes(String tableName, EntityManager em) throws EAMException {
        try {
            Query nativeQuery = em.createNativeQuery(GET_TABLE_TYPES);
            nativeQuery.setParameter("tableName", (Object)tableName);
            List resultList = nativeQuery.getResultList();
            Map<String, Class<?>> classMap = resultList.stream().collect(Collectors.toMap(s -> String.valueOf(s[0]), s -> DATA_TYPE_CLASS_MAP.computeIfAbsent(String.valueOf(s[1]), key -> String.class)));
            return classMap;
        }
        catch (PersistenceException e) {
            throw UserDefinedTableValidator.generateEAMException("", e.getMessage());
        }
    }

    private static Map<String, Object> castObjects(Map<String, Object> map, Map<String, Class<?>> classMap) throws EAMException {
        LinkedHashMap<String, Object> collect = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object o = UserDefinedTableQueries.castType(entry.getValue(), classMap.get(entry.getKey()));
            collect.put(entry.getKey(), o);
        }
        return collect;
    }

    private static <T> String getReadQuery(String tableName, Map<String, T> whereFilters, List<String> fieldsToRead, Long maxRows) {
        String filters = UserDefinedTableQueries.getWhereFilters(whereFilters);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(UserDefinedTableQueries.getColumnNames(fieldsToRead.stream().map(String::toUpperCase).collect(Collectors.toList())));
        query.append(" FROM ");
        query.append(tableName);
        query.append(" WHERE ( 1=1").append(filters).append(" )");
        if (maxRows != null) {
            query.append(" AND ROWNUM < " + maxRows);
        }
        return query.toString();
    }

    public static <T> int executeUpdateQuery(String tableName, Map<String, T> updateColumns, Map<String, T> whereFilters, EntityManager em) throws EAMException {
        String query = UserDefinedTableQueries.getUpdateQuery(tableName, updateColumns, whereFilters);
        try {
            Query nativeQuery = UserDefinedTableQueries.createQuery(query, updateColumns, whereFilters, em);
            return nativeQuery.executeUpdate();
        }
        catch (PersistenceException e) {
            throw UserDefinedTableValidator.generateEAMException("", e.getMessage());
        }
    }

    private static <T> String getUpdateQuery(String tableName, Map<String, T> updateColumns, Map<String, T> whereFilters) {
        Function<String, String> updateArgumentsSupplier = UserDefinedTableQueries.getParameter(updateColumns, UserDefinedTableQueries::getFilterParameter);
        String update = updateColumns.keySet().stream().map(UserDefinedTableQueries.getParameter(updateColumns, UserDefinedTableQueries::getSetValue)).collect(Collectors.joining()).substring(2);
        String filters = UserDefinedTableQueries.getWhereFilters(whereFilters);
        StringBuilder query = new StringBuilder();
        query.append("UPDATE ");
        query.append(tableName);
        query.append(" SET ");
        query.append(update);
        query.append(" WHERE ( 1=1").append(filters).append(")");
        return query.toString();
    }

    public static <T> int executeDeleteQuery(String tableName, Map<String, T> whereFilters, EntityManager em) throws EAMException {
        String query = UserDefinedTableQueries.getDeleteQuery(tableName, whereFilters);
        try {
            Query nativeQuery = UserDefinedTableQueries.createQuery(query, new HashMap(), whereFilters, em);
            return nativeQuery.executeUpdate();
        }
        catch (PersistenceException e) {
            throw UserDefinedTableValidator.generateEAMException("", e.getMessage());
        }
    }

    private static String getColumnNames(List<String> columnNameList) {
        String columnNames = columnNameList.stream().collect(StringBuilder::new, (builder, n) -> builder.append(", \"").append((String)n).append("\""), StringBuilder::append).substring(2);
        return columnNames;
    }

    private static <T> Query createQuery(String query, Map<String, T> updateParameters, Map<String, T> filterParameters, EntityManager em) {
        Query nativeQuery = em.createNativeQuery(query);
        updateParameters.keySet().stream().filter(s -> updateParameters.get(s) != null).forEach(column -> nativeQuery.setParameter(UserDefinedTableQueries.getSetParameterName(column), updateParameters.get(column)));
        filterParameters.keySet().stream().filter(s -> filterParameters.get(s) != null).forEach(column -> nativeQuery.setParameter(UserDefinedTableQueries.getFilterParameterName(column), filterParameters.get(column)));
        return nativeQuery;
    }

    private static <T> String getDeleteQuery(String tableName, Map<String, T> whereFilters) {
        String whereString = UserDefinedTableQueries.getWhereFilters(whereFilters);
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ");
        query.append(tableName);
        query.append(" WHERE ( 1=1").append(whereString).append(")");
        return query.toString();
    }

    private static <T> String getWhereFilters(Map<String, T> whereFilters) {
        return whereFilters.keySet().stream().map(UserDefinedTableQueries.getParameter(whereFilters, UserDefinedTableQueries::getFilterParameter)).collect(Collectors.joining());
    }

    private static <T, R extends String> String getFilterParameter(R columnName, T value) {
        return " AND \"" + columnName + "\"" + (String)(value == null ? " IS NULL" : " = :" + UserDefinedTableQueries.getFilterParameterName(columnName));
    }

    private static <R> String getFilterParameterName(R columnName) {
        return "F_" + String.valueOf(columnName);
    }

    private static <T, R> String getSetParameter(R columnName, T value) {
        return ", \"" + String.valueOf(columnName) + "\"" + (String)(value == null ? " IS NULL" : " = :" + UserDefinedTableQueries.getSetParameterName(columnName));
    }

    private static <T, R> String getSetValue(R columnName, T value) {
        return ", \"" + String.valueOf(columnName) + "\"" + (String)(value == null ? " = NULL" : " = :" + UserDefinedTableQueries.getSetParameterName(columnName));
    }

    private static <R> String getSetParameterName(R columnName) {
        return "S_" + String.valueOf(columnName);
    }

    private static <T, R> Function<R, R> getParameter(Map<R, T> map, BiFunction<R, T, R> fun) {
        return parameterName -> fun.apply(parameterName, map.get(parameterName));
    }

    static {
        DATA_TYPE_CLASS_MAP.put("VARCHAR2", String.class);
        DATA_TYPE_CLASS_MAP.put("NUMBER", BigInteger.class);
        DATA_TYPE_CLASS_MAP.put("DECIMAL", BigDecimal.class);
        DATA_TYPE_CLASS_MAP.put("DATE", Date.class);
        DATA_TYPE_CLASS_MAP.put("CLOB", String.class);
    }
}

