/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.jdbc;

import ch.cern.eam.wshub.core.services.entities.Credentials;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedPreparedStatement {
    private final PreparedStatement statement;
    private final Map indexMap = new HashMap();

    public NamedPreparedStatement(Connection connection, String query) throws SQLException {
        String parsedQuery = NamedPreparedStatement.parse(query, this.indexMap);
        this.statement = connection.prepareStatement(parsedQuery);
    }

    static final String parse(String query, Map paramMap) {
        int length = query.length();
        StringBuffer parsedQuery = new StringBuffer(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            int n = query.charAt(i);
            if (inSingleQuote) {
                if (n == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (n == 34) {
                    inDoubleQuote = false;
                }
            } else if (n == 39) {
                inSingleQuote = true;
            } else if (n == 34) {
                inDoubleQuote = true;
            } else if (n == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
                }
                String name = query.substring(i + 1, j);
                n = 63;
                i += name.length();
                LinkedList<Integer> indexList = (LinkedList<Integer>)paramMap.get(name);
                if (indexList == null) {
                    indexList = new LinkedList<Integer>();
                    paramMap.put(name, indexList);
                }
                indexList.add(index);
                ++index;
            }
            parsedQuery.append((char)n);
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            List list = (List)entry.getValue();
            int[] indexes = new int[list.size()];
            int i = 0;
            for (Integer x : list) {
                indexes[i++] = x;
            }
            entry.setValue(indexes);
        }
        return parsedQuery.toString();
    }

    private int[] getIndexes(String name) {
        int[] indexes = (int[])this.indexMap.get(name);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter not found: " + name);
        }
        return indexes;
    }

    public void setObject(String name, Object value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setObject(indexes[i], value);
        }
    }

    public void setString(String name, String value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setString(indexes[i], value);
        }
    }

    public void setInt(String name, int value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setInt(indexes[i], value);
        }
    }

    public void setLong(String name, long value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setLong(indexes[i], value);
        }
    }

    public void setTimestamp(String name, Timestamp value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setTimestamp(indexes[i], value);
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public boolean execute() throws SQLException {
        return this.statement.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    public void defineParamters(String gridName, String sqlStatement, NamedPreparedStatement p, Credentials credentials, Map<String, Object> params) throws SQLException {
        if (sqlStatement.contains(":r5user")) {
            p.setString("r5user", credentials.getUsername().toUpperCase());
        }
        if (sqlStatement.contains(":deptsec")) {
            p.setString("deptsec", "OFF");
        }
        if (sqlStatement.contains(":storesec")) {
            p.setString("storesec", "ON");
        }
        if (sqlStatement.contains(":language")) {
            p.setString("language", "EN");
        }
        if (sqlStatement.contains(":userfunction") && params.get("userfunction") == null) {
            p.setString("userfunction", gridName);
        }
        if (sqlStatement.contains(":syskit2")) {
            p.setString("syskit2", "EO");
        }
        if (sqlStatement.contains(":bypassstatuscheck")) {
            p.setObject("bypassstatuscheck", null);
        }
        if (sqlStatement.contains(":bypassdeptsecurity")) {
            p.setObject("bypassdeptsecurity", null);
        }
        if (sqlStatement.contains(":excludeparentpart")) {
            p.setString("excludeparentpart", "true");
        }
        for (String par : params.keySet()) {
            if (!sqlStatement.contains(":" + par)) continue;
            if (params.get(par) instanceof String) {
                p.setString(par, params.get(par) != null ? (String)params.get(par) : null);
                continue;
            }
            if (params.get(par) instanceof Integer) {
                p.setInt(par, params.get(par) != null ? (Integer)params.get(par) : null);
                continue;
            }
            if (params.get(par) instanceof Long) {
                p.setLong(par, params.get(par) != null ? (Long)params.get(par) : null);
                continue;
            }
            if (params.get(par) instanceof Date) {
                p.setTimestamp(par, params.get(par) != null ? new Timestamp(((Date)params.get(par)).getTime()) : null);
                continue;
            }
            p.setObject(par, params.get(par) != null ? params.get(par) : null);
        }
    }
}

