/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.material.PartBinStockService;
import ch.cern.eam.wshub.core.services.material.entities.PartStock;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.binstock_001.BinStock;
import net.datastream.schemas.mp_fields.BINSTOCKID;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_functions.mp0248_001.MP0248_AddBinStock_001;
import net.datastream.schemas.mp_functions.mp0249_001.MP0249_SyncBinStock_001;
import net.datastream.schemas.mp_functions.mp0250_001.MP0250_GetBinStock_001;
import net.datastream.schemas.mp_results.mp0250_001.MP0250_GetBinStock_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class PartBinStockServiceImpl
implements PartBinStockService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public PartBinStockServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public String addPartStock(EAMContext context, PartStock partStockParam) throws EAMException {
        BinStock binStock = new BinStock();
        if (partStockParam.getStoreCode() != null) {
            binStock.setSTOREID(new STOREID_Type());
            binStock.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            binStock.getSTOREID().setSTORECODE(partStockParam.getStoreCode().trim().toUpperCase());
        }
        if (partStockParam.getBin() != null) {
            binStock.setBIN(partStockParam.getBin());
        }
        if (partStockParam.getLot() != null) {
            binStock.setLOT(partStockParam.getLot());
        }
        if (partStockParam.getQtyOnHand() != null) {
            this.tools.getDataTypeTools();
            binStock.setQTYONHAND(DataTypeTools.encodeAmount(partStockParam.getQtyOnHand(), "Qty. On Hand"));
        }
        if (partStockParam.getPartCode() != null) {
            binStock.setPARTID(new PARTID_Type());
            binStock.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            binStock.getPARTID().setPARTCODE(partStockParam.getPartCode().trim().toUpperCase());
        }
        MP0248_AddBinStock_001 addbinstock = new MP0248_AddBinStock_001();
        addbinstock.setBinStock(binStock);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addBinStockOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addbinstock);
        return null;
    }

    @Override
    public String updatePartStock(EAMContext context, PartStock partStockParam) throws EAMException {
        if (partStockParam == null || partStockParam.getPartCode() == null || partStockParam.getStoreCode() == null || partStockParam.getBin() == null || partStockParam.getLot() == null) {
            throw Tools.generateFault("You must supply valid Part, Store, Bin and Lot in order to update the part stock");
        }
        MP0250_GetBinStock_001 getBinStock = new MP0250_GetBinStock_001();
        getBinStock.setBINSTOCKID(new BINSTOCKID());
        getBinStock.getBINSTOCKID().setPARTID(new PARTID_Type());
        getBinStock.getBINSTOCKID().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getBinStock.getBINSTOCKID().getPARTID().setPARTCODE(partStockParam.getPartCode());
        getBinStock.getBINSTOCKID().setLOT(partStockParam.getLot());
        getBinStock.getBINSTOCKID().setBIN(partStockParam.getBin());
        getBinStock.getBINSTOCKID().setSTOREID(new STOREID_Type());
        getBinStock.getBINSTOCKID().getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        getBinStock.getBINSTOCKID().getSTOREID().setSTORECODE(partStockParam.getStoreCode());
        MP0250_GetBinStock_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getBinStockOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getBinStock);
        MP0249_SyncBinStock_001 syncBinStock = new MP0249_SyncBinStock_001();
        syncBinStock.setBinStock(result.getResultData().getBinStock());
        if (partStockParam.getQtyOnHand() != null) {
            BinStock binStock = syncBinStock.getBinStock();
            this.tools.getDataTypeTools();
            binStock.setQTYONHAND(DataTypeTools.encodeAmount(partStockParam.getQtyOnHand(), "Qty. On Hand"));
        }
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncBinStockOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncBinStock);
        return null;
    }
}

