/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.material.PartKitService;
import ch.cern.eam.wshub.core.services.material.entities.BuildKitParam;
import ch.cern.eam.wshub.core.services.material.entities.PartKitTemplate;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import net.datastream.schemas.mp_entities.kitsession_001.KitSession;
import net.datastream.schemas.mp_entities.kittemplate_001.KitTemplate;
import net.datastream.schemas.mp_fields.BINID_Type;
import net.datastream.schemas.mp_fields.KITID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_functions.mp2227_001.MP2227_AddKitTemplate_001;
import net.datastream.schemas.mp_functions.mp2231_001.MP2231_CreateKitSession_001;
import net.datastream.schemas.mp_functions.mp2235_001.MP2235_CreateKit_001;
import net.datastream.schemas.mp_results.mp2231_001.MP2231_CreateKitSession_001_Result;
import net.datastream.schemas.mp_results.mp2235_001.MP2235_CreateKit_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;
import org.openapplications.oagis_segments.QUANTITY;

public class PartKitServiceImpl
implements PartKitService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public PartKitServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public String addPartKitTemplate(EAMContext context, PartKitTemplate partKitParam) throws EAMException {
        KitTemplate kitTemplate = new KitTemplate();
        kitTemplate.setKITID(new KITID_Type());
        if (partKitParam.getPartCode() != null) {
            kitTemplate.getKITID().setKITTEMPLATEPARTID(new PARTID_Type());
            kitTemplate.getKITID().getKITTEMPLATEPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            kitTemplate.getKITID().getKITTEMPLATEPARTID().setPARTCODE(partKitParam.getPartCode().trim().toUpperCase());
        }
        if (partKitParam.getKitTemplatePartCode() != null) {
            kitTemplate.getKITID().setPARTID(new PARTID_Type());
            kitTemplate.getKITID().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            kitTemplate.getKITID().getPARTID().setPARTCODE(partKitParam.getKitTemplatePartCode().trim().toUpperCase());
        }
        if (partKitParam.getUomCode() != null) {
            kitTemplate.setUOMCODE(partKitParam.getUomCode());
        }
        kitTemplate.setKITQUANTITY(new QUANTITY());
        kitTemplate.getKITQUANTITY().setNUMOFDEC(new BigDecimal(0).toBigInteger());
        kitTemplate.getKITQUANTITY().setSIGN("+");
        kitTemplate.getKITQUANTITY().setUOM("default");
        kitTemplate.getKITQUANTITY().setQualifier("OTHER");
        if (partKitParam.getQty() != null) {
            kitTemplate.getKITQUANTITY().setVALUE(new BigDecimal(partKitParam.getQty()));
        }
        MP2227_AddKitTemplate_001 addKitTemplate = new MP2227_AddKitTemplate_001();
        addKitTemplate.setKitTemplate(kitTemplate);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addKitTemplateOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addKitTemplate);
        return null;
    }

    @Override
    public String createKitSession(EAMContext context, BuildKitParam buildKitParam) throws EAMException {
        KitSession kitSession = new KitSession();
        kitSession.setBINID(new BINID_Type());
        kitSession.getBINID().setBIN(buildKitParam.getKitBin().toUpperCase().trim());
        kitSession.setDBSESSIONID(new QUANTITY());
        kitSession.getDBSESSIONID().setVALUE(new BigDecimal(0));
        kitSession.getDBSESSIONID().setNUMOFDEC(new BigDecimal(0).toBigInteger());
        kitSession.getDBSESSIONID().setSIGN("+");
        kitSession.getDBSESSIONID().setUOM("default");
        kitSession.getDBSESSIONID().setQualifier("OTHER");
        kitSession.setKITCOUNT(new QUANTITY());
        kitSession.getKITCOUNT().setVALUE(new BigDecimal(1));
        kitSession.getKITCOUNT().setNUMOFDEC(new BigDecimal(0).toBigInteger());
        kitSession.getKITCOUNT().setSIGN("+");
        kitSession.getKITCOUNT().setUOM("default");
        kitSession.getKITCOUNT().setQualifier("OTHER");
        kitSession.setLOTDESCRIPTION("*");
        kitSession.setPARTID(new PARTID_Type());
        kitSession.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        kitSession.getPARTID().setPARTCODE(buildKitParam.getPartKitCode().trim().toUpperCase());
        kitSession.setSTOREID(new STOREID_Type());
        kitSession.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        kitSession.getSTOREID().setSTORECODE(buildKitParam.getStoreCode().trim().toUpperCase());
        MP2231_CreateKitSession_001 kitSessionMsg = new MP2231_CreateKitSession_001();
        kitSessionMsg.setKitSession(kitSession);
        MP2231_CreateKitSession_001_Result r = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).createKitSessionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), kitSessionMsg);
        return r.getResultData().getDBSESSIONID().getVALUE().toString();
    }

    @Override
    public String buildKit(EAMContext context, String kitSessionId) throws EAMException {
        MP2235_CreateKit_001 createKitMsg = new MP2235_CreateKit_001();
        MP2235_CreateKit_001_Result createKitResult = new MP2235_CreateKit_001_Result();
        createKitMsg.setDBSESSIONID(new QUANTITY());
        createKitMsg.getDBSESSIONID().setVALUE(new BigDecimal(kitSessionId));
        createKitMsg.getDBSESSIONID().setNUMOFDEC(new BigDecimal(0).toBigInteger());
        createKitMsg.getDBSESSIONID().setSIGN("+");
        createKitMsg.getDBSESSIONID().setUOM("default");
        createKitMsg.getDBSESSIONID().setQualifier("OTHER");
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).createKitOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), createKitMsg);
        return createKitResult.getResultData().getDBSESSIONID().getVALUE().toString();
    }
}

