/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.workorders.SalesPriceService;
import ch.cern.eam.wshub.core.services.workorders.entities.SalesPrice;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.Date;
import net.datastream.schemas.mp_entities.customercontractsalesprice_001.CustomerContractSalesPrice;
import net.datastream.schemas.mp_fields.CUSTOMERCONTRACTSALESPRICEID_Type;
import net.datastream.schemas.mp_functions.mp7873_001.MP7873_GetCustomerContractSalesPrice_001;
import net.datastream.schemas.mp_functions.mp7874_001.MP7874_AddCustomerContractSalesPrice_001;
import net.datastream.schemas.mp_functions.mp7875_001.MP7875_SyncCustomerContractSalesPrice_001;
import net.datastream.schemas.mp_results.mp7873_001.MP7873_GetCustomerContractSalesPrice_001_Result;
import net.datastream.schemas.mp_results.mp7874_001.MP7874_AddCustomerContractSalesPrice_001_Result;
import net.datastream.schemas.mp_results.mp7875_001.MP7875_SyncCustomerContractSalesPrice_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class SalesPricesImpl
implements SalesPriceService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public SalesPricesImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public String createSalesPrice(EAMContext context, SalesPrice salesPrice) throws EAMException {
        if (DataTypeTools.isEmpty(salesPrice.getSalesPriceCode())) {
            salesPrice.setSalesPriceCode("");
        }
        if (salesPrice.getCustomerContractRevision() == null) {
            salesPrice.setCustomerContractRevision(BigDecimal.ZERO);
        }
        if (salesPrice.getDateExpired() == null) {
            salesPrice.setDateExpired(new Date(4102444799000L));
        }
        MP7874_AddCustomerContractSalesPrice_001 addSalesPrice = new MP7874_AddCustomerContractSalesPrice_001();
        addSalesPrice.setCustomerContractSalesPrice(new CustomerContractSalesPrice());
        this.tools.getEAMFieldTools().transformWSHubObject(addSalesPrice.getCustomerContractSalesPrice(), salesPrice, context);
        MP7874_AddCustomerContractSalesPrice_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addCustomerContractSalesPriceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addSalesPrice);
        return result.getResultData().getCUSTOMERCONTRACTSALESPRICEID().getCUSTOMERCONTRACTSALESPRICECODE();
    }

    @Override
    public String updateSalesPrice(EAMContext context, SalesPrice salesPrice) throws EAMException {
        MP7873_GetCustomerContractSalesPrice_001 getSalesPrice = new MP7873_GetCustomerContractSalesPrice_001();
        getSalesPrice.setCUSTOMERCONTRACTSALESPRICEID(new CUSTOMERCONTRACTSALESPRICEID_Type());
        getSalesPrice.getCUSTOMERCONTRACTSALESPRICEID().setCUSTOMERCONTRACTSALESPRICECODE(salesPrice.getSalesPriceCode());
        MP7873_GetCustomerContractSalesPrice_001_Result getSalesPriceResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getCustomerContractSalesPriceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getSalesPrice);
        CustomerContractSalesPrice salesPriceEAM = this.tools.getEAMFieldTools().transformWSHubObject(getSalesPriceResult.getResultData().getCustomerContractSalesPrice(), salesPrice, context);
        MP7875_SyncCustomerContractSalesPrice_001 syncSalesPrice = new MP7875_SyncCustomerContractSalesPrice_001();
        syncSalesPrice.setCustomerContractSalesPrice(salesPriceEAM);
        MP7875_SyncCustomerContractSalesPrice_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncCustomerContractSalesPriceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncSalesPrice);
        return result.getResultData().getCUSTOMERCONTRACTSALESPRICEID().getCUSTOMERCONTRACTSALESPRICECODE();
    }
}

