/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.material.PartStoreService;
import ch.cern.eam.wshub.core.services.material.entities.PartStore;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.partstores_001.PartStores;
import net.datastream.schemas.mp_fields.BINID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.STOREPARTID_Type;
import net.datastream.schemas.mp_fields.SUPPLIERID_Type;
import net.datastream.schemas.mp_functions.mp0254_001.MP0254_GetPartStores_001;
import net.datastream.schemas.mp_functions.mp0255_001.MP0255_AddPartStores_001;
import net.datastream.schemas.mp_functions.mp0256_001.MP0256_SyncPartStores_001;
import net.datastream.schemas.mp_results.mp0254_001.MP0254_GetPartStores_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class PartStoreServiceImpl
implements PartStoreService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public PartStoreServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public String updatePartStore(EAMContext context, PartStore partStoreParam) throws EAMException {
        MP0254_GetPartStores_001 getPartStores = new MP0254_GetPartStores_001();
        getPartStores.setSTOREPARTID(new STOREPARTID_Type());
        getPartStores.getSTOREPARTID().setPARTID(new PARTID_Type());
        getPartStores.getSTOREPARTID().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPartStores.getSTOREPARTID().getPARTID().setPARTCODE(partStoreParam.getPartCode());
        getPartStores.getSTOREPARTID().setSTOREID(new STOREID_Type());
        getPartStores.getSTOREPARTID().getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPartStores.getSTOREPARTID().getSTOREID().setSTORECODE(partStoreParam.getStoreCode());
        MP0254_GetPartStores_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getPartStoresOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPartStores);
        PartStores partStoresResult = result.getResultData().getPartStores();
        if (partStoreParam.getDefaultBin() != null) {
            partStoresResult.setDEFAULTBIN(new BINID_Type());
            partStoresResult.getDEFAULTBIN().setBIN(partStoreParam.getDefaultBin());
        }
        if (partStoreParam.getOrderQty() != null) {
            this.tools.getDataTypeTools();
            partStoresResult.setORDERQTY(DataTypeTools.encodeAmount(partStoreParam.getOrderQty(), "Ordery Qty."));
        }
        if (partStoreParam.getReorderLevel() != null) {
            this.tools.getDataTypeTools();
            partStoresResult.setREORDERLEVEL(DataTypeTools.encodeAmount(partStoreParam.getReorderLevel(), "Reorder Level"));
        }
        if (partStoreParam.getDefaultReturnBin() != null) {
            partStoresResult.setDEFAULTRETURNBIN(new BINID_Type());
            partStoresResult.getDEFAULTRETURNBIN().setBIN(partStoreParam.getDefaultReturnBin());
        }
        if (partStoreParam.getAbcClass() != null) {
            partStoresResult.setABCCODE(partStoreParam.getAbcClass());
        }
        if (partStoreParam.getPreferredSupplier() != null) {
            partStoresResult.setPREFERREDSUPPLIER(new SUPPLIERID_Type());
            partStoresResult.getPREFERREDSUPPLIER().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresResult.getPREFERREDSUPPLIER().setSUPPLIERCODE(partStoreParam.getPreferredSupplier());
        }
        if (partStoreParam.getPreventIssueFromDefaultReturnBin() != null) {
            partStoresResult.setPREVENTISSUEDEFRTNBIN(partStoreParam.getPreventIssueFromDefaultReturnBin());
        } else {
            partStoresResult.setPREVENTISSUEDEFRTNBIN("true");
        }
        if (partStoreParam.getPreferredStore() != null) {
            partStoresResult.setPREFERREDSTORE(new STOREID_Type());
            partStoresResult.getPREFERREDSTORE().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresResult.getPREFERREDSTORE().setSTORECODE(partStoreParam.getPreferredStore());
        }
        if (partStoreParam.getMinimumQty() != null) {
            this.tools.getDataTypeTools();
            partStoresResult.setMINIMUMQTY(DataTypeTools.encodeAmount(partStoreParam.getMinimumQty(), "Minimum Qty"));
        }
        if (partStoreParam.getStockMethod() != null) {
            partStoresResult.setONDEMAND(partStoreParam.getStockMethod());
        }
        MP0256_SyncPartStores_001 syncPartStores = new MP0256_SyncPartStores_001();
        syncPartStores.setPartStores(partStoresResult);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncPartStoresOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPartStores);
        return null;
    }

    @Override
    public String addPartStore(EAMContext context, PartStore partStoreParam) throws EAMException {
        PartStores partStoresEAM = new PartStores();
        if (partStoreParam.getPartCode() != null) {
            partStoresEAM.setPARTID(new PARTID_Type());
            partStoresEAM.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresEAM.getPARTID().setPARTCODE(partStoreParam.getPartCode());
        }
        if (partStoreParam.getDefaultBin() != null) {
            partStoresEAM.setDEFAULTBIN(new BINID_Type());
            partStoresEAM.getDEFAULTBIN().setBIN(partStoreParam.getDefaultBin());
        }
        partStoresEAM.setLABELPRINTINGDEFAULT("");
        if (partStoreParam.getOrderQty() != null) {
            this.tools.getDataTypeTools();
            partStoresEAM.setORDERQTY(DataTypeTools.encodeAmount(partStoreParam.getOrderQty(), "Ordery Qty."));
        }
        if (partStoreParam.getReorderLevel() != null) {
            this.tools.getDataTypeTools();
            partStoresEAM.setREORDERLEVEL(DataTypeTools.encodeAmount(partStoreParam.getReorderLevel(), "Reorder Level"));
        }
        if (partStoreParam.getDefaultReturnBin() != null) {
            partStoresEAM.setDEFAULTRETURNBIN(new BINID_Type());
            partStoresEAM.getDEFAULTRETURNBIN().setBIN(partStoreParam.getDefaultReturnBin());
        }
        if (partStoreParam.getAbcClass() != null) {
            partStoresEAM.setABCCODE(partStoreParam.getAbcClass());
        }
        if (partStoreParam.getPreferredSupplier() != null) {
            partStoresEAM.setPREFERREDSUPPLIER(new SUPPLIERID_Type());
            partStoresEAM.getPREFERREDSUPPLIER().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresEAM.getPREFERREDSUPPLIER().setSUPPLIERCODE(partStoreParam.getPreferredSupplier());
        }
        if (partStoreParam.getStoreCode() != null) {
            partStoresEAM.setSTOREID(new STOREID_Type());
            partStoresEAM.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresEAM.getSTOREID().setSTORECODE(partStoreParam.getStoreCode());
        }
        if (partStoreParam.getPreventIssueFromDefaultReturnBin() != null) {
            partStoresEAM.setPREVENTISSUEDEFRTNBIN(partStoreParam.getPreventIssueFromDefaultReturnBin());
        } else {
            partStoresEAM.setPREVENTISSUEDEFRTNBIN("true");
        }
        if (partStoreParam.getPreferredStore() != null) {
            partStoresEAM.setPREFERREDSTORE(new STOREID_Type());
            partStoresEAM.getPREFERREDSTORE().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresEAM.getPREFERREDSTORE().setSTORECODE(partStoreParam.getPreferredStore());
        }
        if (partStoreParam.getMinimumQty() != null) {
            this.tools.getDataTypeTools();
            partStoresEAM.setMINIMUMQTY(DataTypeTools.encodeAmount(partStoreParam.getMinimumQty(), "Minimum Qty"));
        }
        if (partStoreParam.getStockMethod() != null) {
            partStoresEAM.setONDEMAND(partStoreParam.getStockMethod());
        }
        MP0255_AddPartStores_001 addPartStores = new MP0255_AddPartStores_001();
        addPartStores.setPartStores(partStoresEAM);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addPartStoresOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPartStores);
        return null;
    }
}

