/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders;

import ch.cern.eam.wshub.core.annotations.Operation;
import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.interceptors.LogDataReferenceType;
import ch.cern.eam.wshub.core.services.EAM_OPERATION;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.workorders.entities.MEC;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import net.datastream.schemas.mp_entities.workorderequipment_001.WorkOrderEquipment;

public interface MECService {
    public static final String EQUIPMENT_COLUMN_NAME = "equipment";
    public static final String MEC_ID_COLUMN_NAME = "relatedwo";
    public static final String GRID_ID = "WSJOBS_MEC";
    public static final String GRID_WO_TYPE = "BR";

    @Operation(logOperation=EAM_OPERATION.MEC_GET, logDataReference1=LogDataReferenceType.RESULT)
    public List<String> getWorkOrderMecIDList(EAMContext var1, String var2) throws EAMException;

    @Operation(logOperation=EAM_OPERATION.MEC_ADD_BATCH, logDataReference1=LogDataReferenceType.RESULT)
    public BatchResponse<String> addWorkOrderEquipmentBatch(EAMContext var1, List<MEC> var2) throws EAMException;

    @Operation(logOperation=EAM_OPERATION.MEC_GET_EAM, logDataReference1=LogDataReferenceType.RESULT)
    public WorkOrderEquipment getWorkOrderMecEAM(EAMContext var1, String var2) throws EAMException;

    @Operation(logOperation=EAM_OPERATION.MEC_ADD, logDataReference1=LogDataReferenceType.RESULT)
    public String addWorkOrderEquipment(EAMContext var1, MEC var2) throws EAMException;

    @Operation(logOperation=EAM_OPERATION.MEC_DELETE, logDataReference1=LogDataReferenceType.RESULT)
    public String deleteWorkOrderMEC(EAMContext var1, String var2, String var3) throws EAMException;

    @Operation(logOperation=EAM_OPERATION.MEC_SYNC, logDataReference1=LogDataReferenceType.RESULT)
    public String syncWorkOrderEquipment(EAMContext var1, MEC var2) throws EAMException;

    public static void validateInput(String workOrderID) throws EAMException {
        if (workOrderID == null) {
            throw Tools.generateFault("workOrderID or mecProperties cannot be null");
        }
    }

    public static void validateInput(MEC mecToAdd) throws EAMException {
        if (mecToAdd == null) {
            throw Tools.generateFault("mecToAdd cannot be null");
        }
    }

    public static void validateInput(String parentWorkorderID, String mecID) throws EAMException {
        if (parentWorkorderID == null || mecID == null) {
            throw Tools.generateFault("parentWorkorderID or mecID cannot be null");
        }
    }

    public static void validateInput(String parentWorkorderID, String mecID, MEC mecProperties) throws EAMException {
        if (parentWorkorderID == null || mecID == null || mecProperties == null) {
            throw Tools.generateFault("workorderID, mecID or mecProperties cannot be null");
        }
    }
}

