/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.entities;

import ch.cern.eam.wshub.core.adapters.BigDecimalAdapter;
import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.annotations.GridField;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;

@Entity
@Table(name="R5BOOKEDHOURS")
@NamedNativeQuery(name="LaborBooking.GETBOOKEDLABOR", query="select r5bookedhours.*, r5personnel.*, boo_date from r5bookedhours, r5personnel where r5bookedhours.boo_person = r5personnel.per_code and boo_event = :workOrder", resultClass=LaborBooking.class)
public class LaborBooking
implements Serializable,
Comparable<LaborBooking> {
    private static final long serialVersionUID = -7876074587300796418L;
    public static final String GETBOOKEDLABOR = "LaborBooking.GETBOOKEDLABOR";
    @Id
    @Column(name="BOO_CODE")
    private String code;
    @Column(name="BOO_OCRTYPE")
    @GridField(name="octype")
    private String typeOfHours;
    @Column(name="BOO_HOURS")
    @GridField(name="hours")
    private BigDecimal hoursWorked;
    @Column(name="BOO_ON")
    private BigDecimal startTime;
    @Column(name="BOO_OFF")
    private BigDecimal endTime;
    @Column(name="BOO_DATE")
    @GridField(name="boodate")
    private Date dateWorked;
    @Column(name="BOO_MRC")
    @GridField(name="department")
    private String departmentCode;
    @Column(name="BOO_PERSON")
    @GridField(name="employee")
    private String employeeCode;
    @Column(name="PER_DESC")
    @GridField(name="employeedesc")
    private String employeeDesc;
    @Column(name="BOO_ACT")
    @GridField(name="booactivity")
    private String activityCode;
    @Column(name="BOO_TRADE")
    @GridField(name="emptrade")
    private String tradeCode;
    @Column(name="BOO_EVENT")
    @GridField(name="event")
    private String workOrderNumber;

    public String getTypeOfHours() {
        return this.typeOfHours;
    }

    public void setTypeOfHours(String typeOfHours) {
        this.typeOfHours = typeOfHours;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getHoursWorked() {
        return this.hoursWorked;
    }

    public void setHoursWorked(BigDecimal hoursWorked) {
        this.hoursWorked = hoursWorked;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getDateWorked() {
        return this.dateWorked;
    }

    public void setDateWorked(Date dateWorked) {
        this.dateWorked = dateWorked;
    }

    public String getDepartmentCode() {
        return this.departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public String getEmployeeCode() {
        return this.employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getTradeCode() {
        return this.tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public BigDecimal getStartTime() {
        return this.startTime;
    }

    public void setStartTime(BigDecimal startTime) {
        this.startTime = startTime;
    }

    public BigDecimal getEndTime() {
        return this.endTime;
    }

    public void setEndTime(BigDecimal endTime) {
        this.endTime = endTime;
    }

    public String toString() {
        return "LaborBooking [" + (String)(this.typeOfHours != null ? "typeOfHours=" + this.typeOfHours + ", " : "") + (String)(this.hoursWorked != null ? "hoursWorked=" + String.valueOf(this.hoursWorked) + ", " : "") + (String)(this.dateWorked != null ? "dateWorked=" + String.valueOf(this.dateWorked) + ", " : "") + (String)(this.startTime != null ? "startTime=" + String.valueOf(this.startTime) + ", " : "") + (String)(this.endTime != null ? "endTime=" + String.valueOf(this.endTime) + ", " : "") + (String)(this.departmentCode != null ? "departmentCode=" + this.departmentCode + ", " : "") + (String)(this.employeeCode != null ? "employeeCode=" + this.employeeCode + ", " : "") + (String)(this.activityCode != null ? "activityCode=" + this.activityCode + ", " : "") + (String)(this.tradeCode != null ? "tradeCode=" + this.tradeCode + ", " : "") + (String)(this.workOrderNumber != null ? "workOrderNumber=" + this.workOrderNumber : "") + "]";
    }

    public String getEmployeeDesc() {
        return this.employeeDesc;
    }

    public void setEmployeeDesc(String employeeDesc) {
        this.employeeDesc = employeeDesc;
    }

    @Override
    public int compareTo(LaborBooking o) {
        return Comparator.comparing(LaborBooking::getActivityCode).thenComparing(LaborBooking::getDateWorked).thenComparing(LaborBooking::getEmployeeCode).compare(this, o);
    }
}

