/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.workorders.EmployeeService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import net.datastream.schemas.mp_entities.employee_001.Employee;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.Employee_Type;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_functions.mp7037_001.MP7037_GetEmployee_001;
import net.datastream.schemas.mp_functions.mp7038_001.MP7038_AddEmployee_001;
import net.datastream.schemas.mp_functions.mp7039_001.MP7039_SyncEmployee_001;
import net.datastream.schemas.mp_functions.mp7040_001.MP7040_DeleteEmployee_001;
import net.datastream.schemas.mp_results.mp7037_001.MP7037_GetEmployee_001_Result;
import net.datastream.schemas.mp_results.mp7038_001.MP7038_AddEmployee_001_Result;
import net.datastream.schemas.mp_results.mp7039_001.MP7039_SyncEmployee_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class EmployeeServiceImpl
implements EmployeeService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public EmployeeServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public BatchResponse<String> createEmployeeBatch(EAMContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.Employee> workOrderParam) {
        return this.tools.batchOperation(context, this::createEmployee, workOrderParam);
    }

    @Override
    public BatchResponse<String> updateEmployeeBatch(EAMContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.Employee> workOrders) {
        return this.tools.batchOperation(context, this::updateEmployee, workOrders);
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.Employee readEmployee(EAMContext context, String employeeCode) throws EAMException {
        MP7037_GetEmployee_001 request = new MP7037_GetEmployee_001();
        request.setEMPLOYEEID(new Employee_Type());
        request.getEMPLOYEEID().setEMPLOYEECODE(employeeCode);
        MP7037_GetEmployee_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), request);
        ch.cern.eam.wshub.core.services.workorders.entities.Employee employee = this.tools.getEAMFieldTools().transformEAMObject(new ch.cern.eam.wshub.core.services.workorders.entities.Employee(), result.getResultData().getEmployee(), context);
        employee.setSupervisor(employee.getUserDefinedFields().getUdfnum01());
        employee.setPersonID(employee.getUserDefinedFields().getUdfnum01());
        return employee;
    }

    @Override
    public String createEmployee(EAMContext context, ch.cern.eam.wshub.core.services.workorders.entities.Employee employee) throws EAMException {
        Employee eamEmployee = new Employee();
        this.populateEAMObject(eamEmployee, employee, context);
        MP7038_AddEmployee_001 request = new MP7038_AddEmployee_001();
        request.setEmployee(eamEmployee);
        MP7038_AddEmployee_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), request);
        return result.getResultData().getEMPLOYEEID().getEMPLOYEECODE();
    }

    @Override
    public String updateEmployee(EAMContext context, ch.cern.eam.wshub.core.services.workorders.entities.Employee employee) throws EAMException {
        MP7037_GetEmployee_001 readRequest = new MP7037_GetEmployee_001();
        readRequest.setEMPLOYEEID(new Employee_Type());
        readRequest.getEMPLOYEEID().setEMPLOYEECODE(employee.getCode());
        MP7037_GetEmployee_001_Result readResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), readRequest);
        Employee eamEmployee = readResult.getResultData().getEmployee();
        this.populateEAMObject(eamEmployee, employee, context);
        MP7039_SyncEmployee_001 syncRequest = new MP7039_SyncEmployee_001();
        syncRequest.setEmployee(eamEmployee);
        MP7039_SyncEmployee_001_Result syncResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncRequest);
        return syncResult.getResultData().getEmployee().getEMPLOYEEID().getEMPLOYEECODE();
    }

    @Override
    public String deleteEmployee(EAMContext context, String employeeCode) throws EAMException {
        MP7040_DeleteEmployee_001 request = new MP7040_DeleteEmployee_001();
        request.setEMPLOYEEID(new Employee_Type());
        request.getEMPLOYEEID().setEMPLOYEECODE(employeeCode);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), request);
        return employeeCode;
    }

    private void populateEAMObject(Employee eamEmployee, ch.cern.eam.wshub.core.services.workorders.entities.Employee employee, EAMContext context) throws EAMException {
        if (employee.getCode() != null && eamEmployee.getEMPLOYEEID() == null) {
            eamEmployee.setEMPLOYEEID(new Employee_Type());
            eamEmployee.getEMPLOYEEID().setEMPLOYEECODE(employee.getCode());
            eamEmployee.getEMPLOYEEID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (employee.getDescription() != null) {
            if (eamEmployee.getEMPLOYEEID() == null) {
                eamEmployee.setEMPLOYEEID(new Employee_Type());
            }
            eamEmployee.getEMPLOYEEID().setDESCRIPTION(employee.getDescription());
        }
        if (employee.getPhone() != null) {
            eamEmployee.setPHONE(employee.getPhone());
        }
        if (employee.getMobilePhone() != null) {
            eamEmployee.setMOBILEPHONENUMBER(employee.getMobilePhone());
        }
        if (employee.getAddress() != null) {
            eamEmployee.setADDRESS(employee.getAddress());
        }
        if (employee.getClazz() != null) {
            eamEmployee.setCLASSID(new CLASSID_Type());
            eamEmployee.getCLASSID().setCLASSCODE(employee.getClazz());
            eamEmployee.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (employee.getMRC() != null) {
            eamEmployee.setDEPARTMENTCODE(employee.getMRC());
        }
        if (employee.getEmail() != null) {
            eamEmployee.setEMAIL(employee.getEmail());
        }
        if (employee.getUserCode() != null) {
            eamEmployee.setUSERCODE(employee.getUserCode());
        }
        if (employee.getTrade() != null) {
            eamEmployee.setTRADECODE(employee.getTrade());
        }
        if (eamEmployee.getStandardUserDefinedFields() == null) {
            eamEmployee.setStandardUserDefinedFields(new StandardUserDefinedFields());
        }
        if (employee.getSupervisor() != null) {
            StandardUserDefinedFields standardUserDefinedFields = eamEmployee.getStandardUserDefinedFields();
            this.tools.getDataTypeTools();
            standardUserDefinedFields.setUDFNUM01(DataTypeTools.encodeQuantity(employee.getSupervisor(), "Supervisor"));
        }
        if (employee.getPersonID() != null) {
            StandardUserDefinedFields standardUserDefinedFields = eamEmployee.getStandardUserDefinedFields();
            this.tools.getDataTypeTools();
            standardUserDefinedFields.setUDFNUM02(DataTypeTools.encodeQuantity(employee.getPersonID(), "PersonID"));
        }
        if (employee.getDepartment() != null) {
            eamEmployee.getStandardUserDefinedFields().setUDFCHAR02(employee.getDepartment());
        }
        if (employee.getGroup() != null) {
            eamEmployee.getStandardUserDefinedFields().setUDFCHAR03(employee.getGroup());
        }
        if (employee.getSection() != null) {
            eamEmployee.getStandardUserDefinedFields().setUDFCHAR04(employee.getSection());
        }
        if (employee.getPreferredLanguage() != null) {
            eamEmployee.getStandardUserDefinedFields().setUDFCHAR05(employee.getPreferredLanguage());
        }
        if (employee.getAccountBlocked() != null) {
            eamEmployee.getStandardUserDefinedFields().setUDFCHKBOX01(employee.getAccountBlocked());
        }
        if (employee.getOutOfService() != null) {
            eamEmployee.setOUTOFSERVICE(employee.getOutOfService());
        }
    }
}

