/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.workorders.StandardWorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.entities.StandardWorkOrder;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_fields.STDWOID_Type;
import net.datastream.schemas.mp_functions.mp7079_001.MP7079_AddStandardWorkOrder_001;
import net.datastream.schemas.mp_functions.mp7080_001.MP7080_SyncStandardWorkOrder_001;
import net.datastream.schemas.mp_functions.mp7082_001.MP7082_GetStandardWorkOrder_001;
import net.datastream.schemas.mp_results.mp7079_001.MP7079_AddStandardWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp7082_001.MP7082_GetStandardWorkOrder_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class StandardWorkOrderServiceImpl
implements StandardWorkOrderService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public StandardWorkOrderServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public StandardWorkOrder readStandardWorkOrder(EAMContext context, String number) throws EAMException {
        return this.tools.getEAMFieldTools().transformEAMObject(new StandardWorkOrder(), this.readStandardWorkOrderEAM(context, number), context);
    }

    public net.datastream.schemas.mp_entities.standardworkorder_001.StandardWorkOrder readStandardWorkOrderEAM(EAMContext context, String number) throws EAMException {
        MP7082_GetStandardWorkOrder_001 getStandardWorkOrder = new MP7082_GetStandardWorkOrder_001();
        getStandardWorkOrder.setSTANDARDWO(new STDWOID_Type());
        getStandardWorkOrder.getSTANDARDWO().setORGANIZATIONID(this.tools.getOrganization(context));
        getStandardWorkOrder.getSTANDARDWO().setSTDWOCODE(number);
        MP7082_GetStandardWorkOrder_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getStandardWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getStandardWorkOrder);
        return result.getResultData().getStandardWorkOrder();
    }

    @Override
    public String createStandardWorkOrder(EAMContext context, StandardWorkOrder standardWorkOrder) throws EAMException {
        MP7079_AddStandardWorkOrder_001 addStandardWorkOrder = new MP7079_AddStandardWorkOrder_001();
        addStandardWorkOrder.setStandardWorkOrder(new net.datastream.schemas.mp_entities.standardworkorder_001.StandardWorkOrder());
        this.tools.getEAMFieldTools().transformWSHubObject(addStandardWorkOrder.getStandardWorkOrder(), standardWorkOrder, context);
        MP7079_AddStandardWorkOrder_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addStandardWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addStandardWorkOrder);
        return result.getResultData().getSTANDARDWO().getSTDWOCODE();
    }

    @Override
    public String updateStandardWorkOrder(EAMContext context, StandardWorkOrder standardWorkOrder) throws EAMException {
        net.datastream.schemas.mp_entities.standardworkorder_001.StandardWorkOrder eamStandardWorkOrder = this.readStandardWorkOrderEAM(context, standardWorkOrder.getCode());
        this.tools.getEAMFieldTools().transformWSHubObject(eamStandardWorkOrder, standardWorkOrder, context);
        MP7080_SyncStandardWorkOrder_001 syncStandardWorkOrder = new MP7080_SyncStandardWorkOrder_001();
        syncStandardWorkOrder.setStandardWorkOrder(eamStandardWorkOrder);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncStandardWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncStandardWorkOrder);
        return eamStandardWorkOrder.getSTANDARDWO().getSTDWOCODE();
    }
}

