/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.entities.BatchSingleResponse;
import ch.cern.eam.wshub.core.services.entities.Credentials;
import ch.cern.eam.wshub.core.services.entities.EntityOrganizationCodePair;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.CustomFieldsTools;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.EAMFieldTools;
import ch.cern.eam.wshub.core.tools.EAMOperation;
import ch.cern.eam.wshub.core.tools.ExceptionInfo;
import ch.cern.eam.wshub.core.tools.FieldDescriptionTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.WSHubOperation;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import net.datastream.schemas.mp_fields.BaseSchemaRequestElement;
import net.datastream.schemas.mp_fields.ESIGNATURE;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_functions.MessageConfigType;
import net.datastream.schemas.mp_functions.MessageItemConfigType;
import net.datastream.schemas.mp_functions.SessionType;
import net.datastream.wsdls.eamws.EAMWebServicesPT;
import org.w3c.dom.NodeList;
import org.xmlsoap.schemas.ws._2002._04.secext.ObjectFactory;
import org.xmlsoap.schemas.ws._2002._04.secext.Password;
import org.xmlsoap.schemas.ws._2002._04.secext.Security;
import org.xmlsoap.schemas.ws._2002._04.secext.Username;
import org.xmlsoap.schemas.ws._2002._04.secext.UsernameToken;

public class Tools {
    public static final String CACHE_SEPARATOR = "_";
    private ApplicationData applicationData;
    private EAMWebServicesPT eamws;
    private ExecutorService executorService;
    private DataSource dataSource;
    private EntityManagerFactory entityManagerFactory;
    private Logger logger;
    private CustomFieldsTools customFieldsTools;
    private DataTypeTools dataTypeTools;
    private FieldDescriptionTools fieldDescriptionsTools;
    private GridTools gridTools;
    private EAMFieldTools eamFieldTools;

    public Tools(ApplicationData applicationData, EAMWebServicesPT eamWebServicesToolkitClient, ExecutorService executorService, DataSource dataSource, EntityManagerFactory entityManagerFactory, Logger logger) {
        this.applicationData = applicationData;
        this.eamws = eamWebServicesToolkitClient;
        this.executorService = executorService;
        this.dataSource = dataSource;
        this.entityManagerFactory = entityManagerFactory;
        this.customFieldsTools = new CustomFieldsTools(this, applicationData, this.eamws);
        this.eamFieldTools = new EAMFieldTools(this.customFieldsTools, this);
        this.dataTypeTools = new DataTypeTools(this);
        this.fieldDescriptionsTools = new FieldDescriptionTools(this, applicationData, this.eamws);
        this.gridTools = new GridTools(this);
        this.logger = logger;
    }

    public EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public CustomFieldsTools getCustomFieldsTools() {
        return this.customFieldsTools;
    }

    public DataTypeTools getDataTypeTools() {
        return this.dataTypeTools;
    }

    public FieldDescriptionTools getFieldDescriptionsTools() {
        return this.fieldDescriptionsTools;
    }

    public GridTools getGridTools() {
        return this.gridTools;
    }

    public EAMFieldTools getEAMFieldTools() {
        return this.eamFieldTools;
    }

    public void log(Level logLevel, String message) {
        if (this.logger != null) {
            this.logger.log(logLevel, message);
        }
    }

    public Security createSecurityHeader(EAMContext context) throws EAMException {
        if (context == null || context.getCredentials() == null) {
            throw Tools.generateFault("Credentials must be initialized.");
        }
        ObjectFactory of = new ObjectFactory();
        Security security = of.createSecurity();
        Username un = of.createUsername();
        un.setValue(context.getCredentials().getUsername().toUpperCase() + "@" + this.getTenant(context));
        Password pass = of.createPassword();
        pass.setValue(context.getCredentials().getPassword());
        UsernameToken unt = of.createUsernameToken();
        unt.setPassword(pass);
        unt.setUsername(un);
        security.getAny().add(unt);
        return security;
    }

    public SessionType createEAMSession(EAMContext context) {
        SessionType session = new SessionType();
        if (context.getSessionID() != null) {
            session.setSessionId(context.getSessionID());
        } else if (context.getAuthToken() != null) {
            session.setSessionId("Bearer " + context.getAuthToken());
        }
        return session;
    }

    public MessageConfigType createMessageConfig() {
        MessageConfigType messageConfigType = new MessageConfigType();
        MessageItemConfigType returnAlertsMessageItemConfigType = new MessageItemConfigType();
        returnAlertsMessageItemConfigType.setName("returnAlerts");
        returnAlertsMessageItemConfigType.setValue("false");
        messageConfigType.getConfigItem().add(returnAlertsMessageItemConfigType);
        return messageConfigType;
    }

    public ORGANIZATIONID_Type getOrganization(EAMContext eamContext) {
        ORGANIZATIONID_Type org = new ORGANIZATIONID_Type();
        org.setORGANIZATIONCODE(this.getOrganizationCode(eamContext));
        return org;
    }

    public ORGANIZATIONID_Type getOrganization(EAMContext eamContext, String organizationCode) {
        ORGANIZATIONID_Type org = new ORGANIZATIONID_Type();
        org.setORGANIZATIONCODE(this.getOrganizationCode(eamContext, organizationCode));
        return org;
    }

    public String getOrganizationCode(EAMContext context, String organizationCode) {
        if (DataTypeTools.isNotEmpty(organizationCode)) {
            return organizationCode;
        }
        return this.getOrganizationCode(context);
    }

    public String getOrganizationCode(EAMContext eamContext) {
        if (eamContext != null && eamContext.getOrganizationCode() != null) {
            return eamContext.getOrganizationCode();
        }
        return this.applicationData.getOrganization();
    }

    public static String extractEntityCode(String code) {
        if (DataTypeTools.isNotEmpty(code) && code.contains("#")) {
            return code.split("#")[0];
        }
        return code;
    }

    public static String extractOrganizationCode(String code) {
        if (DataTypeTools.isNotEmpty(code) && code.contains("#") && code.split("#").length > 1) {
            return code.split("#")[1];
        }
        return null;
    }

    public static EntityOrganizationCodePair extractEntityOrganizationCodePair(String code) {
        if (DataTypeTools.isEmpty(code)) {
            return new EntityOrganizationCodePair();
        }
        String[] parts = code.split("#");
        if (parts.length == 1) {
            return new EntityOrganizationCodePair(code);
        }
        return new EntityOrganizationCodePair(parts[0], parts[1]);
    }

    public String getTenant(EAMContext eamContext) {
        if (eamContext != null && eamContext.getTenant() != null) {
            return eamContext.getTenant();
        }
        return this.applicationData.getTenant();
    }

    public static EAMException generateFault(String reason) {
        return new EAMException(reason, null, null);
    }

    public static EAMException generateFault(String reason, ExceptionInfo[] errors) {
        return new EAMException(reason, null, errors);
    }

    public <T> BatchResponse<T> processCallables(List<Callable<T>> mylist) {
        List responseList = null;
        try {
            List<Future<T>> result = this.executorService.invokeAll(mylist, 2L, TimeUnit.MINUTES);
            responseList = result.stream().map(future -> {
                try {
                    return new BatchSingleResponse(future.get(), null);
                }
                catch (ExecutionException exception) {
                    if (exception.getCause() instanceof SOAPFaultException) {
                        SOAPFaultException soapFaultException = (SOAPFaultException)exception.getCause();
                        return new BatchSingleResponse<Object>(null, this.decodeExceptionInfoList(soapFaultException));
                    }
                    return new BatchSingleResponse<Object>(null, exception.getCause().getMessage());
                }
                catch (Exception exception) {
                    return new BatchSingleResponse<Object>(null, "Server error");
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BatchResponse response = new BatchResponse();
        response.setResponseList(responseList);
        return response;
    }

    public void processRunnables(Runnable ... runnables) throws EAMException {
        this.processRunnables(Arrays.asList(runnables));
    }

    public void processRunnables(List<Runnable> mylist) throws EAMException {
        try {
            this.executorService.invokeAll(mylist.stream().map(runnable -> Executors.callable(runnable)).collect(Collectors.toList()), 2L, TimeUnit.MINUTES);
        }
        catch (Exception exception) {
            this.log(Level.SEVERE, "Error during Tools.processRunnables() execution: " + exception.getMessage());
        }
    }

    private String decodeExceptionInfoList(SOAPFaultException soapFaultException) {
        Object errorMessage = soapFaultException.getMessage();
        try {
            NodeList nodeList = soapFaultException.getFault().getDetail().getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                errorMessage = (String)errorMessage + ", " + nodeList.item(i).getFirstChild().getLastChild().getTextContent();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return errorMessage;
    }

    public EAMContext getEAMContext(Credentials credentials, String sessionID) {
        if (credentials != null) {
            return new EAMContext(credentials);
        }
        return new EAMContext(sessionID);
    }

    public EAMContext getEAMContext(Credentials credentials) {
        return new EAMContext(credentials);
    }

    public EAMContext getEAMContext(String username, String password) {
        Credentials credentials = new Credentials();
        credentials.setUsername(username);
        credentials.setPassword(password);
        return this.getEAMContext(credentials);
    }

    public void closeConnection(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(Level.SEVERE, "Couldn't close the DB connection: " + e.getMessage());
        }
    }

    public void demandDatabaseConnection() throws EAMException {
        if (this.entityManagerFactory == null || this.getDataSource() == null) {
            throw Tools.generateFault("This operation requires DB connection.");
        }
    }

    public boolean isDatabaseConnectionConfigured() {
        return this.entityManagerFactory != null && this.getDataSource() != null;
    }

    public <A, R> BatchResponse<R> batchOperation(EAMContext context, WSHubOperation<A, R> operation, List<A> arguments) {
        List callableList = arguments.stream().map(argument -> () -> operation.apply(context, argument)).collect(Collectors.toList());
        return this.processCallables(callableList);
    }

    public <A, R, T> Map<T, R> batchOperationToMap(List<A> arguments, BatchResponse<R> results, Map<T, A> map) {
        List responses = results.getResponseList().stream().map(response -> response.getResponse()).collect(Collectors.toList());
        if (arguments.size() != responses.size()) {
            throw new RuntimeException("The size of the results and the arguments does not match");
        }
        Function<Object, List> getKeysFromValue = value -> map.entrySet().stream().filter(entry -> entry.getValue() == value).map(entry -> entry.getKey()).collect(Collectors.toList());
        HashMap returnMap = new HashMap();
        for (int i = 0; i < responses.size(); ++i) {
            List keys = getKeysFromValue.apply(arguments.get(i));
            Object result = responses.get(i);
            keys.forEach(key -> returnMap.put(key, result));
        }
        return returnMap;
    }

    public <A, R> R performEAMOperation(EAMContext context, EAMOperation<A, R> operation, A argument) throws EAMException {
        Security security = null;
        String organization = this.getOrganizationCode(context);
        String sessionTerminationScenario = "terminate";
        Holder holder = null;
        MessageConfigType messageConfigType = this.createMessageConfig();
        if (context.getKeepSession() != null && context.getKeepSession().booleanValue()) {
            sessionTerminationScenario = null;
        }
        if (context.getCredentials() != null) {
            security = this.createSecurityHeader(context);
        } else {
            holder = new Holder((Object)this.createEAMSession(context));
        }
        if (argument instanceof BaseSchemaRequestElement && context.getSignature() != null) {
            ((BaseSchemaRequestElement)argument).setESIGNATURE(this.eamFieldTools.transformWSHubObject(new ESIGNATURE(), context.getSignature(), context));
        }
        String tenant = this.getTenant(context);
        return operation.apply(argument, organization, security, sessionTerminationScenario, holder, messageConfigType, tenant);
    }

    public static String getCacheKey(EAMContext eamContext, String ... parts) {
        String tenant = eamContext.getTenant();
        return Stream.concat(tenant != null ? Stream.of(tenant) : Stream.empty(), Arrays.stream(parts)).filter(Objects::nonNull).collect(Collectors.joining(CACHE_SEPARATOR));
    }

    public static String getCacheKeyWithLang(EAMContext eamContext, String ... parts) {
        String language = eamContext.getLanguage();
        return language == null ? Tools.getCacheKey(eamContext, parts) : Tools.getCacheKey(eamContext, (String[])Stream.concat(Stream.of(language), Arrays.stream(parts)).toArray(String[]::new));
    }
}

