/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.impl;

import ch.cern.eam.wshub.core.client.EAMClient;
import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.administration.impl.UserSetupServiceImpl;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridDDSpyFieldsResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridDataspy;
import ch.cern.eam.wshub.core.services.grids.entities.GridMetadataRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.CSVUtils;
import ch.cern.eam.wshub.core.services.grids.impl.EAMGrids;
import ch.cern.eam.wshub.core.services.grids.impl.JPAGrids;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.CacheKey;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class GridsServiceImpl
implements GridsService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private EAMGrids eamGrids;
    private JPAGrids jpaGrids;
    private ApplicationData applicationData;
    public static final Map<String, GridMetadataRequestResult> gridIdCache = new ConcurrentHashMap<String, GridMetadataRequestResult>();

    public GridsServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.applicationData = applicationData;
        this.eamGrids = new EAMGrids(applicationData, tools, this.eamws);
        if (tools.isDatabaseConnectionConfigured()) {
            this.jpaGrids = new JPAGrids(applicationData, tools, this.eamws);
        }
    }

    @Override
    public BatchResponse<GridRequestResult> executeQueryBatch(EAMContext context, List<GridRequest> gridRequests) throws EAMException {
        return this.tools.batchOperation(context, this::executeQuery, gridRequests);
    }

    @Override
    public GridRequestResult executeQuery(EAMContext context, GridRequest gridRequest) throws EAMException {
        if (gridRequest.getUseNative().booleanValue() || !this.tools.isDatabaseConnectionConfigured()) {
            return this.eamGrids.executeQuery(context, gridRequest);
        }
        this.tools.demandDatabaseConnection();
        if (DataTypeTools.isEmpty(gridRequest.getDataspyID()) || DataTypeTools.isEmpty(gridRequest.getGridID()) || DataTypeTools.isEmpty(gridRequest.getGridName())) {
            GridMetadataRequestResult gridMetadataEAM = this.getGridMetadataEAM(context, gridRequest.getGridName(), gridRequest.getGridID());
            gridRequest.setGridID(gridMetadataEAM.getGridCode());
            gridRequest.setGridName(gridMetadataEAM.getGridName());
            if (gridRequest.getDataspyID() == null) {
                gridRequest.setDataspyID(gridMetadataEAM.getDataSpyId());
            }
            if (gridRequest.getUserFunctionName() == null) {
                gridRequest.setUserFunctionName(gridMetadataEAM.getGridName());
            }
        }
        if (this.applicationData.getWithJPAGridsAuthentication().booleanValue()) {
            UserSetupServiceImpl.login(context, null, this.tools, this.eamws);
        }
        GridRequestResult gridRequestResult = this.jpaGrids.executeQuery(context, gridRequest);
        return gridRequestResult;
    }

    @Override
    public GridMetadataRequestResult getGridMetadataEAM(EAMContext context, String gridName) {
        return this.getGridMetadataEAM(context, gridName, null);
    }

    public GridMetadataRequestResult getGridMetadataEAM(EAMContext context, String gridName, String gridId) {
        String gridIdCacheKey = Tools.getCacheKey(context, gridName + "#" + gridId);
        Function<String, GridMetadataRequestResult> loader = key -> this.loadGridMetadataInfor(context, gridName, gridId);
        return Optional.ofNullable(EAMClient.cacheMap.get((Object)CacheKey.GRID_ID)).map(cache -> (GridMetadataRequestResult)cache.get((Object)gridIdCacheKey, loader)).orElseGet(() -> (GridMetadataRequestResult)loader.apply(gridIdCacheKey));
    }

    public GridMetadataRequestResult loadGridMetadataInfor(EAMContext context, String gridName, String gridId) {
        try {
            GridRequest gridRequest = new GridRequest("BEWSGR");
            gridRequest.setIncludeMetadata(true);
            gridRequest.setRowCount(1);
            if (gridName != null) {
                gridRequest.getGridRequestFilters().add(new GridRequestFilter("grd_gridname", gridName, "=", GridRequestFilter.JOINER.OR));
            }
            if (gridId != null) {
                gridRequest.getGridRequestFilters().add(new GridRequestFilter("grd_gridid", gridId, "="));
            }
            GridRequestResult result = this.eamGrids.executeQuery(context, gridRequest);
            GridMetadataRequestResult gridData = new GridMetadataRequestResult();
            gridData.setGridName(GridTools.getCellContent("grd_gridname", result.getRows()[0]));
            gridData.setGridCode(GridTools.getCellContent("grd_gridid", result.getRows()[0]));
            gridData.setDataSpyId(GridTools.getCellContent("dds_ddspyid", result.getRows()[0]).replaceAll(",", ""));
            return gridData;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public GridMetadataRequestResult getGridMetadata(EAMContext context, String gridCode, String viewType) throws EAMException {
        this.tools.demandDatabaseConnection();
        return this.getGridMetadata(context, gridCode, viewType, "EN");
    }

    @Override
    public GridMetadataRequestResult getGridMetadata(EAMContext context, String gridCode, String viewType, String language) throws EAMException {
        this.tools.demandDatabaseConnection();
        return this.jpaGrids.getGridMetadata(context, gridCode, viewType, language);
    }

    @Override
    public GridDDSpyFieldsResult getDDspyFields(EAMContext context, String gridCode, String viewType, String ddSpyId, String language) throws EAMException {
        this.tools.demandDatabaseConnection();
        return this.jpaGrids.getDDspyFields(context, gridCode, viewType, ddSpyId, language);
    }

    @Override
    public GridDataspy getDefaultDataspy(EAMContext context, String gridCode, String viewType) throws EAMException {
        this.tools.demandDatabaseConnection();
        return this.jpaGrids.getDefaultDataspy(context, gridCode, viewType);
    }

    @Override
    public String getGridCsvData(EAMContext context, GridRequest gridRequest) throws EAMException {
        gridRequest.setIncludeMetadata(true);
        GridRequestResult gridRequestResult = this.eamGrids.executeQuery(context, gridRequest);
        return CSVUtils.convertGridRequestResultToCsv(gridRequestResult);
    }
}

