/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens;

import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDTRow;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.ExceptionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UserDefinedTableValidator {
    private static final List<String> RESERVED_FIELD_NAMES = Arrays.asList("CREATED", "CREATEDBY", "UPDATED", "UPDATEDBY", "UPDATECOUNT");

    public static void validateOperation(String tableName, UDTRow rowsToInsert, UDTRow rowsToFilter) throws EAMException {
        UserDefinedTableValidator.validateOperation(tableName, rowsToInsert == null ? new ArrayList() : Collections.singletonList(rowsToInsert), rowsToFilter);
    }

    public static void validateOperation(String tableName, List<UDTRow> rowsToInsert) throws EAMException {
        UserDefinedTableValidator.validateOperation(tableName, rowsToInsert, null);
    }

    private static void validateOperation(String tableName, List<UDTRow> rowsToInsert, UDTRow rowsToFilter) throws EAMException {
        UserDefinedTableValidator.validateTableName(tableName);
        if (rowsToInsert != null) {
            for (UDTRow row : rowsToInsert) {
                UserDefinedTableValidator.validateKeyList(row.getAllKeys(), true);
            }
        }
        if (rowsToFilter != null) {
            UserDefinedTableValidator.validateKeyList(rowsToFilter.getAllKeys(), false);
        }
    }

    public static void validateKeyList(List<String> keyList, boolean insert) throws EAMException {
        for (String key : keyList) {
            UserDefinedTableValidator.validateColumnName(key);
            Set hashSet = keyList.stream().map(String::toUpperCase).collect(Collectors.toSet());
            if (keyList.size() != hashSet.size()) {
                String repeaters = keyList.stream().map(String::toUpperCase).filter(hashSet::contains).collect(Collectors.joining(","));
                throw UserDefinedTableValidator.generateEAMException("columnNames", "Repeated column names: " + repeaters);
            }
            if (!insert) continue;
            if (!hashSet.stream().anyMatch(RESERVED_FIELD_NAMES::contains)) continue;
            throw UserDefinedTableValidator.generateEAMException("columnNames", "Reserved field names cannot be used: " + hashSet.stream().filter(RESERVED_FIELD_NAMES::contains).collect(Collectors.joining(",")));
        }
    }

    public static EAMException generateEAMException(String field, String errorMessage) {
        return new EAMException(errorMessage, null, Collections.singleton(new ExceptionInfo(field, errorMessage)).toArray(new ExceptionInfo[0]));
    }

    private static void validateTableName(String name) throws EAMException {
        if (name == null) {
            throw UserDefinedTableValidator.generateEAMException("key", "Table name cannot be null");
        }
        if (!Pattern.matches("^[Uu]5[_A-Za-z0-9]+$", name)) {
            String errorMessage = "Invalid Table name: \"" + name + "\"";
            throw UserDefinedTableValidator.generateEAMException(name, errorMessage);
        }
    }

    private static void validateColumnName(String name) throws EAMException {
        if (name == null) {
            throw UserDefinedTableValidator.generateEAMException("key", "Column name cannot be null");
        }
        if (!Pattern.matches("^[_A-Za-z0-9]+$", name)) {
            String errorMessage = "Invalid Column name: \"" + name + "\"";
            throw UserDefinedTableValidator.generateEAMException(name, errorMessage);
        }
    }
}

