/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.entities;

import ch.cern.eam.wshub.core.adapters.BigDecimalAdapter;
import ch.cern.eam.wshub.core.adapters.BigIntegerAdapter;
import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.annotations.EAMField;
import ch.cern.eam.wshub.core.annotations.GridField;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignatureResult;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

@Entity
@NamedNativeQuery(name="FINDACT", query="select * from R5ACTIVITIES LEFT OUTER JOIN R5TASKS ON R5ACTIVITIES.ACT_TASK = R5TASKS.TSK_CODE WHERE ACT_EVENT = :workOrder ORDER BY ACT_ACT", resultClass=Activity.class)
@Table(name="R5ACTIVITIES")
public class Activity
implements Serializable {
    @Transient
    private static final long serialVersionUID = 2747408324574455910L;
    @Id
    @Column(name="ACT_ACT")
    @GridField(name="activity")
    @EAMField(xpath={"ACTIVITYID/ACTIVITYCODE/value"})
    private BigInteger activityCode;
    @Column(name="ACT_NOTE")
    @GridField(name="activitynote")
    @EAMField(xpath={"ACTIVITYID/ACTIVITYNOTE"}, nullifyParentLevel=0)
    private String activityNote;
    @Column(name="ACT_EVENT")
    @GridField(name="workordernum")
    @EAMField(xpath={"ACTIVITYID/WORKORDERID/JOBNUM"})
    private String workOrderNumber;
    @Column(name="ACT_PERSONS")
    @GridField(name="personsreq")
    @EAMField(xpath={"PERSONS"})
    private BigInteger peopleRequired;
    @Column(name="ACT_EST")
    @GridField(name="esthrs")
    @EAMField(xpath={"ESTIMATEDHOURS"})
    private BigDecimal estimatedHours;
    @Column(name="ACT_REM")
    @GridField(name="hrsremain")
    @EAMField(xpath={"HOURSREMAINING"})
    private BigDecimal hoursRemaining;
    @Column(name="ACT_START")
    @GridField(name="actstartdate")
    @EAMField(xpath={"ACTIVITYSTARTDATE"})
    private Date startDate;
    @Transient
    @GridField(name="actenddate")
    @EAMField(xpath={"ACTIVITYENDDATE"})
    private Date endDate;
    @Column(name="ACT_MATLIST")
    @GridField(name="matlcode")
    @EAMField(xpath={"MATLIST/MTLCODE"})
    private String materialList;
    @Column(name="ACT_TASK")
    @GridField(name="task")
    @EAMField(xpath={"TASKSID/TASKCODE"})
    private String taskCode;
    @Column(name="TSK_DESC")
    @EAMField(xpath={"TASKSID/DESCRIPTION"})
    private String taskDesc;
    @Column(name="TSK_REVISION")
    @GridField(name="taskrev")
    private String taskRev;
    @Column(name="ACT_TRADE")
    @GridField(name="trade")
    @EAMField(xpath={"TRADEID/TRADECODE"})
    private String tradeCode;
    @Column(name="ACT_QTY")
    @GridField(name="taskqty")
    @EAMField(xpath={"TASKSID/TASKQUANTITY"})
    private BigDecimal taskQty;
    @Transient
    private WorkOrderActivityCheckList[] checklists;
    @Transient
    private Map<String, WorkOrderActivityChecklistSignatureResult> signatures;
    @Transient
    private Boolean forceActivityExpansion;

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    @XmlJavaTypeAdapter(value=BigIntegerAdapter.class)
    public BigInteger getPeopleRequired() {
        return this.peopleRequired;
    }

    public void setPeopleRequired(BigInteger peopleRequired) {
        this.peopleRequired = peopleRequired;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getEstimatedHours() {
        return this.estimatedHours;
    }

    public void setEstimatedHours(BigDecimal estimatedHours) {
        this.estimatedHours = estimatedHours;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMaterialList() {
        return this.materialList;
    }

    public void setMaterialList(String materialList) {
        this.materialList = materialList;
    }

    public String getTaskCode() {
        return this.taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public String getTradeCode() {
        return this.tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getHoursRemaining() {
        return this.hoursRemaining;
    }

    public void setHoursRemaining(BigDecimal hoursRemaining) {
        this.hoursRemaining = hoursRemaining;
    }

    @XmlJavaTypeAdapter(value=BigIntegerAdapter.class)
    public BigInteger getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(BigInteger activityCode) {
        this.activityCode = activityCode;
    }

    public String getTaskDesc() {
        return this.taskDesc;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    public String getTaskRev() {
        return this.taskRev;
    }

    public void setTaskRev(String taskRev) {
        this.taskRev = taskRev;
    }

    public WorkOrderActivityCheckList[] getChecklists() {
        return this.checklists;
    }

    public void setChecklists(WorkOrderActivityCheckList[] checklists) {
        this.checklists = checklists;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getTaskQty() {
        return this.taskQty;
    }

    public void setTaskQty(BigDecimal taskQty) {
        this.taskQty = taskQty;
    }

    public String getActivityNote() {
        return this.activityNote;
    }

    public void setActivityNote(String activityNote) {
        this.activityNote = activityNote;
    }

    public Map<String, WorkOrderActivityChecklistSignatureResult> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(Map<String, WorkOrderActivityChecklistSignatureResult> signatures) {
        this.signatures = signatures;
    }

    public Boolean getForceActivityExpansion() {
        return this.forceActivityExpansion;
    }

    public void setForceActivityExpansion(Boolean forceActivityExpansion) {
        this.forceActivityExpansion = forceActivityExpansion;
    }

    public String toString() {
        return "Activity{activityCode='" + String.valueOf(this.activityCode) + "', activityNote='" + this.activityNote + "', workOrderNumber='" + this.workOrderNumber + "', peopleRequired='" + String.valueOf(this.peopleRequired) + "', estimatedHours='" + String.valueOf(this.estimatedHours) + "', hoursRemaining='" + String.valueOf(this.hoursRemaining) + "', startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", materialList='" + this.materialList + "', taskCode='" + this.taskCode + "', taskDesc='" + this.taskDesc + "', taskRev='" + this.taskRev + "', tradeCode='" + this.tradeCode + "', taskQty='" + String.valueOf(this.taskQty) + "', checklists=" + Arrays.toString(this.checklists) + "signatures=" + String.valueOf(this.signatures) + "}";
    }
}

