/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.workorders.CaseService;
import ch.cern.eam.wshub.core.services.workorders.entities.EAMCase;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.casemanagement_001.CaseDetails;
import net.datastream.schemas.mp_entities.casemanagement_001.CaseManagement;
import net.datastream.schemas.mp_entities.casemanagement_001.TrackingDetails;
import net.datastream.schemas.mp_fields.CASEID_Type;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.Employee_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDCODEID_Type;
import net.datastream.schemas.mp_functions.mp3640_001.MP3640_AddCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3641_001.MP3641_SyncCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3642_001.MP3642_DeleteCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3643_001.MP3643_GetCaseManagement_001;
import net.datastream.schemas.mp_results.mp3640_001.MP3640_AddCaseManagement_001_Result;
import net.datastream.schemas.mp_results.mp3641_001.MP3641_SyncCaseManagement_001_Result;
import net.datastream.schemas.mp_results.mp3643_001.MP3643_GetCaseManagement_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class CaseServiceImpl
implements CaseService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;

    public CaseServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
    }

    @Override
    public EAMCase readCase(EAMContext context, String caseID) throws EAMException {
        MP3643_GetCaseManagement_001 getCase = new MP3643_GetCaseManagement_001();
        getCase.setCASEID(new CASEID_Type());
        getCase.getCASEID().setCASECODE(caseID);
        getCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP3643_GetCaseManagement_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getCase);
        CaseManagement caseManagement = result.getResultData().getCaseManagement();
        EAMCase caseMT = this.tools.getEAMFieldTools().transformEAMObject(new EAMCase(), caseManagement, context);
        if (caseManagement.getCASEID() != null) {
            caseMT.setDescription(caseManagement.getCASEID().getDESCRIPTION());
            caseMT.setCode(caseManagement.getCASEID().getCASECODE());
        }
        if (caseManagement.getEQUIPMENTID() != null) {
            caseMT.setEquipmentCode(caseManagement.getEQUIPMENTID().getEQUIPMENTCODE());
            caseMT.setEquipmentDesc(caseManagement.getEQUIPMENTID().getDESCRIPTION());
        }
        if (caseManagement.getCASETYPE() != null) {
            caseMT.setTypeCode(caseManagement.getCASETYPE().getTYPECODE());
            caseMT.setTypeDesc(caseManagement.getCASETYPE().getDESCRIPTION());
        }
        if (caseManagement.getSTATUS() != null) {
            caseMT.setStatusCode(caseManagement.getSTATUS().getSTATUSCODE());
            caseMT.setStatusDesc(caseManagement.getSTATUS().getDESCRIPTION());
        }
        if (caseManagement.getDEPARTMENTID() != null) {
            caseMT.setDepartmentCode(caseManagement.getDEPARTMENTID().getDEPARTMENTCODE());
            caseMT.setDepartmentDesc(caseManagement.getDEPARTMENTID().getDESCRIPTION());
        }
        if (caseManagement.getTrackingDetails() != null && caseManagement.getTrackingDetails().getPERSONRESPONSIBLE() != null) {
            caseMT.setResponsibleCode(caseManagement.getTrackingDetails().getPERSONRESPONSIBLE().getEMPLOYEECODE());
            caseMT.setResponsibleDesc(caseManagement.getTrackingDetails().getPERSONRESPONSIBLE().getDESCRIPTION());
            caseMT.setResponsibleEMail(caseManagement.getTrackingDetails().getEMAIL());
        }
        if (caseManagement.getTrackingDetails() != null && caseManagement.getTrackingDetails().getASSIGNEDTO() != null) {
            caseMT.setAssignedToCode(caseManagement.getTrackingDetails().getASSIGNEDTO().getPERSONCODE());
            caseMT.setAssignedToDesc(caseManagement.getTrackingDetails().getASSIGNEDTO().getDESCRIPTION());
            caseMT.setAssignedToEMail(caseManagement.getTrackingDetails().getASSIGNEDTOEMAIL());
        }
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getCASECLASSID() != null) {
            caseMT.setClassCode(caseManagement.getCaseDetails().getCASECLASSID().getCLASSCODE());
            caseMT.setClassDesc(caseManagement.getCaseDetails().getCASECLASSID().getDESCRIPTION());
        }
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getWORKADDRESS() != null) {
            caseMT.setWorkaddress(caseManagement.getCaseDetails().getWORKADDRESS());
        }
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getCASEPRIORITY() != null) {
            caseMT.setPriority(caseManagement.getCaseDetails().getCASEPRIORITY().getUSERDEFINEDCODE());
        }
        caseMT.setCustomFields(this.tools.getCustomFieldsTools().readEAMCustomFields(caseManagement.getUSERDEFINEDAREA(), context));
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getLOCATIONID() != null) {
            caseMT.setLocationCode(caseManagement.getCaseDetails().getLOCATIONID().getLOCATIONCODE());
            caseMT.setLocationDesc(caseManagement.getCaseDetails().getLOCATIONID().getDESCRIPTION());
        }
        if (caseManagement.getTrackingDetails() != null) {
            this.tools.getDataTypeTools();
            caseMT.setScheduledStartDate(DataTypeTools.decodeEAMDate(caseManagement.getTrackingDetails().getSCHEDULEDSTARTDATE()));
            this.tools.getDataTypeTools();
            caseMT.setScheduledEndDate(DataTypeTools.decodeEAMDate(caseManagement.getTrackingDetails().getSCHEDULEDENDDATE()));
            this.tools.getDataTypeTools();
            caseMT.setRequestedStartDate(DataTypeTools.decodeEAMDate(caseManagement.getTrackingDetails().getREQUESTEDSTART()));
            this.tools.getDataTypeTools();
            caseMT.setRequestedEndDate(DataTypeTools.decodeEAMDate(caseManagement.getTrackingDetails().getREQUESTEDEND()));
            this.tools.getDataTypeTools();
            caseMT.setStartDate(DataTypeTools.decodeEAMDate(caseManagement.getTrackingDetails().getSTARTDATE()));
            this.tools.getDataTypeTools();
            caseMT.setCompletedDate(DataTypeTools.decodeEAMDate(caseManagement.getTrackingDetails().getCOMPLETEDDATE()));
            this.tools.getDataTypeTools();
            caseMT.setDaterequested(DataTypeTools.decodeEAMDate(caseManagement.getTrackingDetails().getDATEREQUESTED()));
        }
        if (caseManagement.getCREATEDBY() != null) {
            caseMT.setCreatedBy(caseManagement.getCREATEDBY().getUSERCODE());
        }
        if (caseManagement.getCREATEDDATE() != null) {
            this.tools.getDataTypeTools();
            caseMT.setCreateDate(DataTypeTools.decodeEAMDate(caseManagement.getCREATEDDATE()));
        }
        if (caseManagement.getDATEUPDATED() != null) {
            this.tools.getDataTypeTools();
            caseMT.setUpdatedDate(DataTypeTools.decodeEAMDate(caseManagement.getDATEUPDATED()));
        }
        if (caseManagement.getCaseDetails() != null) {
            this.tools.getDataTypeTools();
            caseMT.setEventstartdate(DataTypeTools.decodeEAMDate(caseManagement.getCaseDetails().getEVENTSTARTDATE()));
            this.tools.getDataTypeTools();
            caseMT.setEventenddate(DataTypeTools.decodeEAMDate(caseManagement.getCaseDetails().getEVENTENDDATE()));
        }
        if (caseManagement.getRecordid() != null) {
            caseMT.setUpdateCount(caseManagement.getRecordid());
        }
        return caseMT;
    }

    @Override
    public String createCase(EAMContext context, EAMCase caseMT) throws EAMException {
        CaseManagement caseManagement = new CaseManagement();
        caseManagement.setStandardUserDefinedFields(new StandardUserDefinedFields());
        caseManagement.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, null, caseManagement.getUSERDEFINEDAREA(), caseMT.getClassCode(), "CASE"));
        this.initCaseObject(caseManagement, caseMT, context);
        MP3640_AddCaseManagement_001 addCase = new MP3640_AddCaseManagement_001();
        addCase.setCaseManagement(caseManagement);
        MP3640_AddCaseManagement_001_Result addCaseResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addCase);
        return addCaseResult.getResultData().getCASEID().getCASECODE();
    }

    @Override
    public String deleteCase(EAMContext context, String caseID) throws EAMException {
        MP3642_DeleteCaseManagement_001 deleteCase = new MP3642_DeleteCaseManagement_001();
        deleteCase.setCASEID(new CASEID_Type());
        deleteCase.getCASEID().setCASECODE(caseID);
        deleteCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteCase);
        return caseID;
    }

    @Override
    public synchronized String updateCase(EAMContext context, EAMCase caseMT) throws EAMException {
        MP3643_GetCaseManagement_001 getCase = new MP3643_GetCaseManagement_001();
        getCase.setCASEID(new CASEID_Type());
        getCase.getCASEID().setCASECODE(caseMT.getCode());
        getCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP3643_GetCaseManagement_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getCase);
        CaseManagement caseManagement = result.getResultData().getCaseManagement();
        if (caseManagement.getRecordid().longValue() != caseMT.getUpdateCount()) {
            throw Tools.generateFault("The record has been updated by another user.");
        }
        caseManagement.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, caseManagement.getCaseDetails() != null ? DataTypeTools.toCodeString(caseManagement.getCaseDetails().getCASECLASSID()) : null, caseManagement.getUSERDEFINEDAREA(), caseMT.getClassCode(), "CASE"));
        this.initCaseObject(caseManagement, caseMT, context);
        MP3641_SyncCaseManagement_001 syncCase = new MP3641_SyncCaseManagement_001();
        syncCase.setCaseManagement(caseManagement);
        MP3641_SyncCaseManagement_001_Result syncCaseResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncCaseManagementOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncCase);
        return syncCaseResult.getResultData().getCASEID().getCASECODE();
    }

    private void initCaseObject(CaseManagement caseEAM, EAMCase caseMT, EAMContext context) throws EAMException {
        this.tools.getEAMFieldTools().transformWSHubObject(caseEAM, caseMT, context);
        if (caseEAM.getCASEID() == null) {
            caseEAM.setCASEID(new CASEID_Type());
            caseEAM.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
            caseEAM.getCASEID().setCASECODE("0");
        }
        if (caseMT.getDescription() != null) {
            caseEAM.getCASEID().setDESCRIPTION(caseMT.getDescription());
        }
        if (caseMT.getEquipmentCode() != null) {
            if (caseMT.getEquipmentCode().trim().equals("")) {
                caseEAM.setEQUIPMENTID(null);
            } else {
                caseEAM.setEQUIPMENTID(new EQUIPMENTID_Type());
                caseEAM.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                caseEAM.getEQUIPMENTID().setEQUIPMENTCODE(caseMT.getEquipmentCode().toUpperCase().trim());
            }
        }
        if (caseMT.getStatusCode() != null) {
            caseEAM.setSTATUS(new STATUS_Type());
            caseEAM.getSTATUS().setSTATUSCODE(caseMT.getStatusCode().toUpperCase().trim());
            caseEAM.setRSTATUS(new STATUS_Type());
            caseEAM.getRSTATUS().setSTATUSCODE(caseMT.getStatusCode().toUpperCase().trim());
        }
        if (caseMT.getTypeCode() != null) {
            caseEAM.setCASETYPE(new TYPE_Type());
            caseEAM.getCASETYPE().setTYPECODE(caseMT.getTypeCode().toUpperCase().trim());
        }
        if (caseMT.getDepartmentCode() != null) {
            caseEAM.setDEPARTMENTID(new DEPARTMENTID_Type());
            caseEAM.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            caseEAM.getDEPARTMENTID().setDEPARTMENTCODE(caseMT.getDepartmentCode().toUpperCase().trim());
        }
        if (caseMT.getClassCode() != null) {
            if (caseEAM.getCaseDetails() == null) {
                caseEAM.setCaseDetails(new CaseDetails());
            }
            if (caseEAM.getCaseDetails().getCASECLASSID() == null) {
                caseEAM.getCaseDetails().setCASECLASSID(new CLASSID_Type());
            }
            caseEAM.getCaseDetails().getCASECLASSID().setCLASSCODE(caseMT.getClassCode());
            caseEAM.getCaseDetails().getCASECLASSID().setDESCRIPTION(caseMT.getClassDesc());
            caseEAM.getCaseDetails().getCASECLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            if (caseMT.getPriority() != null) {
                USERDEFINEDCODEID_Type t = new USERDEFINEDCODEID_Type();
                caseEAM.getCaseDetails().setCASEPRIORITY(new USERDEFINEDCODEID_Type());
                caseEAM.getCaseDetails().getCASEPRIORITY().setUSERDEFINEDCODE(caseMT.getPriority());
            }
        }
        if (caseMT.getWorkaddress() != null) {
            if (caseEAM.getCaseDetails() == null) {
                caseEAM.setCaseDetails(new CaseDetails());
            }
            caseEAM.getCaseDetails().setWORKADDRESS(caseMT.getWorkaddress());
        }
        if (caseMT.getResponsibleCode() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            if (caseEAM.getTrackingDetails().getPERSONRESPONSIBLE() == null) {
                caseEAM.getTrackingDetails().setPERSONRESPONSIBLE(new Employee_Type());
            }
            caseEAM.getTrackingDetails().getPERSONRESPONSIBLE().setEMPLOYEECODE(caseMT.getResponsibleCode());
            caseEAM.getTrackingDetails().getPERSONRESPONSIBLE().setDESCRIPTION(caseMT.getResponsibleDesc());
            caseEAM.getTrackingDetails().setEMAIL(caseMT.getResponsibleEMail());
        }
        if (caseMT.getAssignedToCode() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            if (caseEAM.getTrackingDetails().getASSIGNEDTO() == null) {
                caseEAM.getTrackingDetails().setASSIGNEDTO(new PERSONID_Type());
            }
            caseEAM.getTrackingDetails().getASSIGNEDTO().setPERSONCODE(caseMT.getAssignedToCode());
            caseEAM.getTrackingDetails().getASSIGNEDTO().setDESCRIPTION(caseMT.getAssignedToDesc());
            caseEAM.getTrackingDetails().setASSIGNEDTOEMAIL(caseMT.getAssignedToEMail());
        }
        if (caseMT.getLocationCode() != null) {
            if (caseEAM.getCaseDetails() == null) {
                caseEAM.setCaseDetails(new CaseDetails());
            }
            if (caseMT.getLocationCode().equals("")) {
                caseEAM.getCaseDetails().setLOCATIONID(null);
            } else {
                caseEAM.getCaseDetails().setLOCATIONID(new LOCATIONID_Type());
                caseEAM.getCaseDetails().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                caseEAM.getCaseDetails().getLOCATIONID().setLOCATIONCODE(caseMT.getLocationCode().trim());
            }
        }
        if (caseMT.getScheduledStartDate() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setSCHEDULEDSTARTDATE(DataTypeTools.encodeEAMDate(caseMT.getScheduledStartDate(), "Scheduling Start Date"));
        }
        if (caseMT.getScheduledEndDate() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setSCHEDULEDENDDATE(DataTypeTools.encodeEAMDate(caseMT.getScheduledEndDate(), "Scheduling Completed Date"));
        }
        if (caseMT.getRequestedStartDate() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setREQUESTEDSTART(DataTypeTools.encodeEAMDate(caseMT.getRequestedStartDate(), "Requested Start Date"));
        }
        if (caseMT.getRequestedEndDate() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setREQUESTEDEND(DataTypeTools.encodeEAMDate(caseMT.getRequestedEndDate(), "Requested End Date"));
        }
        if (caseMT.getStartDate() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setSTARTDATE(DataTypeTools.encodeEAMDate(caseMT.getStartDate(), "Start Date"));
        }
        if (caseMT.getCompletedDate() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setCOMPLETEDDATE(DataTypeTools.encodeEAMDate(caseMT.getCompletedDate(), "Completed Date"));
        }
        if (caseMT.getDaterequested() != null) {
            if (caseEAM.getTrackingDetails() == null) {
                caseEAM.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseEAM.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setDATEREQUESTED(DataTypeTools.encodeEAMDate(caseMT.getDaterequested(), "Requested Date"));
        }
        if (caseMT.getEventstartdate() != null) {
            if (caseEAM.getCaseDetails() == null) {
                caseEAM.setCaseDetails(new CaseDetails());
            }
            CaseDetails caseDetails = caseEAM.getCaseDetails();
            this.tools.getDataTypeTools();
            caseDetails.setEVENTSTARTDATE(DataTypeTools.encodeEAMDate(caseMT.getEventstartdate(), "Event Start Date"));
        }
        if (caseMT.getEventenddate() != null) {
            if (caseEAM.getCaseDetails() == null) {
                caseEAM.setCaseDetails(new CaseDetails());
            }
            CaseDetails caseDetails = caseEAM.getCaseDetails();
            this.tools.getDataTypeTools();
            caseDetails.setEVENTENDDATE(DataTypeTools.encodeEAMDate(caseMT.getEventenddate(), "Event End Date"));
        }
    }
}

