/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.ChecklistService;
import ch.cern.eam.wshub.core.services.workorders.LaborBookingService;
import ch.cern.eam.wshub.core.services.workorders.TaskPlanService;
import ch.cern.eam.wshub.core.services.workorders.entities.Activity;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskPlan;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignatureResult;
import ch.cern.eam.wshub.core.services.workorders.impl.ChecklistServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.TaskPlanServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.laborbooking_001.LaborBooking;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.OCCUPATIONTYPEID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.TRADEID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0035_001.MP0035_GetActivity_001;
import net.datastream.schemas.mp_functions.mp0037_001.MP0037_AddActivity_001;
import net.datastream.schemas.mp_functions.mp0038_001.MP0038_SyncActivity_001;
import net.datastream.schemas.mp_functions.mp0039_001.MP0039_DeleteActivity_001;
import net.datastream.schemas.mp_functions.mp0042_001.MP0042_AddLaborBooking_001;
import net.datastream.schemas.mp_results.mp0035_001.MP0035_GetActivity_001_Result;
import net.datastream.schemas.mp_results.mp0037_001.MP0037_AddActivity_001_Result;
import net.datastream.schemas.mp_results.mp0038_001.MP0038_SyncActivity_001_Result;
import net.datastream.schemas.mp_results.mp0039_001.MP0039_DeleteActivity_001_Result;
import net.datastream.schemas.mp_results.mp0042_001.MP0042_AddLaborBooking_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class LaborBookingServiceImpl
implements LaborBookingService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private ChecklistService checklistService;
    private GridsService gridsService;
    private TaskPlanService taskPlanService;

    public LaborBookingServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.checklistService = new ChecklistServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
        this.gridsService = new GridsServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
        this.taskPlanService = new TaskPlanServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public List<ch.cern.eam.wshub.core.services.workorders.entities.LaborBooking> readLaborBookings(EAMContext context, String workOrderNumber) throws EAMException {
        GridRequest gridRequest = new GridRequest("WSJOBS_BOO");
        gridRequest.setUserFunctionName("WSJOBS");
        gridRequest.getParams().put("param.jobnum", workOrderNumber);
        gridRequest.getParams().put("param.headeractivity", "0");
        gridRequest.getParams().put("param.headerjob", "0");
        gridRequest.setRowCount(500);
        return GridTools.convertGridResultToObject(ch.cern.eam.wshub.core.services.workorders.entities.LaborBooking.class, null, this.gridsService.executeQuery(context, gridRequest));
    }

    @Override
    public String createLaborBooking(EAMContext context, ch.cern.eam.wshub.core.services.workorders.entities.LaborBooking laborBookingParam) throws EAMException {
        LaborBooking laborBookingEAM = new LaborBooking();
        if (laborBookingParam.getEmployeeCode() != null) {
            laborBookingEAM.setEMPLOYEE(new PERSONID_Type());
            laborBookingEAM.getEMPLOYEE().setPERSONCODE(laborBookingParam.getEmployeeCode());
        }
        if (laborBookingParam.getDepartmentCode() != null) {
            laborBookingEAM.setDEPARTMENTID(new DEPARTMENTID_Type());
            laborBookingEAM.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            laborBookingEAM.getDEPARTMENTID().setDEPARTMENTCODE(laborBookingParam.getDepartmentCode());
        }
        if (laborBookingParam.getDateWorked() != null) {
            this.tools.getDataTypeTools();
            laborBookingEAM.setDATEWORKED(DataTypeTools.encodeEAMDate(laborBookingParam.getDateWorked(), "Date Worked"));
        }
        if (laborBookingParam.getStartTime() != null) {
            this.tools.getDataTypeTools();
            laborBookingEAM.setSTARTTIME(DataTypeTools.encodeAmount(laborBookingParam.getStartTime(), "Start Time"));
        }
        if (laborBookingParam.getEndTime() != null) {
            this.tools.getDataTypeTools();
            laborBookingEAM.setENDTIME(DataTypeTools.encodeAmount(laborBookingParam.getEndTime(), "End Time"));
        }
        if (laborBookingParam.getHoursWorked() != null) {
            this.tools.getDataTypeTools();
            laborBookingEAM.setHOURSWORKED(DataTypeTools.encodeAmount(laborBookingParam.getHoursWorked(), "Hours Worked"));
        }
        this.tools.getDataTypeTools();
        laborBookingEAM.setTRADERATE(DataTypeTools.encodeAmount(BigDecimal.ZERO, "Trade Rate"));
        if (laborBookingParam.getTypeOfHours() != null) {
            laborBookingEAM.setOCCUPATIONTYPE(new OCCUPATIONTYPEID_Type());
            laborBookingEAM.getOCCUPATIONTYPE().setOCCUPATIONTYPECODE(laborBookingParam.getTypeOfHours());
        }
        if (laborBookingParam.getTradeCode() != null) {
            laborBookingEAM.setTRADEID(new TRADEID_Type());
            laborBookingEAM.getTRADEID().setORGANIZATIONID(this.tools.getOrganization(context));
            laborBookingEAM.getTRADEID().setTRADECODE(laborBookingParam.getTradeCode());
        }
        laborBookingEAM.setACTIVITYID(new ACTIVITYID());
        if (laborBookingParam.getActivityCode() != null) {
            laborBookingEAM.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
            laborBookingEAM.getACTIVITYID().getACTIVITYCODE().setValue(Long.parseLong(laborBookingParam.getActivityCode()));
        }
        if (laborBookingParam.getWorkOrderNumber() != null) {
            laborBookingEAM.getACTIVITYID().setWORKORDERID(new WOID_Type());
            laborBookingEAM.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
            laborBookingEAM.getACTIVITYID().getWORKORDERID().setJOBNUM(laborBookingParam.getWorkOrderNumber());
        }
        MP0042_AddLaborBooking_001 addLaborBoking = new MP0042_AddLaborBooking_001();
        addLaborBoking.setLaborBooking(laborBookingEAM);
        MP0042_AddLaborBooking_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addLaborBookingOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addLaborBoking);
        return laborBookingParam.getActivityCode();
    }

    @Override
    public Activity[] readActivities(EAMContext context, String workOrderNumber, Boolean includeChecklists) throws EAMException {
        try {
            GridRequest gridRequest = new GridRequest("WSJOBS_ACT");
            gridRequest.setRowCount(1000);
            gridRequest.setUserFunctionName("WSJOBS");
            gridRequest.getParams().put("param.jobnum", workOrderNumber);
            this.tools.getGridTools();
            List<Activity> activities = GridTools.convertGridResultToObject(Activity.class, null, this.gridsService.executeQuery(context, gridRequest));
            if (includeChecklists.booleanValue()) {
                List<Runnable> runnables = activities.stream().map(activity -> () -> {
                    try {
                        TaskPlan taskPlan = new TaskPlan();
                        taskPlan.setCode(activity.getTaskCode());
                        taskPlan = this.taskPlanService.getTaskPlan(context, taskPlan);
                        WorkOrderActivityChecklistSignatureResult[] signatures = this.checklistService.getSignatures(context, workOrderNumber, activity.getActivityCode().toString(), taskPlan);
                        if (signatures.length > 0) {
                            activity.setChecklists(this.checklistService.readWorkOrderChecklists(context, (Activity)activity));
                            if (taskPlan.getReviewedByRequired().booleanValue()) {
                                activity.setSignatures(Arrays.stream(signatures).collect(Collectors.toMap(WorkOrderActivityChecklistSignatureResult::getType, Function.identity())));
                            } else if (taskPlan.getPerformedByRequired().booleanValue()) {
                                activity.setSignatures(Arrays.stream(signatures).filter(signature -> !signature.getType().equals("RB01")).collect(Collectors.toMap(WorkOrderActivityChecklistSignatureResult::getType, Function.identity())));
                            }
                            activity.setForceActivityExpansion(taskPlan.getUserDefinedFields().getUdfchkbox03());
                        } else {
                            activity.setChecklists(new WorkOrderActivityCheckList[0]);
                        }
                    }
                    catch (Exception e) {
                        activity.setChecklists(new WorkOrderActivityCheckList[0]);
                    }
                }).collect(Collectors.toList());
                this.tools.processRunnables(runnables);
            }
            return (Activity[])activities.stream().toArray(Activity[]::new);
        }
        catch (Exception e) {
            throw Tools.generateFault("Couldn't fetch activities for this work order: " + e.getMessage());
        }
    }

    @Override
    public String createActivity(EAMContext context, Activity activityParam) throws EAMException {
        net.datastream.schemas.mp_entities.activity_001.Activity activityEAM = new net.datastream.schemas.mp_entities.activity_001.Activity();
        this.tools.getEAMFieldTools().transformWSHubObject(activityEAM, activityParam, context);
        if (DataTypeTools.isNotEmpty(activityParam.getTaskCode())) {
            activityEAM.getTASKSID().setTASKREVISION(Long.valueOf(0L));
        }
        MP0037_AddActivity_001 addActivity = new MP0037_AddActivity_001();
        addActivity.setActivity(activityEAM);
        MP0037_AddActivity_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addActivity);
        return "" + result.getResultData().getACTIVITYID().getACTIVITYCODE().getValue();
    }

    @Override
    public String updateActivity(EAMContext context, Activity activityParam) throws EAMException {
        return this.updateActivity(context, activityParam, null);
    }

    @Override
    public String updateActivity(EAMContext context, Activity activityParam, String confirmDeleteChecklist) throws EAMException {
        MP0035_GetActivity_001 getActivity = new MP0035_GetActivity_001();
        getActivity.setACTIVITYID(new ACTIVITYID());
        try {
            getActivity.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
            getActivity.getACTIVITYID().getACTIVITYCODE().setValue(Long.parseLong(activityParam.getActivityCode().toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        getActivity.getACTIVITYID().setWORKORDERID(new WOID_Type());
        getActivity.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        getActivity.getACTIVITYID().getWORKORDERID().setJOBNUM(activityParam.getWorkOrderNumber());
        MP0035_GetActivity_001_Result getresult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getActivity);
        net.datastream.schemas.mp_entities.activity_001.Activity activityEAM = getresult.getResultData().getActivity();
        this.tools.getEAMFieldTools().transformWSHubObject(activityEAM, activityParam, context);
        if (DataTypeTools.isNotEmpty(activityParam.getTaskCode())) {
            activityEAM.getTASKSID().setTASKREVISION(Long.valueOf(0L));
        }
        MP0038_SyncActivity_001 syncActivity = new MP0038_SyncActivity_001();
        syncActivity.setActivity(activityEAM);
        syncActivity.setConfirmadddeletechecklist(confirmDeleteChecklist);
        MP0038_SyncActivity_001_Result syncresult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncActivity);
        return "" + syncresult.getResultData().getACTIVITYID().getACTIVITYCODE().getValue();
    }

    @Override
    public String deleteActivity(EAMContext context, Activity activityParam) throws EAMException {
        MP0039_DeleteActivity_001 deleteActivity = new MP0039_DeleteActivity_001();
        deleteActivity.setACTIVITYID(new ACTIVITYID());
        deleteActivity.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        deleteActivity.getACTIVITYID().getACTIVITYCODE().setValue(activityParam.getActivityCode().longValue());
        deleteActivity.getACTIVITYID().setWORKORDERID(new WOID_Type());
        deleteActivity.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteActivity.getACTIVITYID().getWORKORDERID().setJOBNUM(activityParam.getWorkOrderNumber());
        deleteActivity.setConfirmdeletechecklist("true");
        MP0039_DeleteActivity_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteActivity);
        return "" + result.getResultData().getACTIVITYID().getACTIVITYCODE().getValue();
    }
}

