/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.CODEDESCFIELD;
import net.datastream.schemas.mp_fields.CUSTOMFIELD;
import net.datastream.schemas.mp_fields.ENTITYCODEFIELD;
import net.datastream.schemas.mp_fields.USERDEFINEDAREA;
import net.datastream.schemas.mp_functions.mp9501_001.CUSTOMFIELDREQ;
import net.datastream.schemas.mp_functions.mp9501_001.MP9501_GetCustomFields_001;
import net.datastream.schemas.mp_results.mp9501_001.MP9501_GetCustomFields_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class CustomFieldsTools {
    private Tools tools;
    private ApplicationData applicationData;
    private EAMWebServicesPT eamws;
    private static Map<String, String[][]> map;

    public CustomFieldsTools(Tools tools, ApplicationData applicationData, EAMWebServicesPT eamws) {
        this.tools = tools;
        this.applicationData = applicationData;
        this.eamws = eamws;
        map = new HashMap<String, String[][]>();
    }

    public CustomField decodeEAMCustomField(CUSTOMFIELD customFieldEAM, EAMContext eamContext) {
        CustomField customField = new CustomField();
        customField.setGroupLabel(customFieldEAM.getGROUPLABEL());
        customField.setClassCode(customFieldEAM.getCLASSID().getCLASSCODE());
        customField.setEntityCode(customFieldEAM.getEntity());
        customField.setCode(customFieldEAM.getPROPERTYCODE());
        customField.setType(customFieldEAM.getType());
        customField.setLabel(customFieldEAM.getPROPERTYLABEL());
        customField.setUOM(customFieldEAM.getUOM());
        customField.setMinValue(customFieldEAM.getMINVALUE());
        customField.setMaxValue(customFieldEAM.getMAXVALUE());
        if (customFieldEAM.getLOVSETTINGS() != null) {
            customField.setLovType(customFieldEAM.getLOVSETTINGS().getLOV_TYPE());
            customField.setLovValidate(customFieldEAM.getLOVSETTINGS().getLOV_VALIDATE());
        }
        if (customFieldEAM.getType().toUpperCase().equals("DATI") && customFieldEAM.getDATETIMEFIELD() != null) {
            customField.setValue(this.tools.getDataTypeTools().retrieveDate(customFieldEAM.getDATETIMEFIELD(), eamContext.getLocalizeResults() != false ? "dd-MMM-yyyy HH:mm" : "yyyy-MM-dd'T'HH:mm:ss.SSS"));
        } else if (customFieldEAM.getType().toUpperCase().equals("DATE") && customFieldEAM.getDATEFIELD() != null) {
            customField.setValue(this.tools.getDataTypeTools().retrieveDate(customFieldEAM.getDATEFIELD(), eamContext.getLocalizeResults() != false ? "dd-MMM-yyyy" : "yyyy-MM-dd'T'HH:mm:ss.SSS"));
        } else if (customFieldEAM.getType().toUpperCase().equals("RENT") && customFieldEAM.getENTITYCODEFIELD() != null) {
            customField.setValue(customFieldEAM.getENTITYCODEFIELD().getCODEVALUE());
            customField.setRentCodeValue(customFieldEAM.getENTITYCODEFIELD().getEntity());
            customField.setValueDesc(this.tools.getFieldDescriptionsTools().readCustomFieldDesc(customFieldEAM.getENTITYCODEFIELD().getEntity(), customFieldEAM.getENTITYCODEFIELD().getCODEVALUE()));
        } else if (customFieldEAM.getType().toUpperCase().equals("NUM") && customFieldEAM.getNUMBERFIELD() != null) {
            this.tools.getDataTypeTools();
            customField.setValue(DataTypeTools.decodeBigDecimal(DataTypeTools.decodeQuantity(customFieldEAM.getNUMBERFIELD())));
        } else if (customFieldEAM.getType().toUpperCase().equals("CODE") && customFieldEAM.getCODEDESCFIELD() != null) {
            customField.setValue(customFieldEAM.getCODEDESCFIELD().getCODEVALUE());
            customField.setValueDesc(customFieldEAM.getCODEDESCFIELD().getDESCRIPTION());
        } else if (customFieldEAM.getType().toUpperCase().equals("CHAR") && customFieldEAM.getTEXTFIELD() != null) {
            customField.setValue(customFieldEAM.getTEXTFIELD());
        }
        return customField;
    }

    public CUSTOMFIELD encodeEAMCustomField(CUSTOMFIELD customFieldEAM, CustomField customField) throws EAMException {
        if (customFieldEAM.getType().toUpperCase().equals("DATI") && customField.getValue() != null) {
            this.tools.getDataTypeTools();
            customFieldEAM.setDATETIMEFIELD(DataTypeTools.formatDate(customField.getValue(), "Custom field '" + customFieldEAM.getPROPERTYLABEL() + "'"));
        }
        if (customFieldEAM.getType().toUpperCase().equals("DATE") && customField.getValue() != null) {
            this.tools.getDataTypeTools();
            customFieldEAM.setDATEFIELD(DataTypeTools.formatDate(customField.getValue(), "Custom field '" + customFieldEAM.getPROPERTYLABEL() + "'"));
        }
        if (customFieldEAM.getType().toUpperCase().equals("RENT")) {
            customFieldEAM.setENTITYCODEFIELD(new ENTITYCODEFIELD());
            if (customField.getValue() != null) {
                customFieldEAM.getENTITYCODEFIELD().setCODEVALUE(customField.getValue());
            } else {
                customFieldEAM.getENTITYCODEFIELD().setCODEVALUE("");
            }
        }
        if (customFieldEAM.getType().toUpperCase().equals("NUM") && customField.getValue() != null) {
            this.tools.getDataTypeTools();
            customFieldEAM.setNUMBERFIELD(DataTypeTools.encodeQuantity(DataTypeTools.encodeBigDecimal(customField.getValue(), "Custom field '" + customFieldEAM.getPROPERTYLABEL() + "'"), "Custom field '" + customFieldEAM.getPROPERTYLABEL() + "'"));
        }
        if (customFieldEAM.getType().toUpperCase().equals("CODE") && customFieldEAM.getCODEDESCFIELD() != null) {
            customFieldEAM.setCODEDESCFIELD(new CODEDESCFIELD());
            if (customField.getValue() != null) {
                customFieldEAM.getCODEDESCFIELD().setCODEVALUE(customField.getValue());
            } else {
                customFieldEAM.getCODEDESCFIELD().setCODEVALUE("");
            }
        }
        if (customFieldEAM.getType().toUpperCase().equals("CHAR")) {
            customFieldEAM.setTEXTFIELD(customField.getValue());
        }
        return customFieldEAM;
    }

    public void updateEAMCustomFields(USERDEFINEDAREA userdefinedarea, CustomField[] customFields) throws EAMException {
        if (userdefinedarea == null || userdefinedarea.getCUSTOMFIELD() == null || userdefinedarea.getCUSTOMFIELD().size() == 0) {
            return;
        }
        userdefinedarea.getCUSTOMFIELD().forEach(cf -> cf.setChanged("false"));
        if (customFields == null || customFields.length == 0) {
            return;
        }
        Map wshubCustomFieldMap = Arrays.stream(customFields).filter(cf -> cf != null && cf.getCode() != null).collect(Collectors.groupingBy(CustomField::getCode, Collectors.toList()));
        userdefinedarea.getCUSTOMFIELD().removeIf(eamCustomField -> {
            List wshubCustomField = (List)wshubCustomFieldMap.get(eamCustomField.getPROPERTYCODE());
            if (wshubCustomField == null || wshubCustomField.size() == 0) {
                return false;
            }
            Optional<CustomField> cf = wshubCustomField.stream().filter(customField -> customField.getEntityCode() == null || eamCustomField.getEntity().equals(customField.getEntityCode())).findFirst();
            return cf.isPresent() && (cf.get().getValue() == null || "".equals(cf.get().getValue()));
        });
        for (CUSTOMFIELD eamCustomField2 : userdefinedarea.getCUSTOMFIELD()) {
            Optional<CustomField> wshubCustomField = ((List)wshubCustomFieldMap.getOrDefault(eamCustomField2.getPROPERTYCODE(), new ArrayList())).stream().filter(cf -> cf.getEntityCode() == null || cf.getEntityCode().equals(eamCustomField2.getEntity())).findFirst();
            if (!wshubCustomField.isPresent() || !this.hasChangedCustomField(eamCustomField2, wshubCustomField.get())) continue;
            this.encodeEAMCustomField(eamCustomField2, wshubCustomField.get());
            eamCustomField2.setChanged("true");
        }
    }

    private boolean hasChangedCustomField(CUSTOMFIELD customFieldEAM, CustomField customField) {
        switch (customFieldEAM.getType().toUpperCase()) {
            case "RENT": {
                if (customFieldEAM.getENTITYCODEFIELD() != null) {
                    return this.isDifferentValue(customFieldEAM.getENTITYCODEFIELD().getCODEVALUE(), customField.getValue());
                }
                return this.isDifferentValue(null, customField.getValue());
            }
            case "NUM": {
                String quantity = DataTypeTools.decodeBigDecimal(DataTypeTools.decodeQuantity(customFieldEAM.getNUMBERFIELD()));
                return this.isDifferentValue(quantity, customField.getValue());
            }
            case "CODE": {
                if (customFieldEAM.getCODEDESCFIELD() != null) {
                    return this.isDifferentValue(customFieldEAM.getCODEDESCFIELD().getCODEVALUE(), customField.getValue());
                }
                return this.isDifferentValue(null, customField.getValue());
            }
            case "CHAR": {
                return this.isDifferentValue(customFieldEAM.getTEXTFIELD(), customField.getValue());
            }
        }
        return true;
    }

    private boolean isDifferentValue(String value1, String value2) {
        if (value1 == null && value2 != null) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return true;
        }
        if (value1 == null && value2 == null) {
            return false;
        }
        return !value1.equals(value2);
    }

    public CustomField[] readEAMCustomFields(USERDEFINEDAREA userdefinedarea, EAMContext eamContext) {
        if (userdefinedarea == null || userdefinedarea.getCUSTOMFIELD() == null) {
            return new CustomField[0];
        }
        return (CustomField[])userdefinedarea.getCUSTOMFIELD().stream().sorted(Comparator.comparing(CUSTOMFIELD::getIndex)).map(cf -> this.decodeEAMCustomField((CUSTOMFIELD)cf, eamContext)).toArray(CustomField[]::new);
    }

    public USERDEFINEDAREA getEAMCustomFields(EAMContext context, String entity, String eamClass) throws EAMException {
        CUSTOMFIELDREQ cfreq = new CUSTOMFIELDREQ();
        cfreq.setORGANIZATIONID(this.tools.getOrganization(context));
        cfreq.setCLASSID(new CLASSID_Type());
        cfreq.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
        cfreq.getCLASSID().setCLASSCODE(eamClass);
        cfreq.setENTITYNAME(entity);
        MP9501_GetCustomFields_001 getcustomfields = new MP9501_GetCustomFields_001();
        getcustomfields.setCUSTOMFIELDREQ(cfreq);
        MP9501_GetCustomFields_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getCustomFieldsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getcustomfields);
        return result.getUSERDEFINEDAREA();
    }

    public CustomField[] getWSHubCustomFields(EAMContext context, String entity, String eamClass) throws EAMException {
        return this.readEAMCustomFields(this.getEAMCustomFields(context, entity, eamClass), context);
    }

    public USERDEFINEDAREA getEAMCustomFields(EAMContext context, String previousClass, USERDEFINEDAREA previousCustomFields, String targetClass, String entityType) throws EAMException {
        previousClass = previousClass == null ? null : previousClass.toUpperCase();
        String string = targetClass = targetClass == null ? null : targetClass.toUpperCase();
        if (previousCustomFields == null && previousClass != null) {
            throw new IllegalArgumentException("Unable to create an object that already has a previous class.");
        }
        if (targetClass != null) {
            String newClass = targetClass.length() == 0 ? "*" : targetClass;
            USERDEFINEDAREA classCustomFields = this.getEAMCustomFields(context, entityType, newClass);
            if (previousCustomFields == null) {
                return classCustomFields;
            }
            return this.merge(classCustomFields, previousCustomFields);
        }
        if (previousCustomFields != null) {
            return previousCustomFields;
        }
        return this.getEAMCustomFields(context, entityType, "*");
    }

    private USERDEFINEDAREA merge(USERDEFINEDAREA base, USERDEFINEDAREA toppings) {
        HashMap codeToTopping = new HashMap();
        toppings.getCUSTOMFIELD().stream().forEach(topping -> codeToTopping.put(topping.getPROPERTYCODE(), topping));
        base.getCUSTOMFIELD().stream().forEach(baseCustomField -> {
            CUSTOMFIELD toppingCustomField;
            CUSTOMFIELD sourceCustomField = toppingCustomField = (CUSTOMFIELD)codeToTopping.get(baseCustomField.getPROPERTYCODE());
            if (toppingCustomField == null) {
                sourceCustomField = baseCustomField;
            }
            baseCustomField.setPROPERTYCODE(sourceCustomField.getPROPERTYCODE());
            baseCustomField.setDATEFIELD(DataTypeTools.nonNullOrDefault(sourceCustomField.getDATEFIELD(), baseCustomField.getDATEFIELD()));
            baseCustomField.setDATETIMEFIELD(DataTypeTools.nonNullOrDefault(sourceCustomField.getDATETIMEFIELD(), baseCustomField.getDATETIMEFIELD()));
            baseCustomField.setNUMBERFIELD(DataTypeTools.nonNullOrDefault(sourceCustomField.getNUMBERFIELD(), baseCustomField.getNUMBERFIELD()));
            baseCustomField.setTEXTFIELD(DataTypeTools.nonNullOrDefault(sourceCustomField.getTEXTFIELD(), baseCustomField.getTEXTFIELD()));
            baseCustomField.setCODEDESCFIELD(DataTypeTools.nonNullOrDefault(sourceCustomField.getCODEDESCFIELD(), baseCustomField.getCODEDESCFIELD()));
            baseCustomField.setENTITYCODEFIELD(DataTypeTools.nonNullOrDefault(sourceCustomField.getENTITYCODEFIELD(), baseCustomField.getENTITYCODEFIELD()));
        });
        return base;
    }
}

