/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.javamerger;

import ch.cern.eam.javamerger.FILE_TYPE;
import ch.cern.eam.javamerger.JavaMergerException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class JavaMerger {
    private File outputDirectory;
    private String[] sourceFiles;
    private String destinationPackage;
    private String type;
    private String className;
    private String[] classAnnotations;
    private String[] additionalImports;

    private JavaMerger(File outputDirectory, String[] sourceFiles, String destinationPackage, String type, String className, String[] classAnnotations, String[] additionalImports) {
        this.outputDirectory = outputDirectory;
        this.sourceFiles = sourceFiles != null ? sourceFiles : new String[]{};
        this.destinationPackage = destinationPackage;
        this.type = type;
        this.className = className;
        this.classAnnotations = classAnnotations != null ? classAnnotations : new String[]{};
        this.additionalImports = additionalImports != null ? additionalImports : new String[]{};
    }

    public void merge() {
        File folder = new File(this.getGenerationFolderPath());
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try (FileWriter fw = new FileWriter(new File(this.getGeneratedFilePath()));){
            this.writeLine(fw, "package " + this.destinationPackage + ";");
            List<String> imports = this.getImports(this.sourceFiles, this.additionalImports);
            for (String importLine : imports) {
                this.writeLine(fw, importLine);
            }
            this.writeLine(fw, "");
            for (String classAnnotation : this.classAnnotations) {
                this.writeLine(fw, classAnnotation);
            }
            switch (FILE_TYPE.getByCode(this.type)) {
                case CLASS: {
                    this.writeLine(fw, "public class " + this.className + " {");
                    break;
                }
                case INTERFACE: {
                    this.writeLine(fw, "public interface " + this.className + " {");
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
            List<String> classBodies = this.getClassBodies(this.sourceFiles);
            for (String classBodyLine : classBodies) {
                this.writeLine(fw, classBodyLine);
            }
            this.writeLine(fw, "}");
        }
        catch (IOException e) {
            throw new JavaMergerException(e);
        }
    }

    private String getGeneratedFilePath() {
        return this.getGenerationFolderPath() + "/" + this.className + ".java";
    }

    public String getGenerationFolderPath() {
        return this.outputDirectory + "/" + this.destinationPackage.replace(".", "/");
    }

    private void writeLine(FileWriter fw, String line) {
        try {
            String lineBr = line + "\r\n";
            fw.write(lineBr);
        }
        catch (IOException e) {
            throw new JavaMergerException(e);
        }
    }

    private List<String> getImports(String[] filePaths, String[] additionalImports) {
        return Stream.concat(Stream.of(filePaths).map(this::getImports).flatMap(Collection::stream), Stream.of(additionalImports)).sorted().distinct().collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private List<String> getImports(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getClassBodies(String ... filePaths) {
        return Stream.of(filePaths).map(this::getClassBody).flatMap(Collection::stream).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private List<String> getClassBody(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Builder {
        private File outputDirectory;
        private String[] sourceFiles;
        private String destinationPackage;
        private String type;
        private String className;
        private String[] classAnnotations;
        private String[] additionalImports;

        public Builder withOutputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder withSourceFiles(String[] sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        public Builder withDestinationPackage(String destinationPackage) {
            this.destinationPackage = destinationPackage;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withClassName(String className) {
            this.className = className;
            return this;
        }

        public Builder withClassAnnotations(String[] classAnnotations) {
            this.classAnnotations = classAnnotations;
            return this;
        }

        public Builder withAdditionalImports(String[] additionalImports) {
            this.additionalImports = additionalImports;
            return this;
        }

        public JavaMerger build() {
            return new JavaMerger(this.outputDirectory, this.sourceFiles, this.destinationPackage, this.type, this.className, this.classAnnotations, this.additionalImports);
        }
    }
}

