/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.javamerger;

import ch.cern.eam.javamerger.JavaMerger;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="merge", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JavaMergerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/java-merger/", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(property="sourceFiles", required=true)
    private String[] sourceFiles;
    @Parameter(property="destinationPackage", required=true)
    private String destinationPackage;
    @Parameter(defaultValue="class", property="type", required=true)
    private String type;
    @Parameter(property="className", required=true)
    private String className;
    @Parameter(property="classAnnotations", required=false)
    private String[] classAnnotations;
    @Parameter(property="additionalImports", required=false)
    private String[] additionalImports;

    private void logInfo(String message) {
        this.getLog().info((CharSequence)("[java-merger] " + message));
    }

    public void execute() throws MojoExecutionException {
        this.logInfo("Merge of following files: ");
        for (String sourceFile : this.sourceFiles) {
            this.logInfo(" - " + sourceFile);
        }
        this.logInfo("Merge destination: " + this.destinationPackage);
        this.logInfo("Class name: " + this.className);
        this.logInfo("Type: " + this.type);
        JavaMerger merger = new JavaMerger.Builder().withOutputDirectory(this.outputDirectory).withSourceFiles(this.sourceFiles).withDestinationPackage(this.destinationPackage).withType(this.type).withClassName(this.className).withClassAnnotations(this.classAnnotations).withAdditionalImports(this.additionalImports).build();
        this.project.addCompileSourceRoot(merger.getGenerationFolderPath());
        try {
            merger.merge();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error while merging Java files", e);
        }
    }
}

