/*
 * Decompiled with CFR 0.152.
 */
package cern.entwined;

import cern.entwined.SemiPersistent;
import cern.entwined.Utils;
import com.google.common.base.Function;

public final class CompositeCollection
extends SemiPersistent<CompositeCollection> {
    private final SemiPersistent<SemiPersistent>[] references;
    private final boolean[] accessed;
    private final Function<Integer, SemiPersistent<SemiPersistent>> initialAccessor;

    public CompositeCollection(SemiPersistent ... references) {
        Utils.checkNull("References", references);
        if (0 == references.length) {
            throw new IllegalArgumentException("At least one reference must be specified");
        }
        for (int i = 0; i < references.length; ++i) {
            SemiPersistent value = references[i];
            if (null != value) continue;
            throw new IllegalArgumentException("Value at " + i + " is null");
        }
        this.references = this.copyReferences(references);
        this.accessed = new boolean[references.length];
        this.initialAccessor = new SimpleGet();
    }

    private CompositeCollection(CompositeCollection originalCollection, boolean cleanCopy) {
        this.references = this.copyReferences(originalCollection.references);
        if (cleanCopy) {
            this.initialAccessor = new CleanCopy();
            this.accessed = new boolean[originalCollection.accessed.length];
        } else {
            this.initialAccessor = new DirtyCopy();
            this.accessed = this.copyAccesses(originalCollection.accessed);
            for (int i = 0; i < this.references.length; ++i) {
                if (!this.accessed[i]) continue;
                this.references[i] = this.references[i].dirtyCopy();
            }
        }
    }

    private CompositeCollection(CompositeCollection localCollection, CompositeCollection globalState) {
        this.initialAccessor = new SimpleGet();
        this.references = this.copyReferences(globalState.references);
        this.accessed = new boolean[this.references.length];
        for (int i = 0; i < this.references.length; ++i) {
            if (!localCollection.accessed[i]) continue;
            this.references[i] = (SemiPersistent)localCollection.references[i].commit((SemiPersistent)globalState.unsafeGet(i));
        }
    }

    @Override
    public final CompositeCollection cleanCopy() {
        return new CompositeCollection(this, true);
    }

    @Override
    public final CompositeCollection dirtyCopy() {
        return new CompositeCollection(this, false);
    }

    @Override
    public void update(CompositeCollection changes, boolean onlyReadLogs) {
        Utils.checkNull("Updated collections", changes);
        for (int i = 0; i < this.references.length; ++i) {
            if (!changes.accessed[i]) continue;
            this.unsafeGet(i).update(changes.references[i], onlyReadLogs);
        }
    }

    @Override
    public final CompositeCollection commit(CompositeCollection globalState) {
        if (!this.isAccessed()) {
            return globalState;
        }
        return new CompositeCollection(this, globalState);
    }

    public final <T extends SemiPersistent> T get(int idx) {
        if (idx < 0 || idx >= this.references.length) {
            throw new IllegalArgumentException("Index " + idx + " is out of bounds");
        }
        return this.unsafeGet(idx);
    }

    private <T extends SemiPersistent> T unsafeGet(int idx) {
        if (this.accessed[idx]) {
            return (T)this.references[idx];
        }
        SemiPersistent value = (SemiPersistent)this.initialAccessor.apply((Object)idx);
        this.accessed[idx] = true;
        this.references[idx] = value;
        return (T)value;
    }

    private final SemiPersistent<SemiPersistent>[] copyReferences(SemiPersistent<SemiPersistent>[] source) {
        SemiPersistent[] copy = new SemiPersistent[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    private final boolean[] copyAccesses(boolean[] access) {
        boolean[] copy = new boolean[access.length];
        System.arraycopy(access, 0, copy, 0, access.length);
        return copy;
    }

    private final boolean isAccessed() {
        for (int i = 0; i < this.accessed.length; ++i) {
            if (!this.accessed[i]) continue;
            return true;
        }
        return false;
    }

    private class DirtyCopy
    implements Function<Integer, SemiPersistent<SemiPersistent>> {
        private DirtyCopy() {
        }

        public SemiPersistent<SemiPersistent> apply(Integer idx) {
            return (SemiPersistent)CompositeCollection.this.references[idx].dirtyCopy();
        }
    }

    private class CleanCopy
    implements Function<Integer, SemiPersistent<SemiPersistent>> {
        private CleanCopy() {
        }

        public SemiPersistent<SemiPersistent> apply(Integer idx) {
            return (SemiPersistent)CompositeCollection.this.references[idx].cleanCopy();
        }
    }

    private class SimpleGet
    implements Function<Integer, SemiPersistent<SemiPersistent>> {
        private SimpleGet() {
        }

        public SemiPersistent<SemiPersistent> apply(Integer idx) {
            return CompositeCollection.this.references[idx];
        }
    }
}

